{
    var _ns_ = {
        id: 'wisp.reader',
        doc: 'Reader module provides functions for reading text input\n  as wisp data structures'
    };
    var wisp_sequence = require('./sequence');
    var list = wisp_sequence.list;
    var isList = wisp_sequence.isList;
    var count = wisp_sequence.count;
    var isEmpty = wisp_sequence.isEmpty;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var map = wisp_sequence.map;
    var vec = wisp_sequence.vec;
    var cons = wisp_sequence.cons;
    var conj = wisp_sequence.conj;
    var rest = wisp_sequence.rest;
    var concat = wisp_sequence.concat;
    var last = wisp_sequence.last;
    var butlast = wisp_sequence.butlast;
    var sort = wisp_sequence.sort;
    var lazySeq = wisp_sequence.lazySeq;
    var reduce = wisp_sequence.reduce;
    var wisp_runtime = require('./runtime');
    var isOdd = wisp_runtime.isOdd;
    var dictionary = wisp_runtime.dictionary;
    var keys = wisp_runtime.keys;
    var isNil = wisp_runtime.isNil;
    var inc = wisp_runtime.inc;
    var dec = wisp_runtime.dec;
    var isVector = wisp_runtime.isVector;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isBoolean = wisp_runtime.isBoolean;
    var isObject = wisp_runtime.isObject;
    var isDictionary = wisp_runtime.isDictionary;
    var rePattern = wisp_runtime.rePattern;
    var reMatches = wisp_runtime.reMatches;
    var reFind = wisp_runtime.reFind;
    var str = wisp_runtime.str;
    var subs = wisp_runtime.subs;
    var char = wisp_runtime.char;
    var vals = wisp_runtime.vals;
    var isEqual = wisp_runtime.isEqual;
    var wisp_ast = require('./ast');
    var isSymbol = wisp_ast.isSymbol;
    var symbol = wisp_ast.symbol;
    var isKeyword = wisp_ast.isKeyword;
    var keyword = wisp_ast.keyword;
    var meta = wisp_ast.meta;
    var withMeta = wisp_ast.withMeta;
    var name = wisp_ast.name;
    var gensym = wisp_ast.gensym;
    var wisp_string = require('./string');
    var split = wisp_string.split;
    var join = wisp_string.join;
}
var pushBackReader = exports.pushBackReader = function pushBackReader(source, uri) {
    return {
        'lines': split(source, '\n'),
        'buffer': '',
        'uri': uri,
        'column': -1,
        'line': 0
    };
};
var peekChar = exports.peekChar = function peekChar(reader) {
    return function () {
        var lineø1 = (reader || 0)['lines'][(reader || 0)['line']];
        var columnø1 = inc((reader || 0)['column']);
        return isNil(lineø1) ? void 0 : lineø1[columnø1] || '\n';
    }.call(this);
};
var readChar = exports.readChar = function readChar(reader) {
    return function () {
        var chø1 = peekChar(reader);
        isNewline(peekChar(reader)) ? (function () {
            (reader || 0)['line'] = inc((reader || 0)['line']);
            return (reader || 0)['column'] = -1;
        })() : (reader || 0)['column'] = inc((reader || 0)['column']);
        return chø1;
    }.call(this);
};
var isNewline = exports.isNewline = function isNewline(ch) {
    return '\n' === ch;
};
var isBreakingWhitespace = exports.isBreakingWhitespace = function isBreakingWhitespace(ch) {
    return ch === ' ' || ch === '\t' || ch === '\n' || ch === '\r';
};
var isWhitespace = exports.isWhitespace = function isWhitespace(ch) {
    return isBreakingWhitespace(ch) || ',' === ch;
};
var isNumeric = exports.isNumeric = function isNumeric(ch) {
    return ch === '0' || ch === '1' || ch === '2' || ch === '3' || ch === '4' || ch === '5' || ch === '6' || ch === '7' || ch === '8' || ch === '9';
};
var isCommentPrefix = exports.isCommentPrefix = function isCommentPrefix(ch) {
    return ';' === ch;
};
var isNumberLiteral = exports.isNumberLiteral = function isNumberLiteral(reader, initch) {
    return isNumeric(initch) || ('+' === initch || '-' === initch) && isNumeric(peekChar(reader));
};
var readerError = exports.readerError = function readerError(reader, message) {
    return function () {
        var textø1 = '' + message + '\n' + 'line:' + (reader || 0)['line'] + '\n' + 'column:' + (reader || 0)['column'];
        var errorø1 = SyntaxError(textø1, (reader || 0)['uri']);
        errorø1.line = (reader || 0)['line'];
        errorø1.column = (reader || 0)['column'];
        errorø1.uri = (reader || 0)['uri'];
        return (function () {
            throw errorø1;
        })();
    }.call(this);
};
var isMacroTerminating = exports.isMacroTerminating = function isMacroTerminating(ch) {
    return !(ch === '#') && !(ch === '\'') && !(ch === ':') && macros(ch);
};
var readToken = exports.readToken = function readToken(reader, initch) {
    return function loop() {
        var recur = loop;
        var bufferø1 = initch;
        var chø1 = peekChar(reader);
        do {
            recur = isNil(chø1) || isWhitespace(chø1) || isMacroTerminating(chø1) ? bufferø1 : (loop[0] = '' + bufferø1 + readChar(reader), loop[1] = peekChar(reader), loop);
        } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var skipLine = exports.skipLine = function skipLine(reader, _) {
    return function loop() {
        var recur = loop;
        do {
            recur = function () {
                var chø1 = readChar(reader);
                return chø1 === '\n' || chø1 === '\r' || isNil(chø1) ? reader : (loop);
            }.call(this);
        } while (recur === loop);
        return recur;
    }.call(this);
};
var intPattern = exports.intPattern = rePattern('^([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?$');
var ratioPattern = exports.ratioPattern = rePattern('([-+]?[0-9]+)/([0-9]+)');
var floatPattern = exports.floatPattern = rePattern('([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?');
var matchInt = exports.matchInt = function matchInt(s) {
    return function () {
        var groupsø1 = reFind(intPattern, s);
        var group3ø1 = groupsø1[2];
        return !(isNil(group3ø1) || count(group3ø1) < 1) ? 0 : function () {
            var negateø1 = '-' === groupsø1[1] ? -1 : 1;
            var aø1 = groupsø1[3] ? [
                groupsø1[3],
                10
            ] : groupsø1[4] ? [
                groupsø1[4],
                16
            ] : groupsø1[5] ? [
                groupsø1[5],
                8
            ] : groupsø1[7] ? [
                groupsø1[7],
                parseInt(groupsø1[7])
            ] : 'else' ? [
                void 0,
                void 0
            ] : void 0;
            var nø1 = aø1[0];
            var radixø1 = aø1[1];
            return isNil(nø1) ? void 0 : negateø1 * parseInt(nø1, radixø1);
        }.call(this);
    }.call(this);
};
var matchRatio = exports.matchRatio = function matchRatio(s) {
    return function () {
        var groupsø1 = reFind(ratioPattern, s);
        var numinatorø1 = groupsø1[1];
        var denominatorø1 = groupsø1[2];
        return parseInt(numinatorø1) / parseInt(denominatorø1);
    }.call(this);
};
var matchFloat = exports.matchFloat = function matchFloat(s) {
    return parseFloat(s);
};
var matchNumber = exports.matchNumber = function matchNumber(s) {
    return reMatches(intPattern, s) ? matchInt(s) : reMatches(ratioPattern, s) ? matchRatio(s) : reMatches(floatPattern, s) ? matchFloat(s) : void 0;
};
var escapeCharMap = exports.escapeCharMap = function escapeCharMap(c) {
    return c === 't' ? '\t' : c === 'r' ? '\r' : c === 'n' ? '\n' : c === '\\' ? '\\' : c === '"' ? '"' : c === 'b' ? '\b' : c === 'f' ? '\f' : 'else' ? void 0 : void 0;
};
var read2Chars = exports.read2Chars = function read2Chars(reader) {
    return '' + readChar(reader) + readChar(reader);
};
var read4Chars = exports.read4Chars = function read4Chars(reader) {
    return '' + readChar(reader) + readChar(reader) + readChar(reader) + readChar(reader);
};
var unicode2Pattern = exports.unicode2Pattern = rePattern('[0-9A-Fa-f]{2}');
var unicode4Pattern = exports.unicode4Pattern = rePattern('[0-9A-Fa-f]{4}');
var validateUnicodeEscape = exports.validateUnicodeEscape = function validateUnicodeEscape(unicodePattern, reader, escapeChar, unicodeStr) {
    return reMatches(unicodePattern, unicodeStr) ? unicodeStr : readerError(reader, '' + 'Unexpected unicode escape ' + '\\' + escapeChar + unicodeStr);
};
var makeUnicodeChar = exports.makeUnicodeChar = function makeUnicodeChar(codeStr, base) {
    return function () {
        var baseø2 = base || 16;
        var codeø1 = parseInt(codeStr, baseø2);
        return char(codeø1);
    }.call(this);
};
var escapeChar = exports.escapeChar = function escapeChar(buffer, reader) {
    return function () {
        var chø1 = readChar(reader);
        var mapresultø1 = escapeCharMap(chø1);
        return mapresultø1 ? mapresultø1 : chø1 === 'x' ? makeUnicodeChar(validateUnicodeEscape(unicode2Pattern, reader, chø1, read2Chars(reader))) : chø1 === 'u' ? makeUnicodeChar(validateUnicodeEscape(unicode4Pattern, reader, chø1, read4Chars(reader))) : isNumeric(chø1) ? char(chø1) : 'else' ? readerError(reader, '' + 'Unexpected unicode escape ' + '\\' + chø1) : void 0;
    }.call(this);
};
var readPast = exports.readPast = function readPast(predicate, reader) {
    return function loop() {
        var recur = loop;
        var _ø1 = void 0;
        do {
            recur = predicate(peekChar(reader)) ? (loop[0] = readChar(reader), loop) : peekChar(reader);
        } while (_ø1 = loop[0], recur === loop);
        return recur;
    }.call(this);
};
var readDelimitedList = exports.readDelimitedList = function readDelimitedList(delim, reader, isRecursive) {
    return function loop() {
        var recur = loop;
        var formsø1 = [];
        do {
            recur = function () {
                var _ø1 = readPast(isWhitespace, reader);
                var chø1 = readChar(reader);
                !chø1 ? readerError(reader, 'EOF') : void 0;
                return delim === chø1 ? formsø1 : function () {
                    var formø1 = readForm(reader, chø1);
                    return loop[0] = formø1 === reader ? formsø1 : conj(formsø1, formø1), loop;
                }.call(this);
            }.call(this);
        } while (formsø1 = loop[0], recur === loop);
        return recur;
    }.call(this);
};
var notImplemented = exports.notImplemented = function notImplemented(reader, ch) {
    return readerError(reader, '' + 'Reader for ' + ch + ' not implemented yet');
};
var readDispatch = exports.readDispatch = function readDispatch(reader, _) {
    return function () {
        var chø1 = readChar(reader);
        var dmø1 = dispatchMacros(chø1);
        return dmø1 ? dmø1(reader, _) : function () {
            var objectø1 = maybeReadTaggedType(reader, chø1);
            return objectø1 ? objectø1 : readerError(reader, 'No dispatch macro for ', chø1);
        }.call(this);
    }.call(this);
};
var readUnmatchedDelimiter = exports.readUnmatchedDelimiter = function readUnmatchedDelimiter(rdr, ch) {
    return readerError(rdr, 'Unmatched delimiter ', ch);
};
var readList = exports.readList = function readList(reader, _) {
    return function () {
        var formø1 = readDelimitedList(')', reader, true);
        return withMeta(list.apply(void 0, formø1), meta(formø1));
    }.call(this);
};
var readComment = exports.readComment = function readComment(reader, _) {
    return function loop() {
        var recur = loop;
        var bufferø1 = '';
        var chø1 = readChar(reader);
        do {
            recur = isNil(chø1) || '\n' === chø1 ? reader || list(symbol(void 0, 'comment'), bufferø1) : '\\' === chø1 ? (loop[0] = '' + bufferø1 + escapeChar(bufferø1, reader), loop[1] = readChar(reader), loop) : 'else' ? (loop[0] = '' + bufferø1 + chø1, loop[1] = readChar(reader), loop) : void 0;
        } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var readVector = exports.readVector = function readVector(reader) {
    return readDelimitedList(']', reader, true);
};
var readMap = exports.readMap = function readMap(reader) {
    return function () {
        var formø1 = readDelimitedList('}', reader, true);
        return isOdd(count(formø1)) ? readerError(reader, 'Map literal must contain an even number of forms') : withMeta(dictionary.apply(void 0, formø1), meta(formø1));
    }.call(this);
};
var readSet = exports.readSet = function readSet(reader, _) {
    return function () {
        var formø1 = readDelimitedList('}', reader, true);
        return withMeta(concat([symbol(void 0, 'set')], formø1), meta(formø1));
    }.call(this);
};
var readNumber = exports.readNumber = function readNumber(reader, initch) {
    return function loop() {
        var recur = loop;
        var bufferø1 = initch;
        var chø1 = peekChar(reader);
        do {
            recur = isNil(chø1) || isWhitespace(chø1) || macros(chø1) ? (function () {
                var match = matchNumber(bufferø1);
                return isNil(match) ? readerError(reader, 'Invalid number format [', bufferø1, ']') : new Number(match);
            })() : (loop[0] = '' + bufferø1 + readChar(reader), loop[1] = peekChar(reader), loop);
        } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var readString = exports.readString = function readString(reader) {
    return function loop() {
        var recur = loop;
        var bufferø1 = '';
        var chø1 = readChar(reader);
        do {
            recur = isNil(chø1) ? readerError(reader, 'EOF while reading string') : '\\' === chø1 ? (loop[0] = '' + bufferø1 + escapeChar(bufferø1, reader), loop[1] = readChar(reader), loop) : '"' === chø1 ? new String(bufferø1) : 'default' ? (loop[0] = '' + bufferø1 + chø1, loop[1] = readChar(reader), loop) : void 0;
        } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var readCharacter = exports.readCharacter = function readCharacter(reader) {
    return new String(readChar(reader));
};
var readUnquote = exports.readUnquote = function readUnquote(reader) {
    return function () {
        var chø1 = peekChar(reader);
        return !chø1 ? readerError(reader, 'EOF while reading character') : chø1 === '@' ? (function () {
            readChar(reader);
            return list(symbol(void 0, 'unquote-splicing'), read(reader, true, void 0, true));
        })() : list(symbol(void 0, 'unquote'), read(reader, true, void 0, true));
    }.call(this);
};
var specialSymbols = exports.specialSymbols = function specialSymbols(text, notFound) {
    return text === 'nil' ? void 0 : text === 'true' ? true : text === 'false' ? false : 'else' ? notFound : void 0;
};
var readSymbol = exports.readSymbol = function readSymbol(reader, initch) {
    return function () {
        var tokenø1 = readToken(reader, initch);
        var partsø1 = split(tokenø1, '/');
        var hasNsø1 = count(partsø1) > 1 && count(tokenø1) > 1;
        var nsø1 = first(partsø1);
        var nameø1 = join('/', rest(partsø1));
        return hasNsø1 ? symbol(nsø1, nameø1) : specialSymbols(tokenø1, symbol(tokenø1));
    }.call(this);
};
var readKeyword = exports.readKeyword = function readKeyword(reader, initch) {
    return function () {
        var tokenø1 = readToken(reader, readChar(reader));
        var partsø1 = split(tokenø1, '/');
        var nameø1 = last(partsø1);
        var nsø1 = count(partsø1) > 1 ? join('/', butlast(partsø1)) : void 0;
        var issueø1 = last(nsø1) === ':' ? 'namespace can\'t ends with ":"' : last(nameø1) === ':' ? 'name can\'t end with ":"' : last(nameø1) === '/' ? 'name can\'t end with "/"' : count(split(tokenø1, '::')) > 1 ? 'name can\'t contain "::"' : void 0;
        return issueø1 ? readerError(reader, 'Invalid token (', issueø1, '): ', tokenø1) : !nsø1 && first(nameø1) === ':' ? keyword(rest(nameø1)) : keyword(nsø1, nameø1);
    }.call(this);
};
var desugarMeta = exports.desugarMeta = function desugarMeta(form) {
    return isKeyword(form) ? dictionary(name(form), true) : isSymbol(form) ? { 'tag': form } : isString(form) ? { 'tag': form } : isDictionary(form) ? reduce(function (result, pair) {
        (result || 0)[name(first(pair))] = second(pair);
        return result;
    }, {}, form) : 'else' ? form : void 0;
};
var wrappingReader = exports.wrappingReader = function wrappingReader(prefix) {
    return function (reader) {
        return list(prefix, read(reader, true, void 0, true));
    };
};
var throwingReader = exports.throwingReader = function throwingReader(msg) {
    return function (reader) {
        return readerError(reader, msg);
    };
};
var readMeta = exports.readMeta = function readMeta(reader, _) {
    return function () {
        var metadataø1 = desugarMeta(read(reader, true, void 0, true));
        !isDictionary(metadataø1) ? readerError(reader, 'Metadata must be Symbol, Keyword, String or Map') : void 0;
        return function () {
            var formø1 = read(reader, true, void 0, true);
            return isObject(formø1) ? withMeta(formø1, conj(metadataø1, meta(formø1))) : formø1;
        }.call(this);
    }.call(this);
};
var readRegex = exports.readRegex = function readRegex(reader) {
    return function loop() {
        var recur = loop;
        var bufferø1 = '';
        var chø1 = readChar(reader);
        do {
            recur = isNil(chø1) ? readerError(reader, 'EOF while reading string') : '\\' === chø1 ? (loop[0] = '' + bufferø1 + chø1 + readChar(reader), loop[1] = readChar(reader), loop) : '"' === chø1 ? rePattern(bufferø1) : 'default' ? (loop[0] = '' + bufferø1 + chø1, loop[1] = readChar(reader), loop) : void 0;
        } while (bufferø1 = loop[0], chø1 = loop[1], recur === loop);
        return recur;
    }.call(this);
};
var readParam = exports.readParam = function readParam(reader, initch) {
    return function () {
        var formø1 = readSymbol(reader, initch);
        return isEqual(formø1, symbol('%')) ? symbol('%1') : formø1;
    }.call(this);
};
var isParam = exports.isParam = function isParam(form) {
    return isSymbol(form) && '%' === first(name(form));
};
var lambdaParamsHash = exports.lambdaParamsHash = function lambdaParamsHash(form) {
    return isParam(form) ? dictionary(form, form) : isDictionary(form) || isVector(form) || isList(form) ? conj.apply(void 0, map(lambdaParamsHash, vec(form))) : 'else' ? {} : void 0;
};
var lambdaParams = exports.lambdaParams = function lambdaParams(body) {
    return function () {
        var namesø1 = sort(vals(lambdaParamsHash(body)));
        var variadicø1 = isEqual(first(namesø1), symbol('%&'));
        var nø1 = variadicø1 && count(namesø1) === 1 ? 0 : parseInt(rest(name(last(namesø1))));
        var paramsø1 = function loop() {
            var recur = loop;
            var namesø2 = [];
            var iø1 = 1;
            do {
                recur = iø1 <= nø1 ? (loop[0] = conj(namesø2, symbol('' + '%' + iø1)), loop[1] = inc(iø1), loop) : namesø2;
            } while (namesø2 = loop[0], iø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
        return variadicø1 ? conj(paramsø1, symbol(void 0, '&'), symbol(void 0, '%&')) : namesø1;
    }.call(this);
};
var readLambda = exports.readLambda = function readLambda(reader) {
    return function () {
        var bodyø1 = readList(reader);
        return list(symbol(void 0, 'fn'), lambdaParams(bodyø1), bodyø1);
    }.call(this);
};
var readDiscard = exports.readDiscard = function readDiscard(reader, _) {
    read(reader, true, void 0, true);
    return reader;
};
var macros = exports.macros = function macros(c) {
    return c === '"' ? readString : c === '\\' ? readCharacter : c === ':' ? readKeyword : c === ';' ? readComment : c === '\'' ? wrappingReader(symbol(void 0, 'quote')) : c === '@' ? wrappingReader(symbol(void 0, 'deref')) : c === '^' ? readMeta : c === '`' ? wrappingReader(symbol(void 0, 'syntax-quote')) : c === '~' ? readUnquote : c === '(' ? readList : c === ')' ? readUnmatchedDelimiter : c === '[' ? readVector : c === ']' ? readUnmatchedDelimiter : c === '{' ? readMap : c === '}' ? readUnmatchedDelimiter : c === '%' ? readParam : c === '#' ? readDispatch : 'else' ? void 0 : void 0;
};
var dispatchMacros = exports.dispatchMacros = function dispatchMacros(s) {
    return s === '{' ? readSet : s === '(' ? readLambda : s === '<' ? throwingReader('Unreadable form') : s === '"' ? readRegex : s === '!' ? readComment : s === '_' ? readDiscard : 'else' ? void 0 : void 0;
};
var readForm = exports.readForm = function readForm(reader, ch) {
    return function () {
        var startø1 = {
            'line': (reader || 0)['line'],
            'column': (reader || 0)['column']
        };
        var readMacroø1 = macros(ch);
        var formø1 = readMacroø1 ? readMacroø1(reader, ch) : isNumberLiteral(reader, ch) ? readNumber(reader, ch) : 'else' ? readSymbol(reader, ch) : void 0;
        var endø1 = {
            'line': (reader || 0)['line'],
            'column': inc((reader || 0)['column'])
        };
        var locationø1 = {
            'uri': (reader || 0)['uri'],
            'start': startø1,
            'end': endø1
        };
        return formø1 === reader ? formø1 : !(isBoolean(formø1) || isNil(formø1) || isKeyword(formø1)) ? withMeta(formø1, conj(locationø1, meta(formø1))) : 'else' ? formø1 : void 0;
    }.call(this);
};
var read = exports.read = function read(reader, eofIsError, sentinel, isRecursive) {
    return function loop() {
        var recur = loop;
        do {
            recur = function () {
                var chø1 = readChar(reader);
                var formø1 = isNil(chø1) ? eofIsError ? readerError(reader, 'EOF') : sentinel : isWhitespace(chø1) ? reader : isCommentPrefix(chø1) ? read(readComment(reader, chø1), eofIsError, sentinel, isRecursive) : 'else' ? readForm(reader, chø1) : void 0;
                return formø1 === reader ? (loop) : formø1;
            }.call(this);
        } while (recur === loop);
        return recur;
    }.call(this);
};
var read_ = exports.read_ = function read_(source, uri) {
    return function () {
        var readerø1 = pushBackReader(source, uri);
        var eofø1 = gensym();
        return function loop() {
            var recur = loop;
            var formsø1 = [];
            var formø1 = read(readerø1, false, eofø1, false);
            do {
                recur = formø1 === eofø1 ? formsø1 : (loop[0] = conj(formsø1, formø1), loop[1] = read(readerø1, false, eofø1, false), loop);
            } while (formsø1 = loop[0], formø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    }.call(this);
};
var readFromString = exports.readFromString = function readFromString(source, uri) {
    return function () {
        var readerø1 = pushBackReader(source, uri);
        return read(readerø1, true, void 0, false);
    }.call(this);
};
var readUuid = function readUuid(uuid) {
    return isString(uuid) ? list.apply(void 0, [symbol(void 0, 'UUID.')].concat([uuid])) : readerError(void 0, 'UUID literal expects a string as its representation.');
};
var readQueue = function readQueue(items) {
    return isVector(items) ? list.apply(void 0, [symbol(void 0, 'PersistentQueue.')].concat([items])) : readerError(void 0, 'Queue literal expects a vector for its elements.');
};
var __tagTable__ = exports.__tagTable__ = dictionary('uuid', readUuid, 'queue', readQueue);
var maybeReadTaggedType = exports.maybeReadTaggedType = function maybeReadTaggedType(reader, initch) {
    return function () {
        var tagø1 = readSymbol(reader, initch);
        var pfnø1 = (__tagTable__ || 0)[name(tagø1)];
        return pfnø1 ? pfnø1(read(reader, true, void 0, false)) : readerError(reader, '' + 'Could not find tag parser for ' + name(tagø1) + ' in ' + ('' + keys(__tagTable__)));
    }.call(this);
};
//# sourceMappingURL=data:application/json;base64,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
