{
    var _ns_ = {
        id: 'wisp.backend.javascript.writer',
        doc: 'Compiler backend for for writing JS output'
    };
    var wisp_ast = require('./../../ast');
    var name = wisp_ast.name;
    var namespace = wisp_ast.namespace;
    var symbol = wisp_ast.symbol;
    var isSymbol = wisp_ast.isSymbol;
    var isKeyword = wisp_ast.isKeyword;
    var wisp_sequence = require('./../../sequence');
    var list = wisp_sequence.list;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var isList = wisp_sequence.isList;
    var vec = wisp_sequence.vec;
    var map = wisp_sequence.map;
    var count = wisp_sequence.count;
    var last = wisp_sequence.last;
    var reduce = wisp_sequence.reduce;
    var isEmpty = wisp_sequence.isEmpty;
    var wisp_runtime = require('./../../runtime');
    var isTrue = wisp_runtime.isTrue;
    var isNil = wisp_runtime.isNil;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isVector = wisp_runtime.isVector;
    var isDictionary = wisp_runtime.isDictionary;
    var isBoolean = wisp_runtime.isBoolean;
    var isRePattern = wisp_runtime.isRePattern;
    var reFind = wisp_runtime.reFind;
    var dec = wisp_runtime.dec;
    var subs = wisp_runtime.subs;
    var isEqual = wisp_runtime.isEqual;
    var wisp_string = require('./../../string');
    var replace = wisp_string.replace;
    var join = wisp_string.join;
    var split = wisp_string.split;
    var upperCase = wisp_string.upperCase;
}
var writeReference = exports.writeReference = function writeReference(form) {
    'Translates references from clojure convention to JS:\n\n  **macros**      __macros__\n  list->vector    listToVector\n  set!            set\n  foo_bar         foo_bar\n  number?         isNumber\n  create-server   createServer';
    return function () {
        var idø1 = name(form);
        idø1 = idø1 === '*' ? 'multiply' : idø1 === '/' ? 'divide' : idø1 === '+' ? 'sum' : idø1 === '-' ? 'subtract' : idø1 === '=' ? 'equal?' : idø1 === '==' ? 'strict-equal?' : idø1 === '<=' ? 'not-greater-than' : idø1 === '>=' ? 'not-less-than' : idø1 === '>' ? 'greater-than' : idø1 === '<' ? 'less-than' : idø1 === '->' ? 'thread-first' : 'else' ? idø1 : void 0;
        idø1 = join('_', split(idø1, '*'));
        idø1 = join('-to-', split(idø1, '->'));
        idø1 = join(split(idø1, '!'));
        idø1 = join('$', split(idø1, '%'));
        idø1 = join('-plus-', split(idø1, '+'));
        idø1 = join('-and-', split(idø1, '&'));
        idø1 = last(idø1) === '?' ? '' + 'is-' + subs(idø1, 0, dec(count(idø1))) : idø1;
        idø1 = reduce(function (result, key) {
            return '' + result + (!isEmpty(result) && !isEmpty(key) ? '' + upperCase((key || 0)[0]) + subs(key, 1) : key);
        }, '', split(idø1, '-'));
        return idø1;
    }.call(this);
};
var writeKeywordReference = exports.writeKeywordReference = function writeKeywordReference(form) {
    return '' + '"' + name(form) + '"';
};
var writeKeyword = exports.writeKeyword = function writeKeyword(form) {
    return '' + '"' + '\uA789' + name(form) + '"';
};
var writeSymbol = exports.writeSymbol = function writeSymbol(form) {
    return write(list(symbol(void 0, 'symbol'), namespace(form), name(form)));
};
var writeNil = exports.writeNil = function writeNil(form) {
    return 'void(0)';
};
var writeNumber = exports.writeNumber = function writeNumber(form) {
    return form;
};
var writeBoolean = exports.writeBoolean = function writeBoolean(form) {
    return isTrue(form) ? 'true' : 'false';
};
var writeString = exports.writeString = function writeString(form) {
    form = replace(form, RegExp('\\\\', 'g'), '\\\\');
    form = replace(form, RegExp('\n', 'g'), '\\n');
    form = replace(form, RegExp('\r', 'g'), '\\r');
    form = replace(form, RegExp('\t', 'g'), '\\t');
    form = replace(form, RegExp('"', 'g'), '\\"');
    return '' + '"' + form + '"';
};
var writeTemplate = exports.writeTemplate = function writeTemplate() {
    var form = Array.prototype.slice.call(arguments, 0);
    return function () {
        var indentPatternø1 = /\n *$/;
        var lineBreakPatterø1 = RegExp('\n', 'g');
        var getIndentationø1 = function (code) {
            return reFind(indentPatternø1, code) || '\n';
        };
        return function loop() {
            var recur = loop;
            var codeø1 = '';
            var partsø1 = split(first(form), '~{}');
            var valuesø1 = rest(form);
            do {
                recur = count(partsø1) > 1 ? (loop[0] = '' + codeø1 + first(partsø1) + replace('' + '' + first(valuesø1), lineBreakPatterø1, getIndentationø1(first(partsø1))), loop[1] = rest(partsø1), loop[2] = rest(valuesø1), loop) : '' + codeø1 + first(partsø1);
            } while (codeø1 = loop[0], partsø1 = loop[1], valuesø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    }.call(this);
};
var writeGroup = exports.writeGroup = function writeGroup() {
    var forms = Array.prototype.slice.call(arguments, 0);
    return join(', ', forms);
};
var writeInvoke = exports.writeInvoke = function writeInvoke(callee) {
    var params = Array.prototype.slice.call(arguments, 1);
    return writeTemplate('~{}(~{})', callee, writeGroup.apply(void 0, params));
};
var writeError = exports.writeError = function writeError(message) {
    return function () {
        return (function () {
            throw Error(message);
        })();
    };
};
var writeVector = exports.writeVector = writeError('Vectors are not supported');
var writeDictionary = exports.writeDictionary = writeError('Dictionaries are not supported');
var escapePattern = function escapePattern(pattern) {
    pattern = join('/', split(pattern, '\\/'));
    pattern = join('\\/', split(pattern, '/'));
    return pattern;
};
var writeRePattern = exports.writeRePattern = function writeRePattern(form) {
    return function () {
        var flagsø1 = '' + (form.multiline ? 'm' : '') + (form.ignoreCase ? 'i' : '') + (form.sticky ? 'y' : '');
        var patternø1 = form.source;
        return '' + '/' + escapePattern(patternø1) + '/' + flagsø1;
    }.call(this);
};
var compileComment = exports.compileComment = function compileComment(form) {
    return compileTemplate(list('//~{}\n', first(form)));
};
var writeDef = exports.writeDef = function writeDef(form) {
    return function () {
        var idø1 = first(form);
        var isExportø1 = (meta(form) || {} || 0)['top'] && !(meta(idø1) || {} || 0)['private'];
        var attributeø1 = symbol(namespace(idø1), '' + '-' + name(idø1));
        return isExportø1 ? compileTemplate(list('var ~{};\n~{}', compile(cons(symbol(void 0, 'set!'), form)), compile(list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, '.')].concat([symbol(void 0, 'exports')], [attributeø1]))], [idø1]))))) : compileTemplate(list('var ~{}', compile(cons(symbol(void 0, 'set!'), form))));
    }.call(this);
};
var isWriteInstance = exports.isWriteInstance = function isWriteInstance(form) {
    return writeTemplate('~{} instanceof ~{}', write(second(form)), write(first(form)));
};
var write = exports.write = function write(form) {
    return isNil(form) ? writeNil(form) : isSymbol(form) ? writeReference(form) : isKeyword(form) ? writeKeywordReference(form) : isString(form) ? writeString(form) : isNumber(form) ? writeNumber(form) : isBoolean(form) ? writeBoolean(form) : isRePattern(form) ? writePattern(form) : isVector(form) ? writeVector(form) : isDictionary(form) ? writeDictionary() : isList(form) ? writeInvoke.apply(void 0, map(write, vec(form))) : 'else' ? writeError('Unsupported form') : void 0;
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFub255bW91cy53aXNwIl0sIm5hbWVzIjpbIl9uc18iLCJpZCIsImRvYyIsIm5hbWUiLCJuYW1lc3BhY2UiLCJzeW1ib2wiLCJpc1N5bWJvbCIsImlzS2V5d29yZCIsImxpc3QiLCJmaXJzdCIsInNlY29uZCIsInRoaXJkIiwicmVzdCIsImlzTGlzdCIsInZlYyIsIm1hcCIsImNvdW50IiwibGFzdCIsInJlZHVjZSIsImlzRW1wdHkiLCJpc1RydWUiLCJpc05pbCIsImlzU3RyaW5nIiwiaXNOdW1iZXIiLCJpc1ZlY3RvciIsImlzRGljdGlvbmFyeSIsImlzQm9vbGVhbiIsImlzUmVQYXR0ZXJuIiwicmVGaW5kIiwiZGVjIiwic3VicyIsImlzRXF1YWwiLCJyZXBsYWNlIiwiam9pbiIsInNwbGl0IiwidXBwZXJDYXNlIiwid3JpdGVSZWZlcmVuY2UiLCJleHBvcnRzIiwiZm9ybSIsImlkw7gxIiwicmVzdWx0Iiwia2V5Iiwid3JpdGVLZXl3b3JkUmVmZXJlbmNlIiwid3JpdGVLZXl3b3JkIiwid3JpdGVTeW1ib2wiLCJ3cml0ZSIsIndyaXRlTmlsIiwid3JpdGVOdW1iZXIiLCJ3cml0ZUJvb2xlYW4iLCJ3cml0ZVN0cmluZyIsIlJlZ0V4cCIsIndyaXRlVGVtcGxhdGUiLCJpbmRlbnRQYXR0ZXJuw7gxIiwibGluZUJyZWFrUGF0dGVyw7gxIiwiZ2V0SW5kZW50YXRpb27DuDEiLCJjb2RlIiwiY29kZcO4MSIsInBhcnRzw7gxIiwidmFsdWVzw7gxIiwid3JpdGVHcm91cCIsImZvcm1zIiwid3JpdGVJbnZva2UiLCJjYWxsZWUiLCJwYXJhbXMiLCJ3cml0ZUVycm9yIiwibWVzc2FnZSIsIkVycm9yIiwid3JpdGVWZWN0b3IiLCJ3cml0ZURpY3Rpb25hcnkiLCJlc2NhcGVQYXR0ZXJuIiwicGF0dGVybiIsIndyaXRlUmVQYXR0ZXJuIiwiZmxhZ3PDuDEiLCJtdWx0aWxpbmUiLCJpZ25vcmVDYXNlIiwic3RpY2t5IiwicGF0dGVybsO4MSIsInNvdXJjZSIsImNvbXBpbGVDb21tZW50IiwiY29tcGlsZVRlbXBsYXRlIiwid3JpdGVEZWYiLCJpc0V4cG9ydMO4MSIsIm1ldGEiLCJhdHRyaWJ1dGXDuDEiLCJjb21waWxlIiwiY29ucyIsImlzV3JpdGVJbnN0YW5jZSIsIndyaXRlUGF0dGVybiJdLCJtYXBwaW5ncyI6IjtJQUFBLElBQUNBLEksR0FBRDtBQUFBLFFBQUFDLEUsRUFBSSxnQ0FBSjtBQUFBLFFBQUFDLEcsRUFDRSw0Q0FERjtBQUFBLE07O1FBRThCQyxJQUFBLEcsU0FBQUEsSTtRQUFLQyxTQUFBLEcsU0FBQUEsUztRQUFVQyxNQUFBLEcsU0FBQUEsTTtRQUFPQyxRQUFBLEcsU0FBQUEsUTtRQUFRQyxTQUFBLEcsU0FBQUEsUzs7UUFDekJDLElBQUEsRyxjQUFBQSxJO1FBQUtDLEtBQUEsRyxjQUFBQSxLO1FBQU1DLE1BQUEsRyxjQUFBQSxNO1FBQU9DLEtBQUEsRyxjQUFBQSxLO1FBQU1DLElBQUEsRyxjQUFBQSxJO1FBQUtDLE1BQUEsRyxjQUFBQSxNO1FBQzdCQyxHQUFBLEcsY0FBQUEsRztRQUFJQyxHQUFBLEcsY0FBQUEsRztRQUFJQyxLQUFBLEcsY0FBQUEsSztRQUFNQyxJQUFBLEcsY0FBQUEsSTtRQUFLQyxNQUFBLEcsY0FBQUEsTTtRQUFPQyxPQUFBLEcsY0FBQUEsTzs7UUFDM0JDLE1BQUEsRyxhQUFBQSxNO1FBQU1DLEtBQUEsRyxhQUFBQSxLO1FBQUtDLFFBQUEsRyxhQUFBQSxRO1FBQVFDLFFBQUEsRyxhQUFBQSxRO1FBQVFDLFFBQUEsRyxhQUFBQSxRO1FBQzNCQyxZQUFBLEcsYUFBQUEsWTtRQUFZQyxTQUFBLEcsYUFBQUEsUztRQUFTQyxXQUFBLEcsYUFBQUEsVztRQUNyQkMsTUFBQSxHLGFBQUFBLE07UUFBUUMsR0FBQSxHLGFBQUFBLEc7UUFBSUMsSUFBQSxHLGFBQUFBLEk7UUFBS0MsT0FBQSxHLGFBQUFBLE87O1FBQ2xCQyxPQUFBLEcsWUFBQUEsTztRQUFRQyxJQUFBLEcsWUFBQUEsSTtRQUFLQyxLQUFBLEcsWUFBQUEsSztRQUFNQyxTQUFBLEcsWUFBQUEsUzs7QUFJcEQsSUFBTUMsY0FBQSxHQUFBQyxPQUFBLENBQUFELGNBQUEsR0FBTixTQUFNQSxjQUFOLENBQ0dFLElBREgsRUFFRTtBQUFBO0FBQUEsSUFRQSxPLFlBQU07QUFBQSxZQUFBQyxJLEdBQUlwQyxJQUFELENBQU1tQyxJQUFOLENBQUg7QUFBQSxRQUNFQyxJQUFOLEdBQTJCQSxJQUFaLEtBQWdCLEdBQXRCLEdBQTJCLFVBQTNCLEdBQ2tCQSxJQUFaLEtBQWUsRyxHQUFLLFEsR0FDUkEsSUFBWixLQUFlLEcsR0FBSyxLLEdBQ1JBLElBQVosS0FBZSxHLEdBQUssVSxHQUNSQSxJQUFaLEtBQWUsRyxHQUFLLFEsR0FDUkEsSUFBWixLQUFlLEksR0FBTSxlLEdBQ1RBLElBQVosS0FBZSxJLEdBQU0sa0IsR0FDVEEsSUFBWixLQUFlLEksR0FBTSxlLEdBQ1RBLElBQVosS0FBZSxHLEdBQUssYyxHQUNSQSxJQUFaLEtBQWUsRyxHQUFLLFcsR0FDUkEsSUFBWixLQUFlLEksR0FBTSxjLFlBQ2ZBLEksU0FYckIsQ0FESTtBQUFBLFFBY0VBLElBQU4sR0FBVU4sSUFBRCxDQUFNLEdBQU4sRUFBV0MsS0FBRCxDQUFPSyxJQUFQLEVBQVUsR0FBVixDQUFWLENBQVQsQ0FkSTtBQUFBLFFBZ0JFQSxJQUFOLEdBQVVOLElBQUQsQ0FBTSxNQUFOLEVBQWNDLEtBQUQsQ0FBT0ssSUFBUCxFQUFVLElBQVYsQ0FBYixDQUFULENBaEJJO0FBQUEsUUFrQkVBLElBQU4sR0FBVU4sSUFBRCxDQUFPQyxLQUFELENBQU9LLElBQVAsRUFBVSxHQUFWLENBQU4sQ0FBVCxDQWxCSTtBQUFBLFFBbUJFQSxJQUFOLEdBQVVOLElBQUQsQ0FBTSxHQUFOLEVBQVdDLEtBQUQsQ0FBT0ssSUFBUCxFQUFVLEdBQVYsQ0FBVixDQUFULENBbkJJO0FBQUEsUUF1QkVBLElBQU4sR0FBVU4sSUFBRCxDQUFNLFFBQU4sRUFBZ0JDLEtBQUQsQ0FBT0ssSUFBUCxFQUFVLEdBQVYsQ0FBZixDQUFULENBdkJJO0FBQUEsUUF3QkVBLElBQU4sR0FBVU4sSUFBRCxDQUFNLE9BQU4sRUFBZUMsS0FBRCxDQUFPSyxJQUFQLEVBQVUsR0FBVixDQUFkLENBQVQsQ0F4Qkk7QUFBQSxRQTBCRUEsSUFBTixHQUEwQnRCLElBQUQsQ0FBTXNCLElBQU4sQ0FBWixLQUFzQixHQUExQixHLEtBQ08sS0FBTCxHQUFZVCxJQUFELENBQU1TLElBQU4sRUFBUyxDQUFULEVBQVlWLEdBQUQsQ0FBTWIsS0FBRCxDQUFPdUIsSUFBUCxDQUFMLENBQVgsQ0FEYixHQUVFQSxJQUZYLENBMUJJO0FBQUEsUUE4QkVBLElBQU4sR0FBVXJCLE1BQUQsQ0FDQyxVQUFLc0IsTUFBTCxFQUFZQyxHQUFaLEVBQ0U7QUFBQSxtQixLQUFLRCxNQUFMLEdBQ0ssQ0FBUyxDQUFNckIsT0FBRCxDQUFRcUIsTUFBUixDQUFWLElBQ0ssQ0FBTXJCLE9BQUQsQ0FBUXNCLEdBQVIsQ0FEZCxHLEtBRVFOLFNBQUQsQyxDQUFpQk0sRyxNQUFMLENBQVMsQ0FBVCxDQUFaLENBQUwsR0FBK0JYLElBQUQsQ0FBTVcsR0FBTixFQUFVLENBQVYsQ0FGaEMsR0FHRUEsR0FIRixDQURMO0FBQUEsU0FGSCxFQU9DLEVBUEQsRUFRRVAsS0FBRCxDQUFPSyxJQUFQLEVBQVUsR0FBVixDQVJELENBQVQsQ0E5Qkk7QUFBQSxRQXVDSixPQUFBQSxJQUFBLENBdkNJO0FBQUEsSyxLQUFOLEMsSUFBQSxFQVJBO0FBQUEsQ0FGRixDO0FBbURBLElBQU1HLHFCQUFBLEdBQUFMLE9BQUEsQ0FBQUsscUJBQUEsR0FBTixTQUFNQSxxQkFBTixDQUNHSixJQURILEVBRUU7QUFBQSxXLEtBQUssRyxHQUFNbkMsSUFBRCxDQUFNbUMsSUFBTixDQUFWLEdBQXNCLEdBQXRCO0FBQUEsQ0FGRixDO0FBSUEsSUFBTUssWUFBQSxHQUFBTixPQUFBLENBQUFNLFlBQUEsR0FBTixTQUFNQSxZQUFOLENBQXFCTCxJQUFyQixFQUEyQjtBQUFBLFcsS0FBSyxHLEdBQUssUSxHQUFVbkMsSUFBRCxDQUFNbUMsSUFBTixDQUFuQixHQUErQixHQUEvQjtBQUFBLENBQTNCLEM7QUFFQSxJQUFNTSxXQUFBLEdBQUFQLE9BQUEsQ0FBQU8sV0FBQSxHQUFOLFNBQU1BLFdBQU4sQ0FBb0JOLElBQXBCLEVBQ0U7QUFBQSxXQUFDTyxLQUFELENBQVFyQyxJQUFELEMsTUFBTyxDLE1BQUEsRSxRQUFBLENBQVAsRUFBZUosU0FBRCxDQUFXa0MsSUFBWCxDQUFkLEVBQWdDbkMsSUFBRCxDQUFNbUMsSUFBTixDQUEvQixDQUFQO0FBQUEsQ0FERixDO0FBR0EsSUFBTVEsUUFBQSxHQUFBVCxPQUFBLENBQUFTLFFBQUEsR0FBTixTQUFNQSxRQUFOLENBQWlCUixJQUFqQixFQUF1QjtBQUFBO0FBQUEsQ0FBdkIsQztBQUVBLElBQU1TLFdBQUEsR0FBQVYsT0FBQSxDQUFBVSxXQUFBLEdBQU4sU0FBTUEsV0FBTixDQUFvQlQsSUFBcEIsRUFBMEI7QUFBQSxXQUFBQSxJQUFBO0FBQUEsQ0FBMUIsQztBQUVBLElBQU1VLFlBQUEsR0FBQVgsT0FBQSxDQUFBVyxZQUFBLEdBQU4sU0FBTUEsWUFBTixDQUFxQlYsSUFBckIsRUFBMkI7QUFBQSxXQUFLbEIsTUFBRCxDQUFPa0IsSUFBUCxDQUFKLEdBQWlCLE1BQWpCLEdBQXdCLE9BQXhCO0FBQUEsQ0FBM0IsQztBQUVBLElBQU1XLFdBQUEsR0FBQVosT0FBQSxDQUFBWSxXQUFBLEdBQU4sU0FBTUEsV0FBTixDQUNHWCxJQURILEVBRUU7QUFBQSxJQUFNQSxJQUFOLEdBQVlOLE9BQUQsQ0FBU00sSUFBVCxFQUFlWSxNQUFELENBQVEsTUFBUixFQUFlLEdBQWYsQ0FBZCxFQUFrQyxNQUFsQyxDQUFYO0FBQUEsSUFDTVosSUFBTixHQUFZTixPQUFELENBQVNNLElBQVQsRUFBZVksTUFBRCxDQUFRLElBQVIsRUFBYSxHQUFiLENBQWQsRUFBZ0MsS0FBaEMsQ0FBWCxDQURBO0FBQUEsSUFFTVosSUFBTixHQUFZTixPQUFELENBQVNNLElBQVQsRUFBZVksTUFBRCxDQUFRLElBQVIsRUFBYSxHQUFiLENBQWQsRUFBZ0MsS0FBaEMsQ0FBWCxDQUZBO0FBQUEsSUFHTVosSUFBTixHQUFZTixPQUFELENBQVNNLElBQVQsRUFBZVksTUFBRCxDQUFRLElBQVIsRUFBYSxHQUFiLENBQWQsRUFBZ0MsS0FBaEMsQ0FBWCxDQUhBO0FBQUEsSUFJTVosSUFBTixHQUFZTixPQUFELENBQVNNLElBQVQsRUFBZVksTUFBRCxDQUFRLEdBQVIsRUFBYSxHQUFiLENBQWQsRUFBZ0MsS0FBaEMsQ0FBWCxDQUpBO0FBQUEsSUFLQSxPLEtBQUssRyxHQUFLWixJQUFWLEdBQWUsR0FBZixDQUxBO0FBQUEsQ0FGRixDO0FBU0EsSUFBTWEsYUFBQSxHQUFBZCxPQUFBLENBQUFjLGFBQUEsR0FBTixTQUFNQSxhQUFOLEc7UUFFS2IsSUFBQSxHO0lBQ0gsTyxZQUFNO0FBQUEsWUFBQWMsZSxHQUFlLE9BQWY7QUFBQSxRQUNBLElBQUFDLGlCLEdBQW1CSCxNQUFELENBQVEsSUFBUixFQUFhLEdBQWIsQ0FBbEIsQ0FEQTtBQUFBLFFBRUEsSUFBQUksZ0IsR0FBZ0IsVUFBS0MsSUFBTCxFQUFXO0FBQUEsbUJBQUszQixNQUFELENBQVN3QixlQUFULEVBQXdCRyxJQUF4QixDQUFKLElBQWtDLElBQWxDO0FBQUEsU0FBM0IsQ0FGQTtBQUFBLFFBR0osTzs7WUFBTyxJQUFBQyxNLEdBQUssRUFBTCxDO1lBQ0EsSUFBQUMsTyxHQUFPdkIsS0FBRCxDQUFRekIsS0FBRCxDQUFPNkIsSUFBUCxDQUFQLEVBQW9CLEtBQXBCLENBQU4sQztZQUNBLElBQUFvQixRLEdBQVE5QyxJQUFELENBQU0wQixJQUFOLENBQVAsQzs7d0JBQ0d0QixLQUFELENBQU95QyxPQUFQLENBQUgsR0FBaUIsQ0FBckIsR0FDRSxDLGVBRUVELE0sR0FDQy9DLEtBQUQsQ0FBT2dELE9BQVAsQ0FGRCxHQUdFekIsT0FBRCxDLEtBQWMsRUFBTCxHQUFTdkIsS0FBRCxDQUFPaUQsUUFBUCxDQUFqQixFQUNVTCxpQkFEVixFQUVXQyxnQkFBRCxDQUFrQjdDLEtBQUQsQ0FBT2dELE9BQVAsQ0FBakIsQ0FGVixDQUpGLEUsVUFPRTdDLElBQUQsQ0FBTTZDLE9BQU4sQ0FQRCxFLFVBUUU3QyxJQUFELENBQU04QyxRQUFOLENBUkQsRSxJQUFBLENBREYsRyxLQVVRRixNQUFMLEdBQVcvQyxLQUFELENBQU9nRCxPQUFQLEM7cUJBYlJELE0sWUFDQUMsTyxZQUNBQyxROztjQUZQLEMsSUFBQSxFQUhJO0FBQUEsSyxLQUFOLEMsSUFBQSxFO0NBSEYsQztBQXNCQSxJQUFNQyxVQUFBLEdBQUF0QixPQUFBLENBQUFzQixVQUFBLEdBQU4sU0FBTUEsVUFBTixHO1FBQ0tDLEtBQUEsRztJQUNILE9BQUMzQixJQUFELENBQU0sSUFBTixFQUFXMkIsS0FBWCxFO0NBRkYsQztBQUlBLElBQU1DLFdBQUEsR0FBQXhCLE9BQUEsQ0FBQXdCLFdBQUEsR0FBTixTQUFNQSxXQUFOLENBQ0dDLE1BREgsRTtRQUNZQyxNQUFBLEc7SUFDVixPQUFDWixhQUFELENBQWdCLFVBQWhCLEVBQTJCVyxNQUEzQixFQUF5Q0gsVSxNQUFQLEMsTUFBQSxFQUFtQkksTUFBbkIsQ0FBbEMsRTtDQUZGLEM7QUFJQSxJQUFNQyxVQUFBLEdBQUEzQixPQUFBLENBQUEyQixVQUFBLEdBQU4sU0FBTUEsVUFBTixDQUNHQyxPQURILEVBRUU7QUFBQSx1QkFBTztBQUFBLGUsYUFBQTtBQUFBLGtCQUFRQyxLQUFELENBQU9ELE9BQVAsQ0FBUDtBQUFBLFMsQ0FBQTtBQUFBLEtBQVA7QUFBQSxDQUZGLEM7QUFJQSxJQUFLRSxXQUFBLEdBQUE5QixPQUFBLENBQUE4QixXQUFBLEdBQWNILFVBQUQsQ0FBYSwyQkFBYixDQUFsQixDO0FBQ0EsSUFBS0ksZUFBQSxHQUFBL0IsT0FBQSxDQUFBK0IsZUFBQSxHQUFrQkosVUFBRCxDQUFhLGdDQUFiLENBQXRCLEM7QUFFQSxJQUFPSyxhQUFBLEdBQVAsU0FBT0EsYUFBUCxDQUF1QkMsT0FBdkIsRUFDRTtBQUFBLElBQU1BLE9BQU4sR0FBZXJDLElBQUQsQ0FBTSxHQUFOLEVBQVdDLEtBQUQsQ0FBT29DLE9BQVAsRUFBZSxLQUFmLENBQVYsQ0FBZDtBQUFBLElBQ01BLE9BQU4sR0FBZXJDLElBQUQsQ0FBTSxLQUFOLEVBQWFDLEtBQUQsQ0FBT29DLE9BQVAsRUFBZSxHQUFmLENBQVosQ0FBZCxDQURBO0FBQUEsSUFFQSxPQUFBQSxPQUFBLENBRkE7QUFBQSxDQURGLEM7QUFLQSxJQUFNQyxjQUFBLEdBQUFsQyxPQUFBLENBQUFrQyxjQUFBLEdBQU4sU0FBTUEsY0FBTixDQUNHakMsSUFESCxFQUVFO0FBQUEsVyxZQUFNO0FBQUEsWUFBQWtDLE8sUUFBVyxDQUFJbEMsSUFBQSxDQUFLbUMsU0FBVCxHQUFtQixHQUFuQixHQUF1QixFQUF2QixDLEdBQ0EsQ0FBSW5DLElBQUEsQ0FBS29DLFVBQVQsR0FBb0IsR0FBcEIsR0FBd0IsRUFBeEIsQ0FETCxHQUVLLENBQUlwQyxJQUFBLENBQUtxQyxNQUFULEdBQWdCLEdBQWhCLEdBQW9CLEVBQXBCLENBRlg7QUFBQSxRQUdBLElBQUFDLFMsR0FBUXRDLElBQUEsQ0FBS3VDLE1BQWIsQ0FIQTtBQUFBLFFBSUosTyxLQUFLLEcsR0FBSVIsYUFBRCxDQUFnQk8sU0FBaEIsQyxHQUF5QixHQUFqQyxHQUFvQ0osT0FBcEMsQ0FKSTtBQUFBLEssS0FBTixDLElBQUE7QUFBQSxDQUZGLEM7QUFTQSxJQUFNTSxjQUFBLEdBQUF6QyxPQUFBLENBQUF5QyxjQUFBLEdBQU4sU0FBTUEsY0FBTixDQUNHeEMsSUFESCxFQUVFO0FBQUEsV0FBQ3lDLGVBQUQsQ0FBbUJ2RSxJQUFELENBQU0sU0FBTixFQUFpQkMsS0FBRCxDQUFPNkIsSUFBUCxDQUFoQixDQUFsQjtBQUFBLENBRkYsQztBQUlBLElBQU0wQyxRQUFBLEdBQUEzQyxPQUFBLENBQUEyQyxRQUFBLEdBQU4sU0FBTUEsUUFBTixDQVFHMUMsSUFSSCxFQVNFO0FBQUEsVyxZQUFNO0FBQUEsWUFBQUMsSSxHQUFJOUIsS0FBRCxDQUFPNkIsSUFBUCxDQUFIO0FBQUEsUUFDQSxJQUFBMkMsVSxJQUF3QkMsSUFBRCxDQUFNNUMsSUFBTixDQUFKLElBQWdCLEUsTUFBdEIsQyxLQUFBLENBQUwsSUFDSyxDLENBQW9CNEMsSUFBRCxDQUFNM0MsSUFBTixDQUFKLElBQWMsRSxNQUF4QixDLFNBQUEsQ0FEbEIsQ0FEQTtBQUFBLFFBR0EsSUFBQTRDLFcsR0FBVzlFLE1BQUQsQ0FBU0QsU0FBRCxDQUFXbUMsSUFBWCxDQUFSLEUsS0FDYSxHQUFMLEdBQVVwQyxJQUFELENBQU1vQyxJQUFOLENBRGpCLENBQVYsQ0FIQTtBQUFBLFFBS0osT0FBSTBDLFVBQUosR0FDR0YsZUFBRCxDQUFtQnZFLElBQUQsQ0FBTSxlQUFOLEVBQ1E0RSxPQUFELENBQVVDLElBQUQsQyxNQUFPLEMsTUFBQSxFLE1BQUEsQ0FBUCxFQUFZL0MsSUFBWixDQUFULENBRFAsRUFFUThDLE9BQUQsQyxVQUFTLEMsTUFBQSxFLE9BQUUsQyxNQUFBLEUsTUFBQSxDLG9DQUFNLEMsTUFBQSxFLEdBQUEsQyxnQkFBRSxDLE1BQUEsRSxTQUFBLEMsSUFBU0QsVyxPQUFZNUMsSSxFQUEvQixDQUFULENBRlAsQ0FBbEIsQ0FERixHQUlHd0MsZUFBRCxDQUFtQnZFLElBQUQsQ0FBTSxTQUFOLEVBQ080RSxPQUFELENBQVVDLElBQUQsQyxNQUFPLEMsTUFBQSxFLE1BQUEsQ0FBUCxFQUFZL0MsSUFBWixDQUFULENBRE4sQ0FBbEIsQ0FKRixDQUxJO0FBQUEsSyxLQUFOLEMsSUFBQTtBQUFBLENBVEYsQztBQXNCQSxJQUFNZ0QsZUFBQSxHQUFBakQsT0FBQSxDQUFBaUQsZUFBQSxHQUFOLFNBQU1BLGVBQU4sQ0FHR2hELElBSEgsRUFJRTtBQUFBLFdBQUNhLGFBQUQsQ0FBZ0Isb0JBQWhCLEVBQ2lCTixLQUFELENBQVFuQyxNQUFELENBQVE0QixJQUFSLENBQVAsQ0FEaEIsRUFFaUJPLEtBQUQsQ0FBUXBDLEtBQUQsQ0FBTzZCLElBQVAsQ0FBUCxDQUZoQjtBQUFBLENBSkYsQztBQU9BLElBQU1PLEtBQUEsR0FBQVIsT0FBQSxDQUFBUSxLQUFBLEdBQU4sU0FBTUEsS0FBTixDQUVHUCxJQUZILEVBR0U7QUFBQSxXQUNFakIsS0FBRCxDQUFNaUIsSUFBTixDQURELEdBQ2NRLFFBQUQsQ0FBV1IsSUFBWCxDQURiLEdBRUVoQyxRQUFELENBQVNnQyxJQUFULEMsR0FBZ0JGLGNBQUQsQ0FBaUJFLElBQWpCLEMsR0FDZC9CLFNBQUQsQ0FBVStCLElBQVYsQyxHQUFpQkkscUJBQUQsQ0FBeUJKLElBQXpCLEMsR0FDZmhCLFFBQUQsQ0FBU2dCLElBQVQsQyxHQUFnQlcsV0FBRCxDQUFjWCxJQUFkLEMsR0FDZGYsUUFBRCxDQUFTZSxJQUFULEMsR0FBZ0JTLFdBQUQsQ0FBY1QsSUFBZCxDLEdBQ2RaLFNBQUQsQ0FBVVksSUFBVixDLEdBQWlCVSxZQUFELENBQWVWLElBQWYsQyxHQUNmWCxXQUFELENBQWFXLElBQWIsQyxHQUFvQmlELFlBQUQsQ0FBZWpELElBQWYsQyxHQUNsQmQsUUFBRCxDQUFTYyxJQUFULEMsR0FBZ0I2QixXQUFELENBQWM3QixJQUFkLEMsR0FDZGIsWUFBRCxDQUFhYSxJQUFiLEMsR0FBb0I4QixlQUFELEUsR0FDbEJ2RCxNQUFELENBQU95QixJQUFQLEMsR0FBb0J1QixXLE1BQVAsQyxNQUFBLEVBQXFCOUMsR0FBRCxDQUFLOEIsS0FBTCxFQUFZL0IsR0FBRCxDQUFLd0IsSUFBTCxDQUFYLENBQXBCLEMsWUFDTjBCLFVBQUQsQ0FBYSxrQkFBYixDLFNBWFA7QUFBQSxDQUhGIiwic291cmNlc0NvbnRlbnQiOlsiKG5zIHdpc3AuYmFja2VuZC5qYXZhc2NyaXB0LndyaXRlclxuICBcIkNvbXBpbGVyIGJhY2tlbmQgZm9yIGZvciB3cml0aW5nIEpTIG91dHB1dFwiXG4gICg6cmVxdWlyZSBbd2lzcC5hc3QgOnJlZmVyIFtuYW1lIG5hbWVzcGFjZSBzeW1ib2wgc3ltYm9sPyBrZXl3b3JkP11dXG4gICAgICAgICAgICBbd2lzcC5zZXF1ZW5jZSA6cmVmZXIgW2xpc3QgZmlyc3Qgc2Vjb25kIHRoaXJkIHJlc3QgbGlzdD9cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdmVjIG1hcCBjb3VudCBsYXN0IHJlZHVjZSBlbXB0eT9dXVxuICAgICAgICAgICAgW3dpc3AucnVudGltZSA6cmVmZXIgW3RydWU/IG5pbD8gc3RyaW5nPyBudW1iZXI/IHZlY3Rvcj9cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaWN0aW9uYXJ5PyBib29sZWFuPyByZS1wYXR0ZXJuP1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlLWZpbmQgZGVjIHN1YnMgPV1dXG4gICAgICAgICAgICBbd2lzcC5zdHJpbmcgOnJlZmVyIFtyZXBsYWNlIGpvaW4gc3BsaXQgdXBwZXItY2FzZV1dKSlcblxuOzsgQWN0dWFsIGNvZGVcblxuKGRlZm4gd3JpdGUtcmVmZXJlbmNlXG4gIFtmb3JtXVxuICBcIlRyYW5zbGF0ZXMgcmVmZXJlbmNlcyBmcm9tIGNsb2p1cmUgY29udmVudGlvbiB0byBKUzpcblxuICAqKm1hY3JvcyoqICAgICAgX19tYWNyb3NfX1xuICBsaXN0LT52ZWN0b3IgICAgbGlzdFRvVmVjdG9yXG4gIHNldCEgICAgICAgICAgICBzZXRcbiAgZm9vX2JhciAgICAgICAgIGZvb19iYXJcbiAgbnVtYmVyPyAgICAgICAgIGlzTnVtYmVyXG4gIGNyZWF0ZS1zZXJ2ZXIgICBjcmVhdGVTZXJ2ZXJcIlxuICAobGV0IFtpZCAobmFtZSBmb3JtKV1cbiAgICAoc2V0ISBpZCAoY29uZCAoaWRlbnRpY2FsPyBpZCAgXCIqXCIpIFwibXVsdGlwbHlcIlxuICAgICAgICAgICAgICAgICAgIChpZGVudGljYWw/IGlkIFwiL1wiKSBcImRpdmlkZVwiXG4gICAgICAgICAgICAgICAgICAgKGlkZW50aWNhbD8gaWQgXCIrXCIpIFwic3VtXCJcbiAgICAgICAgICAgICAgICAgICAoaWRlbnRpY2FsPyBpZCBcIi1cIikgXCJzdWJ0cmFjdFwiXG4gICAgICAgICAgICAgICAgICAgKGlkZW50aWNhbD8gaWQgXCI9XCIpIFwiZXF1YWw/XCJcbiAgICAgICAgICAgICAgICAgICAoaWRlbnRpY2FsPyBpZCBcIj09XCIpIFwic3RyaWN0LWVxdWFsP1wiXG4gICAgICAgICAgICAgICAgICAgKGlkZW50aWNhbD8gaWQgXCI8PVwiKSBcIm5vdC1ncmVhdGVyLXRoYW5cIlxuICAgICAgICAgICAgICAgICAgIChpZGVudGljYWw/IGlkIFwiPj1cIikgXCJub3QtbGVzcy10aGFuXCJcbiAgICAgICAgICAgICAgICAgICAoaWRlbnRpY2FsPyBpZCBcIj5cIikgXCJncmVhdGVyLXRoYW5cIlxuICAgICAgICAgICAgICAgICAgIChpZGVudGljYWw/IGlkIFwiPFwiKSBcImxlc3MtdGhhblwiXG4gICAgICAgICAgICAgICAgICAgKGlkZW50aWNhbD8gaWQgXCItPlwiKSBcInRocmVhZC1maXJzdFwiXG4gICAgICAgICAgICAgICAgICAgOmVsc2UgaWQpKVxuICAgIDs7ICoqbWFjcm9zKiogLT4gIF9fbWFjcm9zX19cbiAgICAoc2V0ISBpZCAoam9pbiBcIl9cIiAoc3BsaXQgaWQgXCIqXCIpKSlcbiAgICA7OyBsaXN0LT52ZWN0b3IgLT4gIGxpc3RUb1ZlY3RvclxuICAgIChzZXQhIGlkIChqb2luIFwiLXRvLVwiIChzcGxpdCBpZCBcIi0+XCIpKSlcbiAgICA7OyBzZXQhIC0+ICBzZXRcbiAgICAoc2V0ISBpZCAoam9pbiAoc3BsaXQgaWQgXCIhXCIpKSlcbiAgICAoc2V0ISBpZCAoam9pbiBcIiRcIiAoc3BsaXQgaWQgXCIlXCIpKSlcbiAgICA7OyBmb289IC0+IGZvb0VxdWFsXG4gICAgOyhzZXQhIGlkIChqb2luIFwiLWVxdWFsLVwiIChzcGxpdCBpZCBcIj1cIikpXG4gICAgOzsgZm9vK2JhciAtPiBmb29QbHVzQmFyXG4gICAgKHNldCEgaWQgKGpvaW4gXCItcGx1cy1cIiAoc3BsaXQgaWQgXCIrXCIpKSlcbiAgICAoc2V0ISBpZCAoam9pbiBcIi1hbmQtXCIgKHNwbGl0IGlkIFwiJlwiKSkpXG4gICAgOzsgbnVtYmVyPyAtPiBpc051bWJlclxuICAgIChzZXQhIGlkIChpZiAoaWRlbnRpY2FsPyAobGFzdCBpZCkgXCI/XCIpXG4gICAgICAgICAgICAgICAoc3RyIFwiaXMtXCIgKHN1YnMgaWQgMCAoZGVjIChjb3VudCBpZCkpKSlcbiAgICAgICAgICAgICAgIGlkKSlcbiAgICA7OyBjcmVhdGUtc2VydmVyIC0+IGNyZWF0ZVNlcnZlclxuICAgIChzZXQhIGlkIChyZWR1Y2VcbiAgICAgICAgICAgICAgKGZuIFtyZXN1bHQga2V5XVxuICAgICAgICAgICAgICAgIChzdHIgcmVzdWx0XG4gICAgICAgICAgICAgICAgICAgICAoaWYgKGFuZCAobm90IChlbXB0eT8gcmVzdWx0KSlcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIChub3QgKGVtcHR5PyBrZXkpKSlcbiAgICAgICAgICAgICAgICAgICAgICAgKHN0ciAodXBwZXItY2FzZSAoZ2V0IGtleSAwKSkgKHN1YnMga2V5IDEpKVxuICAgICAgICAgICAgICAgICAgICAgICBrZXkpKSlcbiAgICAgICAgICAgICAgXCJcIlxuICAgICAgICAgICAgICAoc3BsaXQgaWQgXCItXCIpKSlcbiAgICBpZCkpXG5cbihkZWZuIHdyaXRlLWtleXdvcmQtcmVmZXJlbmNlXG4gIFtmb3JtXVxuICAoc3RyIFwiXFxcIlwiIChuYW1lIGZvcm0pIFwiXFxcIlwiKSlcblxuKGRlZm4gd3JpdGUta2V5d29yZCBbZm9ybV0gKHN0ciBcIlxcXCJcIiBcIlxcdUE3ODlcIiAobmFtZSBmb3JtKSBcIlxcXCJcIikpXG5cbihkZWZuIHdyaXRlLXN5bWJvbCBbZm9ybV1cbiAgKHdyaXRlIChsaXN0ICdzeW1ib2wgKG5hbWVzcGFjZSBmb3JtKSAobmFtZSBmb3JtKSkpKVxuXG4oZGVmbiB3cml0ZS1uaWwgW2Zvcm1dIFwidm9pZCgwKVwiKVxuXG4oZGVmbiB3cml0ZS1udW1iZXIgW2Zvcm1dIGZvcm0pXG5cbihkZWZuIHdyaXRlLWJvb2xlYW4gW2Zvcm1dIChpZiAodHJ1ZT8gZm9ybSkgXCJ0cnVlXCIgXCJmYWxzZVwiKSlcblxuKGRlZm4gd3JpdGUtc3RyaW5nXG4gIFtmb3JtXVxuICAoc2V0ISBmb3JtIChyZXBsYWNlIGZvcm0gKFJlZ0V4cCBcIlxcXFxcXFxcXCIgXCJnXCIpIFwiXFxcXFxcXFxcIikpXG4gIChzZXQhIGZvcm0gKHJlcGxhY2UgZm9ybSAoUmVnRXhwIFwiXFxuXCIgXCJnXCIpIFwiXFxcXG5cIikpXG4gIChzZXQhIGZvcm0gKHJlcGxhY2UgZm9ybSAoUmVnRXhwIFwiXFxyXCIgXCJnXCIpIFwiXFxcXHJcIikpXG4gIChzZXQhIGZvcm0gKHJlcGxhY2UgZm9ybSAoUmVnRXhwIFwiXFx0XCIgXCJnXCIpIFwiXFxcXHRcIikpXG4gIChzZXQhIGZvcm0gKHJlcGxhY2UgZm9ybSAoUmVnRXhwIFwiXFxcIlwiIFwiZ1wiKSBcIlxcXFxcXFwiXCIpKVxuICAoc3RyIFwiXFxcIlwiIGZvcm0gXCJcXFwiXCIpKVxuXG4oZGVmbiB3cml0ZS10ZW1wbGF0ZVxuICBcIkNvbXBpbGVzIGdpdmVuIHRlbXBsYXRlXCJcbiAgWyYgZm9ybV1cbiAgKGxldCBbaW5kZW50LXBhdHRlcm4gI1wiXFxuICokXCJcbiAgICAgICAgbGluZS1icmVhay1wYXR0ZXIgKFJlZ0V4cCBcIlxcblwiIFwiZ1wiKVxuICAgICAgICBnZXQtaW5kZW50YXRpb24gKGZuIFtjb2RlXSAob3IgKHJlLWZpbmQgaW5kZW50LXBhdHRlcm4gY29kZSkgXCJcXG5cIikpXVxuICAgIChsb29wIFtjb2RlIFwiXCJcbiAgICAgICAgICAgcGFydHMgKHNwbGl0IChmaXJzdCBmb3JtKSBcIn57fVwiKVxuICAgICAgICAgICB2YWx1ZXMgKHJlc3QgZm9ybSldXG4gICAgICAoaWYgKD4gKGNvdW50IHBhcnRzKSAxKVxuICAgICAgICAocmVjdXJcbiAgICAgICAgIChzdHJcbiAgICAgICAgICBjb2RlXG4gICAgICAgICAgKGZpcnN0IHBhcnRzKVxuICAgICAgICAgIChyZXBsYWNlIChzdHIgXCJcIiAoZmlyc3QgdmFsdWVzKSlcbiAgICAgICAgICAgICAgICAgICAgbGluZS1icmVhay1wYXR0ZXJcbiAgICAgICAgICAgICAgICAgICAgKGdldC1pbmRlbnRhdGlvbiAoZmlyc3QgcGFydHMpKSkpXG4gICAgICAgICAocmVzdCBwYXJ0cylcbiAgICAgICAgIChyZXN0IHZhbHVlcykpXG4gICAgICAgICAoc3RyIGNvZGUgKGZpcnN0IHBhcnRzKSkpKSkpXG5cblxuKGRlZm4gd3JpdGUtZ3JvdXBcbiAgWyYgZm9ybXNdXG4gIChqb2luIFwiLCBcIiBmb3JtcykpXG5cbihkZWZuIHdyaXRlLWludm9rZVxuICBbY2FsbGVlICYgcGFyYW1zXVxuICAod3JpdGUtdGVtcGxhdGUgXCJ+e30ofnt9KVwiIGNhbGxlZSAoYXBwbHkgd3JpdGUtZ3JvdXAgcGFyYW1zKSkpXG5cbihkZWZuIHdyaXRlLWVycm9yXG4gIFttZXNzYWdlXVxuICAoZm4gW10gKHRocm93IChFcnJvciBtZXNzYWdlKSkpKVxuXG4oZGVmIHdyaXRlLXZlY3RvciAod3JpdGUtZXJyb3IgXCJWZWN0b3JzIGFyZSBub3Qgc3VwcG9ydGVkXCIpKVxuKGRlZiB3cml0ZS1kaWN0aW9uYXJ5ICh3cml0ZS1lcnJvciBcIkRpY3Rpb25hcmllcyBhcmUgbm90IHN1cHBvcnRlZFwiKSlcblxuKGRlZm4tIGVzY2FwZS1wYXR0ZXJuIFtwYXR0ZXJuXVxuICAoc2V0ISBwYXR0ZXJuIChqb2luIFwiL1wiIChzcGxpdCBwYXR0ZXJuIFwiXFxcXC9cIikpKVxuICAoc2V0ISBwYXR0ZXJuIChqb2luIFwiXFxcXC9cIiAoc3BsaXQgcGF0dGVybiBcIi9cIikpKVxuICBwYXR0ZXJuKVxuXG4oZGVmbiB3cml0ZS1yZS1wYXR0ZXJuXG4gIFtmb3JtXVxuICAobGV0IFtmbGFncyAoc3RyIChpZiBmb3JtLm11bHRpbGluZSBcIm1cIiBcIlwiKVxuICAgICAgICAgICAgICAgICAgIChpZiBmb3JtLmlnbm9yZUNhc2UgXCJpXCIgXCJcIilcbiAgICAgICAgICAgICAgICAgICAoaWYgZm9ybS5zdGlja3kgXCJ5XCIgXCJcIikpXG4gICAgICAgIHBhdHRlcm4gZm9ybS5zb3VyY2VdXG4gICAgKHN0ciBcXC8gKGVzY2FwZS1wYXR0ZXJuIHBhdHRlcm4pIFxcLyBmbGFncykpKVxuXG5cbihkZWZuIGNvbXBpbGUtY29tbWVudFxuICBbZm9ybV1cbiAgKGNvbXBpbGUtdGVtcGxhdGUgKGxpc3QgXCIvL357fVxcblwiIChmaXJzdCBmb3JtKSkpKVxuXG4oZGVmbiB3cml0ZS1kZWZcbiAgXCJDcmVhdGVzIGFuZCBpbnRlcm5zIG9yIGxvY2F0ZXMgYSBnbG9iYWwgdmFyIHdpdGggdGhlIG5hbWUgb2Ygc3ltYm9sXG4gIGFuZCBhIG5hbWVzcGFjZSBvZiB0aGUgdmFsdWUgb2YgdGhlIGN1cnJlbnQgbmFtZXNwYWNlICgqbnMqKS4gSWYgaW5pdFxuICBpcyBzdXBwbGllZCwgaXQgaXMgZXZhbHVhdGVkLCBhbmQgdGhlIHJvb3QgYmluZGluZyBvZiB0aGUgdmFyIGlzIHNldFxuICB0byB0aGUgcmVzdWx0aW5nIHZhbHVlLiBJZiBpbml0IGlzIG5vdCBzdXBwbGllZCwgdGhlIHJvb3QgYmluZGluZyBvZlxuICB0aGUgdmFyIGlzIHVuYWZmZWN0ZWQuIGRlZiBhbHdheXMgYXBwbGllcyB0byB0aGUgcm9vdCBiaW5kaW5nLCBldmVuIGlmXG4gIHRoZSB2YXIgaXMgdGhyZWFkLWJvdW5kIGF0IHRoZSBwb2ludCB3aGVyZSBkZWYgaXMgY2FsbGVkLiBkZWYgeWllbGRzXG4gIHRoZSB2YXIgaXRzZWxmIChub3QgaXRzIHZhbHVlKS5cIlxuICBbZm9ybV1cbiAgKGxldCBbaWQgKGZpcnN0IGZvcm0pXG4gICAgICAgIGV4cG9ydD8gKGFuZCAoOnRvcCAob3IgKG1ldGEgZm9ybSkge30pKVxuICAgICAgICAgICAgICAgICAgICAgKG5vdCAoOnByaXZhdGUgKG9yIChtZXRhIGlkKSB7fSkpKSlcbiAgICAgICAgYXR0cmlidXRlIChzeW1ib2wgKG5hbWVzcGFjZSBpZClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgKHN0ciBcIi1cIiAobmFtZSBpZCkpKV1cbiAgICAoaWYgZXhwb3J0P1xuICAgICAgKGNvbXBpbGUtdGVtcGxhdGUgKGxpc3QgXCJ2YXIgfnt9O1xcbn57fVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKGNvbXBpbGUgKGNvbnMgJ3NldCEgZm9ybSkpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKGNvbXBpbGUgYChzZXQhICguIGV4cG9ydHMgfmF0dHJpYnV0ZSkgfmlkKSkpKVxuICAgICAgKGNvbXBpbGUtdGVtcGxhdGUgKGxpc3QgXCJ2YXIgfnt9XCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIChjb21waWxlIChjb25zICdzZXQhIGZvcm0pKSkpKSkpXG5cblxuKGRlZm4gd3JpdGUtaW5zdGFuY2U/XG4gIFwiRXZhbHVhdGVzIHggYW5kIHRlc3RzIGlmIGl0IGlzIGFuIGluc3RhbmNlIG9mIHRoZSBjbGFzc1xuICBjLiBSZXR1cm5zIHRydWUgb3IgZmFsc2VcIlxuICBbZm9ybV1cbiAgKHdyaXRlLXRlbXBsYXRlIFwifnt9IGluc3RhbmNlb2Ygfnt9XCJcbiAgICAgICAgICAgICAgICAgICh3cml0ZSAoc2Vjb25kIGZvcm0pKVxuICAgICAgICAgICAgICAgICAgKHdyaXRlIChmaXJzdCBmb3JtKSkpKVxuKGRlZm4gd3JpdGVcbiAgXCJjb21waWxlcyBnaXZlbiBmb3JtXCJcbiAgW2Zvcm1dXG4gIChjb25kXG4gICAobmlsPyBmb3JtKSAod3JpdGUtbmlsIGZvcm0pXG4gICAoc3ltYm9sPyBmb3JtKSAod3JpdGUtcmVmZXJlbmNlIGZvcm0pXG4gICAoa2V5d29yZD8gZm9ybSkgKHdyaXRlLWtleXdvcmQtcmVmZXJlbmNlIGZvcm0pXG4gICAoc3RyaW5nPyBmb3JtKSAod3JpdGUtc3RyaW5nIGZvcm0pXG4gICAobnVtYmVyPyBmb3JtKSAod3JpdGUtbnVtYmVyIGZvcm0pXG4gICAoYm9vbGVhbj8gZm9ybSkgKHdyaXRlLWJvb2xlYW4gZm9ybSlcbiAgIChyZS1wYXR0ZXJuPyBmb3JtKSAod3JpdGUtcGF0dGVybiBmb3JtKVxuICAgKHZlY3Rvcj8gZm9ybSkgKHdyaXRlLXZlY3RvciBmb3JtKVxuICAgKGRpY3Rpb25hcnk/IGZvcm0pICh3cml0ZS1kaWN0aW9uYXJ5KVxuICAgKGxpc3Q/IGZvcm0pIChhcHBseSB3cml0ZS1pbnZva2UgKG1hcCB3cml0ZSAodmVjIGZvcm0pKSlcbiAgIDplbHNlICh3cml0ZS1lcnJvciBcIlVuc3VwcG9ydGVkIGZvcm1cIikpKVxuIl19
