{
    var _ns_ = {
        id: 'wisp.ast',
        doc: void 0
    };
    var wisp_sequence = require('./sequence');
    var isList = wisp_sequence.isList;
    var isSequential = wisp_sequence.isSequential;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var count = wisp_sequence.count;
    var last = wisp_sequence.last;
    var map = wisp_sequence.map;
    var vec = wisp_sequence.vec;
    var repeat = wisp_sequence.repeat;
    var wisp_string = require('./string');
    var split = wisp_string.split;
    var join = wisp_string.join;
    var wisp_runtime = require('./runtime');
    var isNil = wisp_runtime.isNil;
    var isVector = wisp_runtime.isVector;
    var isNumber = wisp_runtime.isNumber;
    var isString = wisp_runtime.isString;
    var isBoolean = wisp_runtime.isBoolean;
    var isObject = wisp_runtime.isObject;
    var isDate = wisp_runtime.isDate;
    var isRePattern = wisp_runtime.isRePattern;
    var isDictionary = wisp_runtime.isDictionary;
    var str = wisp_runtime.str;
    var inc = wisp_runtime.inc;
    var subs = wisp_runtime.subs;
    var isEqual = wisp_runtime.isEqual;
}
var withMeta = exports.withMeta = function withMeta(value, metadata) {
    Object.defineProperty(value, 'metadata', {
        'value': metadata,
        'configurable': true
    });
    return value;
};
var meta = exports.meta = function meta(value) {
    return isNil(value) ? void 0 : value.metadata;
};
var __nsSeparator__ = exports.__nsSeparator__ = '\u2044';
var Symbol = function Symbol(namespace, name) {
    this.namespace = namespace;
    this.name = name;
    return this;
};
Symbol.type = 'wisp.symbol';
Symbol.prototype.type = Symbol.type;
Symbol.prototype.toString = function () {
    return function () {
        var prefixø1 = '' + '\uFEFF' + '\'';
        var nsø1 = namespace(this);
        return nsø1 ? '' + prefixø1 + nsø1 + '/' + name(this) : '' + prefixø1 + name(this);
    }.call(this);
};
var symbol = exports.symbol = function symbol(ns, id) {
    return isSymbol(ns) ? ns : isKeyword(ns) ? new Symbol(namespace(ns), name(ns)) : isNil(id) ? new Symbol(void 0, ns) : 'else' ? new Symbol(ns, id) : void 0;
};
var isSymbol = exports.isSymbol = function isSymbol(x) {
    return isString(x) && '\uFEFF' === x[0] && '\'' === x[1] || x && Symbol.type === x.type;
};
var isKeyword = exports.isKeyword = function isKeyword(x) {
    return isString(x) && count(x) > 1 && first(x) === '\uA789';
};
var keyword = exports.keyword = function keyword(ns, id) {
    return isKeyword(ns) ? ns : isSymbol(ns) ? '' + '\uA789' + name(ns) : isNil(id) ? '' + '\uA789' + ns : isNil(ns) ? '' + '\uA789' + id : 'else' ? '' + '\uA789' + ns + __nsSeparator__ + id : void 0;
};
var keywordName = function keywordName(value) {
    return last(split(subs(value, 1), __nsSeparator__));
};
var symbolName = function symbolName(value) {
    return value.name || last(split(subs(value, 2), __nsSeparator__));
};
var name = exports.name = function name(value) {
    return isSymbol(value) ? symbolName(value) : isKeyword(value) ? keywordName(value) : isString(value) ? value : 'else' ? (function () {
        throw new TypeError('' + 'Doesn\'t support name: ' + value);
    })() : void 0;
};
var keywordNamespace = function keywordNamespace(x) {
    return function () {
        var partsø1 = split(subs(x, 1), __nsSeparator__);
        return count(partsø1) > 1 ? partsø1[0] : void 0;
    }.call(this);
};
var symbolNamespace = function symbolNamespace(x) {
    return function () {
        var partsø1 = isString(x) ? split(subs(x, 1), __nsSeparator__) : [
            x.namespace,
            x.name
        ];
        return count(partsø1) > 1 ? partsø1[0] : void 0;
    }.call(this);
};
var namespace = exports.namespace = function namespace(x) {
    return isSymbol(x) ? symbolNamespace(x) : isKeyword(x) ? keywordNamespace(x) : 'else' ? (function () {
        throw new TypeError('' + 'Doesn\'t supports namespace: ' + x);
    })() : void 0;
};
var gensym = exports.gensym = function gensym(prefix) {
    return symbol('' + (isNil(prefix) ? 'G__' : prefix) + (gensym.base = gensym.base + 1));
};
gensym.base = 0;
var isUnquote = exports.isUnquote = function isUnquote(form) {
    return isList(form) && isEqual(first(form), symbol(void 0, 'unquote'));
};
var isUnquoteSplicing = exports.isUnquoteSplicing = function isUnquoteSplicing(form) {
    return isList(form) && isEqual(first(form), symbol(void 0, 'unquote-splicing'));
};
var isQuote = exports.isQuote = function isQuote(form) {
    return isList(form) && isEqual(first(form), symbol(void 0, 'quote'));
};
var isSyntaxQuote = exports.isSyntaxQuote = function isSyntaxQuote(form) {
    return isList(form) && isEqual(first(form), symbol(void 0, 'syntax-quote'));
};
var normalize = function normalize(n, len) {
    return function loop() {
        var recur = loop;
        var nsø1 = '' + n;
        do {
            recur = count(nsø1) < len ? (loop[0] = '' + '0' + nsø1, loop) : nsø1;
        } while (nsø1 = loop[0], recur === loop);
        return recur;
    }.call(this);
};
var quoteString = exports.quoteString = function quoteString(s) {
    s = join('\\"', split(s, '"'));
    s = join('\\\\', split(s, '\\'));
    s = join('\\b', split(s, '\b'));
    s = join('\\f', split(s, '\f'));
    s = join('\\n', split(s, '\n'));
    s = join('\\r', split(s, '\r'));
    s = join('\\t', split(s, '\t'));
    return '' + '"' + s + '"';
};
var prStr = exports.prStr = function prStr(x, offset) {
    return function () {
        var offsetø2 = offset || 0;
        return isNil(x) ? 'nil' : isKeyword(x) ? namespace(x) ? '' + ':' + namespace(x) + '/' + name(x) : '' + ':' + name(x) : isSymbol(x) ? namespace(x) ? '' + namespace(x) + '/' + name(x) : name(x) : isString(x) ? quoteString(x) : isDate(x) ? '' + '#inst "' + x.getUTCFullYear() + '-' + normalize(inc(x.getUTCMonth()), 2) + '-' + normalize(x.getUTCDate(), 2) + 'T' + normalize(x.getUTCHours(), 2) + ':' + normalize(x.getUTCMinutes(), 2) + ':' + normalize(x.getUTCSeconds(), 2) + '.' + normalize(x.getUTCMilliseconds(), 3) + '-' + '00:00"' : isVector(x) ? '' + '[' + join('' + '\n ' + join(repeat(inc(offsetø2), ' ')), map(function ($1) {
            return prStr($1, inc(offsetø2));
        }, vec(x))) + ']' : isDictionary(x) ? '' + '{' + join('' + ',\n' + join(repeat(inc(offsetø2), ' ')), map(function (pair) {
            return function () {
                var indentø1 = join(repeat(offsetø2, ' '));
                var keyø1 = prStr(first(pair), inc(offsetø2));
                var valueø1 = prStr(second(pair), 2 + offsetø2 + count(keyø1));
                return '' + keyø1 + ' ' + valueø1;
            }.call(this);
        }, x)) + '}' : isSequential(x) ? '' + '(' + join(' ', map(function ($1) {
            return prStr($1, inc(offsetø2));
        }, vec(x))) + ')' : isRePattern(x) ? '' + '#"' + join('\\/', split(x.source, '/')) + '"' : 'else' ? '' + x : void 0;
    }.call(this);
};
//# sourceMappingURL=data:application/json;base64,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
