{
    var _ns_ = {
            id: 'wisp.expander',
            doc: 'wisp syntax and macro expander module'
        };
    var wisp_ast = require('./ast');
    var meta = wisp_ast.meta;
    var withMeta = wisp_ast.withMeta;
    var isSymbol = wisp_ast.isSymbol;
    var isKeyword = wisp_ast.isKeyword;
    var isQuote = wisp_ast.isQuote;
    var symbol = wisp_ast.symbol;
    var namespace = wisp_ast.namespace;
    var name = wisp_ast.name;
    var isUnquote = wisp_ast.isUnquote;
    var isUnquoteSplicing = wisp_ast.isUnquoteSplicing;
    var wisp_sequence = require('./sequence');
    var isList = wisp_sequence.isList;
    var list = wisp_sequence.list;
    var conj = wisp_sequence.conj;
    var partition = wisp_sequence.partition;
    var seq = wisp_sequence.seq;
    var isEmpty = wisp_sequence.isEmpty;
    var map = wisp_sequence.map;
    var vec = wisp_sequence.vec;
    var isEvery = wisp_sequence.isEvery;
    var concat = wisp_sequence.concat;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var last = wisp_sequence.last;
    var butlast = wisp_sequence.butlast;
    var interleave = wisp_sequence.interleave;
    var cons = wisp_sequence.cons;
    var count = wisp_sequence.count;
    var some = wisp_sequence.some;
    var assoc = wisp_sequence.assoc;
    var reduce = wisp_sequence.reduce;
    var filter = wisp_sequence.filter;
    var isSeq = wisp_sequence.isSeq;
    var wisp_runtime = require('./runtime');
    var isNil = wisp_runtime.isNil;
    var isDictionary = wisp_runtime.isDictionary;
    var isVector = wisp_runtime.isVector;
    var keys = wisp_runtime.keys;
    var vals = wisp_runtime.vals;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isBoolean = wisp_runtime.isBoolean;
    var isDate = wisp_runtime.isDate;
    var isRePattern = wisp_runtime.isRePattern;
    var isEven = wisp_runtime.isEven;
    var isEqual = wisp_runtime.isEqual;
    var max = wisp_runtime.max;
    var inc = wisp_runtime.inc;
    var dec = wisp_runtime.dec;
    var dictionary = wisp_runtime.dictionary;
    var subs = wisp_runtime.subs;
    var wisp_string = require('./string');
    var split = wisp_string.split;
}
var __macros__ = exports.__macros__ = {};
var expand = function expand(expander, form, env) {
    return function () {
        var metadataø1 = meta(form) || {};
        var parmasø1 = rest(form);
        var implicitø1 = map(function ($1) {
                return isEqual('&form', $1) ? form : isEqual('&env', $1) ? env : 'else' ? $1 : void 0;
            }, (meta(expander) || 0)['implicit'] || []);
        var paramsø1 = vec(concat(implicitø1, vec(rest(form))));
        var expansionø1 = expander.apply(void 0, paramsø1);
        return expansionø1 ? withMeta(expansionø1, conj(metadataø1, meta(expansionø1))) : expansionø1;
    }.call(this);
};
var installMacro = exports.installMacro = function installMacro(op, expander) {
        return (__macros__ || 0)[name(op)] = expander;
    };
var macro = function macro(op) {
    return isSymbol(op) && (__macros__ || 0)[name(op)];
};
var isMethodSyntax = exports.isMethodSyntax = function isMethodSyntax(op) {
        return function () {
            var idø1 = isSymbol(op) && name(op);
            return idø1 && '.' === first(idø1) && !('-' === second(idø1)) && !('.' === idø1);
        }.call(this);
    };
var isFieldSyntax = exports.isFieldSyntax = function isFieldSyntax(op) {
        return function () {
            var idø1 = isSymbol(op) && name(op);
            return idø1 && '.' === first(idø1) && '-' === second(idø1);
        }.call(this);
    };
var isNewSyntax = exports.isNewSyntax = function isNewSyntax(op) {
        return function () {
            var idø1 = isSymbol(op) && name(op);
            return idø1 && '.' === last(idø1) && !('.' === idø1);
        }.call(this);
    };
var methodSyntax = exports.methodSyntax = function methodSyntax(op, target) {
        var params = Array.prototype.slice.call(arguments, 2);
        return function () {
            var opMetaø1 = meta(op);
            var formStartø1 = (opMetaø1 || 0)['start'];
            var targetMetaø1 = meta(target);
            var memberø1 = withMeta(symbol(subs(name(op), 1)), conj(opMetaø1, {
                    'start': {
                        'line': (formStartø1 || 0)['line'],
                        'column': inc((formStartø1 || 0)['column'])
                    }
                }));
            var agetø1 = withMeta(symbol(void 0, 'aget'), conj(opMetaø1, {
                    'end': {
                        'line': (formStartø1 || 0)['line'],
                        'column': inc((formStartø1 || 0)['column'])
                    }
                }));
            var methodø1 = withMeta(list.apply(void 0, [agetø1].concat([target], [list.apply(void 0, [symbol(void 0, 'quote')].concat([memberø1]))])), conj(opMetaø1, { 'end': (meta(target) || 0)['end'] }));
            return isNil(target) ? (function () {
                throw Error('Malformed method expression, expecting (.method object ...)');
            })() : list.apply(void 0, [methodø1].concat(vec(params)));
        }.call(this);
    };
var fieldSyntax = exports.fieldSyntax = function fieldSyntax(field, target) {
        var more = Array.prototype.slice.call(arguments, 2);
        return function () {
            var metadataø1 = meta(field);
            var startø1 = (metadataø1 || 0)['start'];
            var endø1 = (metadataø1 || 0)['end'];
            var memberø1 = withMeta(symbol(subs(name(field), 2)), conj(metadataø1, {
                    'start': {
                        'line': (startø1 || 0)['line'],
                        'column': (startø1 || 0)['column'] + 2
                    }
                }));
            return isNil(target) || count(more) ? (function () {
                throw Error('Malformed member expression, expecting (.-member target)');
            })() : list.apply(void 0, [symbol(void 0, 'aget')].concat([target], [list.apply(void 0, [symbol(void 0, 'quote')].concat([memberø1]))]));
        }.call(this);
    };
var newSyntax = exports.newSyntax = function newSyntax(op) {
        var params = Array.prototype.slice.call(arguments, 1);
        return function () {
            var idø1 = name(op);
            var idMetaø1 = (idø1 || 0)['meta'];
            var renameø1 = subs(idø1, 0, dec(count(idø1)));
            var constructorø1 = withMeta(symbol(renameø1), conj(idMetaø1, {
                    'end': {
                        'line': ((idMetaø1 || 0)['end'] || 0)['line'],
                        'column': dec(((idMetaø1 || 0)['end'] || 0)['column'])
                    }
                }));
            var operatorø1 = withMeta(symbol(void 0, 'new'), conj(idMetaø1, {
                    'start': {
                        'line': ((idMetaø1 || 0)['end'] || 0)['line'],
                        'column': dec(((idMetaø1 || 0)['end'] || 0)['column'])
                    }
                }));
            return list.apply(void 0, [symbol(void 0, 'new')].concat([constructorø1], vec(params)));
        }.call(this);
    };
var keywordInvoke = exports.keywordInvoke = function keywordInvoke(keyword, target) {
        return list.apply(void 0, [symbol(void 0, 'get')].concat([target], [keyword]));
    };
var desugar = function desugar(expander, form) {
    return function () {
        var desugaredø1 = expander.apply(void 0, vec(form));
        var metadataø1 = conj({}, meta(form), meta(desugaredø1));
        return withMeta(desugaredø1, metadataø1);
    }.call(this);
};
var macroexpand1 = exports.macroexpand1 = function macroexpand1(form, env) {
        return function () {
            var opø1 = isList(form) && first(form);
            var expanderø1 = macro(opø1);
            return expanderø1 ? expand(expanderø1, form, env) : isKeyword(opø1) ? desugar(keywordInvoke, form) : isFieldSyntax(opø1) ? desugar(fieldSyntax, form) : isMethodSyntax(opø1) ? desugar(methodSyntax, form) : isNewSyntax(opø1) ? desugar(newSyntax, form) : 'else' ? form : void 0;
        }.call(this);
    };
var macroexpand = exports.macroexpand = function macroexpand(form, env) {
        return function loop() {
            var recur = loop;
            var originalø1 = form;
            var expandedø1 = macroexpand1(form, env);
            do {
                recur = originalø1 === expandedø1 ? originalø1 : (loop[0] = expandedø1, loop[1] = macroexpand1(expandedø1, env), loop);
            } while (originalø1 = loop[0], expandedø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var syntaxQuote = exports.syntaxQuote = function syntaxQuote(form) {
        return isSymbol(form) ? list(symbol(void 0, 'quote'), form) : isKeyword(form) ? list(symbol(void 0, 'quote'), form) : isNumber(form) || isString(form) || isBoolean(form) || isNil(form) || isRePattern(form) ? form : isUnquote(form) ? second(form) : isUnquoteSplicing(form) ? readerError('Illegal use of `~@` expression, can only be present in a list') : isEmpty(form) ? form : isDictionary(form) ? list(symbol(void 0, 'apply'), symbol(void 0, 'dictionary'), cons(symbol(void 0, '.concat'), sequenceExpand(concat.apply(void 0, seq(form))))) : isVector(form) ? cons(symbol(void 0, '.concat'), sequenceExpand(form)) : isList(form) ? isEmpty(form) ? cons(symbol(void 0, 'list'), void 0) : list(symbol(void 0, 'apply'), symbol(void 0, 'list'), cons(symbol(void 0, '.concat'), sequenceExpand(form))) : 'else' ? readerError('Unknown Collection type') : void 0;
    };
var syntaxQuoteExpand = exports.syntaxQuoteExpand = syntaxQuote;
var unquoteSplicingExpand = exports.unquoteSplicingExpand = function unquoteSplicingExpand(form) {
        return isVector(form) ? form : list(symbol(void 0, 'vec'), form);
    };
var sequenceExpand = exports.sequenceExpand = function sequenceExpand(forms) {
        return map(function (form) {
            return isUnquote(form) ? [second(form)] : isUnquoteSplicing(form) ? unquoteSplicingExpand(second(form)) : 'else' ? [syntaxQuoteExpand(form)] : void 0;
        }, forms);
    };
installMacro('syntax-quote', syntaxQuote);
var notEqual = exports.notEqual = function notEqual() {
        var body = Array.prototype.slice.call(arguments, 0);
        return list.apply(void 0, [symbol(void 0, 'not')].concat([list.apply(void 0, [symbol(void 0, '=')].concat(vec(body)))]));
    };
installMacro('not=', notEqual);
var ifNot = exports.ifNot = function ifNot(condition, truthy, alternative) {
        'Complements the `if` exclusive conditional branch.';
        return !condition ? truthy : alternative;
    };
installMacro('if-not', ifNot);
var expandComment = exports.expandComment = function expandComment() {
        var body = Array.prototype.slice.call(arguments, 0);
        return void 0;
    };
installMacro('comment', expandComment);
var expandThreadFirst = exports.expandThreadFirst = function expandThreadFirst() {
        var operations = Array.prototype.slice.call(arguments, 0);
        return reduce(function (form, operation) {
            return cons(first(operation), cons(form, rest(operation)));
        }, first(operations), rest(operations));
    };
installMacro('->', expandThreadFirst);
var expandCond = exports.expandCond = function expandCond() {
        var clauses = Array.prototype.slice.call(arguments, 0);
        return !isEmpty(clauses) ? list(symbol(void 0, 'if'), first(clauses), isEmpty(rest(clauses)) ? (function () {
            throw Error('cond requires an even number of forms');
        })() : second(clauses), cons(symbol(void 0, 'cond'), rest(rest(clauses)))) : void 0;
    };
installMacro('cond', expandCond);
var expandDefn = exports.expandDefn = function expandDefn(_andForm, name) {
        var docPlusMetaPlusBody = Array.prototype.slice.call(arguments, 2);
        return function () {
            var docø1 = isString(first(docPlusMetaPlusBody)) ? first(docPlusMetaPlusBody) : void 0;
            var metaPlusBodyø1 = docø1 ? rest(docPlusMetaPlusBody) : docPlusMetaPlusBody;
            var metadataø1 = isDictionary(first(metaPlusBodyø1)) ? conj({ 'doc': docø1 }, first(metaPlusBodyø1)) : void 0;
            var bodyø1 = metadataø1 ? rest(metaPlusBodyø1) : metaPlusBodyø1;
            var idø1 = withMeta(name, conj(meta(name) || {}, metadataø1));
            var fnø1 = withMeta(list.apply(void 0, [symbol(void 0, 'fn')].concat([idø1], vec(bodyø1))), meta(_andForm));
            return list.apply(void 0, [symbol(void 0, 'def')].concat([idø1], [fnø1]));
        }.call(this);
    };
installMacro('defn', withMeta(expandDefn, { 'implicit': ['&form'] }));
var expandPrivateDefn = exports.expandPrivateDefn = function expandPrivateDefn(name) {
        var body = Array.prototype.slice.call(arguments, 1);
        return function () {
            var metadataø1 = conj(meta(name) || {}, { 'private': true });
            var idø1 = withMeta(name, metadataø1);
            return list.apply(void 0, [symbol(void 0, 'defn')].concat([idø1], vec(body)));
        }.call(this);
    };
installMacro('defn-', expandPrivateDefn);
//# sourceMappingURL=data:application/json;base64,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
