{
    var _ns_ = {
        id: 'wisp.compiler',
        doc: void 0
    };
    var wisp_analyzer = require('./analyzer');
    var analyze = wisp_analyzer.analyze;
    var wisp_reader = require('./reader');
    var read_ = wisp_reader.read_;
    var read = wisp_reader.read;
    var pushBackReader = wisp_reader.pushBackReader;
    var wisp_string = require('./string');
    var replace = wisp_string.replace;
    var wisp_sequence = require('./sequence');
    var map = wisp_sequence.map;
    var reduce = wisp_sequence.reduce;
    var conj = wisp_sequence.conj;
    var cons = wisp_sequence.cons;
    var vec = wisp_sequence.vec;
    var first = wisp_sequence.first;
    var rest = wisp_sequence.rest;
    var isEmpty = wisp_sequence.isEmpty;
    var count = wisp_sequence.count;
    var wisp_runtime = require('./runtime');
    var isError = wisp_runtime.isError;
    var isEqual = wisp_runtime.isEqual;
    var wisp_ast = require('./ast');
    var name = wisp_ast.name;
    var symbol = wisp_ast.symbol;
    var prStr = wisp_ast.prStr;
    var wisp_backend_escodegen_generator = require('./backend/escodegen/generator');
    var generateJs = wisp_backend_escodegen_generator.generate;
    var base64Encode = require('base64-encode');
    var btoa = base64Encode;
}
var generate = exports.generate = generateJs;
var readForm = exports.readForm = function readForm(reader, eof) {
    return (function () {
        try {
            return read(reader, false, eof, false);
        } catch (error) {
            return error;
        }
    })();
};
var readForms = exports.readForms = function readForms(source, uri) {
    return function () {
        var readerø1 = pushBackReader(source, uri);
        var eofø1 = {};
        return function loop() {
            var recur = loop;
            var formsø1 = [];
            var formø1 = readForm(readerø1, eofø1);
            do {
                recur = isError(formø1) ? {
                    'forms': formsø1,
                    'error': formø1
                } : formø1 === eofø1 ? { 'forms': formsø1 } : 'else' ? (loop[0] = conj(formsø1, formø1), loop[1] = readForm(readerø1, eofø1), loop) : void 0;
            } while (formsø1 = loop[0], formø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    }.call(this);
};
var analyzeForm = exports.analyzeForm = function analyzeForm(env, form) {
    return (function () {
        try {
            return analyze(env, form);
        } catch (error) {
            return error;
        }
    })();
};
var analyzeForms = exports.analyzeForms = function analyzeForms(forms) {
    return function loop() {
        var recur = loop;
        var nodesø1 = [];
        var formsø2 = forms;
        var envø1 = {
            'locals': {},
            'bindings': [],
            'top': true,
            'ns': { 'name': symbol(void 0, 'user.wisp') }
        };
        do {
            recur = function () {
                var nodeø1 = analyzeForm(envø1, first(formsø2));
                var nsø1 = isEqual((nodeø1 || 0)['op'], 'ns') ? nodeø1 : (envø1 || 0)['ns'];
                return isError(nodeø1) ? {
                    'ast': nodesø1,
                    'error': nodeø1
                } : count(formsø2) <= 1 ? { 'ast': conj(nodesø1, nodeø1) } : 'else' ? (loop[0] = conj(nodesø1, nodeø1), loop[1] = rest(formsø2), loop[2] = conj(envø1, { 'ns': nsø1 }), loop) : void 0;
            }.call(this);
        } while (nodesø1 = loop[0], formsø2 = loop[1], envø1 = loop[2], recur === loop);
        return recur;
    }.call(this);
};
var compile = exports.compile = function compile() {
    switch (arguments.length) {
    case 1:
        var source = arguments[0];
        return compile(source, {});
    case 2:
        var source = arguments[0];
        var options = arguments[1];
        return function () {
            var sourceUriø1 = (options || 0)['source-uri'] || name('anonymous.wisp');
            var formsø1 = readForms(source, sourceUriø1);
            var astø1 = (formsø1 || 0)['error'] ? formsø1 : analyzeForms((formsø1 || 0)['forms']);
            var outputø1 = (astø1 || 0)['error'] ? astø1 : (function () {
                try {
                    return generate.apply(void 0, vec(cons(conj(options, {
                        'source': source,
                        'source-uri': sourceUriø1
                    }), (astø1 || 0)['ast'])));
                } catch (error) {
                    return { 'error': error };
                }
            })();
            var expansionø1 = 'expansion' === (options || 0)['print'] ? reduce(function (result, item) {
                return '' + result + prStr(item.form) + '\n';
            }, '', astø1.ast) : void 0;
            var resultø1 = {
                'source-uri': sourceUriø1,
                'ast': (astø1 || 0)['ast'],
                'forms': (formsø1 || 0)['forms'],
                'expansion': expansionø1
            };
            return conj(options, outputø1, resultø1);
        }.call(this);
    default:
        throw RangeError('Wrong number of arguments passed');
    }
};
var evaluate = exports.evaluate = function evaluate(source) {
    return function () {
        var outputø1 = compile(source);
        return (outputø1 || 0)['error'] ? (function () {
            throw (outputø1 || 0)['error'];
        })() : eval((outputø1 || 0)['code']);
    }.call(this);
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFub255bW91cy53aXNwIl0sIm5hbWVzIjpbIl9uc18iLCJpZCIsImRvYyIsImFuYWx5emUiLCJyZWFkXyIsInJlYWQiLCJwdXNoQmFja1JlYWRlciIsInJlcGxhY2UiLCJtYXAiLCJyZWR1Y2UiLCJjb25qIiwiY29ucyIsInZlYyIsImZpcnN0IiwicmVzdCIsImlzRW1wdHkiLCJjb3VudCIsImlzRXJyb3IiLCJpc0VxdWFsIiwibmFtZSIsInN5bWJvbCIsInByU3RyIiwiZ2VuZXJhdGVKcyIsImdlbmVyYXRlIiwiZXhwb3J0cyIsInJlYWRGb3JtIiwicmVhZGVyIiwiZW9mIiwiZXJyb3IiLCJyZWFkRm9ybXMiLCJzb3VyY2UiLCJ1cmkiLCJyZWFkZXLDuDEiLCJlb2bDuDEiLCJmb3Jtc8O4MSIsImZvcm3DuDEiLCJhbmFseXplRm9ybSIsImVudiIsImZvcm0iLCJhbmFseXplRm9ybXMiLCJmb3JtcyIsIm5vZGVzw7gxIiwiZm9ybXPDuDIiLCJlbnbDuDEiLCJub2Rlw7gxIiwibnPDuDEiLCJjb21waWxlIiwib3B0aW9ucyIsInNvdXJjZVVyacO4MSIsImFzdMO4MSIsIm91dHB1dMO4MSIsImV4cGFuc2lvbsO4MSIsInJlc3VsdCIsIml0ZW0iLCJhc3QiLCJyZXN1bHTDuDEiLCJldmFsdWF0ZSIsImV2YWwiXSwibWFwcGluZ3MiOiI7SUFBQSxJQUFDQSxJLEdBQUQ7QUFBQSxRQUFBQyxFLEVBQUksZUFBSjtBQUFBLFFBQUFDLEcsRUFBQSxLLENBQUE7QUFBQSxNOztRQUNtQ0MsT0FBQSxHLGNBQUFBLE87O1FBQ0ZDLEtBQUEsRyxZQUFBQSxLO1FBQU1DLElBQUEsRyxZQUFBQSxJO1FBQUtDLGNBQUEsRyxZQUFBQSxjOztRQUNYQyxPQUFBLEcsWUFBQUEsTzs7UUFDRUMsR0FBQSxHLGNBQUFBLEc7UUFBSUMsTUFBQSxHLGNBQUFBLE07UUFBT0MsSUFBQSxHLGNBQUFBLEk7UUFBS0MsSUFBQSxHLGNBQUFBLEk7UUFBS0MsR0FBQSxHLGNBQUFBLEc7UUFBSUMsS0FBQSxHLGNBQUFBLEs7UUFBTUMsSUFBQSxHLGNBQUFBLEk7UUFBS0MsT0FBQSxHLGNBQUFBLE87UUFBT0MsS0FBQSxHLGNBQUFBLEs7O1FBQzVDQyxPQUFBLEcsYUFBQUEsTztRQUFPQyxPQUFBLEcsYUFBQUEsTzs7UUFDWEMsSUFBQSxHLFNBQUFBLEk7UUFBS0MsTUFBQSxHLFNBQUFBLE07UUFBT0MsS0FBQSxHLFNBQUFBLEs7O1FBR3NCQyxVQUFBLEcsaUNBRFZDLFE7Ozs7QUFJdEQsSUFBS0EsUUFBQSxHQUFBQyxPQUFBLENBQUFELFFBQUEsR0FBU0QsVUFBZCxDO0FBRUEsSUFBTUcsUUFBQSxHQUFBRCxPQUFBLENBQUFDLFFBQUEsR0FBTixTQUFNQSxRQUFOLENBQ0dDLE1BREgsRUFDVUMsR0FEVixFQUVFO0FBQUEsVyxhQUFBO0FBQUEsWUFBSztBQUFBLG1CQUFDdEIsSUFBRCxDQUFNcUIsTUFBTixFLEtBQUEsRUFBbUJDLEdBQW5CLEUsS0FBQTtBQUFBLFNBQUwsQyxPQUNTQyxLLEVBQU07QUFBQSxtQkFBQUEsS0FBQTtBQUFBLFNBRGY7QUFBQSxLLENBQUE7QUFBQSxDQUZGLEM7QUFLQSxJQUFNQyxTQUFBLEdBQUFMLE9BQUEsQ0FBQUssU0FBQSxHQUFOLFNBQU1BLFNBQU4sQ0FDR0MsTUFESCxFQUNVQyxHQURWLEVBRUU7QUFBQSxXLFlBQU07QUFBQSxZQUFBQyxRLEdBQVExQixjQUFELENBQWtCd0IsTUFBbEIsRUFBeUJDLEdBQXpCLENBQVA7QUFBQSxRQUNBLElBQUFFLEssR0FBSSxFQUFKLENBREE7QUFBQSxRQUVKLE87O1lBQU8sSUFBQUMsTyxHQUFNLEVBQU4sQztZQUNBLElBQUFDLE0sR0FBTVYsUUFBRCxDQUFXTyxRQUFYLEVBQWtCQyxLQUFsQixDQUFMLEM7O3dCQUNFaEIsT0FBRCxDQUFRa0IsTUFBUixDQUFOLEdBQW9CO0FBQUEsb0IsU0FBUUQsT0FBUjtBQUFBLG9CLFNBQXFCQyxNQUFyQjtBQUFBLGlCQUFwQixHQUNrQkEsTUFBWixLQUFpQkYsSyxHQUFLLEUsU0FBUUMsT0FBUixFLFlBQ2hCLEMsVUFBUXhCLElBQUQsQ0FBTXdCLE9BQU4sRUFBWUMsTUFBWixDQUFQLEUsVUFDUVYsUUFBRCxDQUFXTyxRQUFYLEVBQWtCQyxLQUFsQixDQURQLEUsSUFBQSxDO3FCQUpQQyxPLFlBQ0FDLE07O2NBRFAsQyxJQUFBLEVBRkk7QUFBQSxLLEtBQU4sQyxJQUFBO0FBQUEsQ0FGRixDO0FBV0EsSUFBTUMsV0FBQSxHQUFBWixPQUFBLENBQUFZLFdBQUEsR0FBTixTQUFNQSxXQUFOLENBQ0dDLEdBREgsRUFDT0MsSUFEUCxFQUVFO0FBQUEsVyxhQUFBO0FBQUEsWUFBSztBQUFBLG1CQUFDbkMsT0FBRCxDQUFTa0MsR0FBVCxFQUFhQyxJQUFiO0FBQUEsU0FBTCxDLE9BQStCVixLLEVBQU07QUFBQSxtQkFBQUEsS0FBQTtBQUFBLFNBQXJDO0FBQUEsSyxDQUFBO0FBQUEsQ0FGRixDO0FBSUEsSUFBTVcsWUFBQSxHQUFBZixPQUFBLENBQUFlLFlBQUEsR0FBTixTQUFNQSxZQUFOLENBQ0dDLEtBREgsRUFFRTtBQUFBLFc7O1FBQU8sSUFBQUMsTyxHQUFNLEVBQU4sQztRQUNBLElBQUFDLE8sR0FBTUYsS0FBTixDO1FBQ0EsSUFBQUcsSyxHQUFJO0FBQUEsWSxVQUFTLEVBQVQ7QUFBQSxZLFlBQ1csRUFEWDtBQUFBLFksV0FBQTtBQUFBLFksTUFHSyxFLGNBQVEsQyxNQUFBLEUsV0FBQSxDQUFSLEVBSEw7QUFBQSxTQUFKLEM7O2dDQUlDO0FBQUEsb0JBQUFDLE0sR0FBTVIsV0FBRCxDQUFjTyxLQUFkLEVBQW1COUIsS0FBRCxDQUFPNkIsT0FBUCxDQUFsQixDQUFMO0FBQUEsZ0JBQ0EsSUFBQUcsSSxHQUFRM0IsT0FBRCxDLENBQVEwQixNLE1BQUwsQyxJQUFBLENBQUgsRSxJQUFBLENBQUosR0FDRUEsTUFERixHLENBRU9ELEssTUFBTCxDLElBQUEsQ0FGTCxDQURBO0FBQUEsZ0JBSUosT0FBTzFCLE9BQUQsQ0FBUTJCLE1BQVIsQ0FBTixHQUFvQjtBQUFBLG9CLE9BQU1ILE9BQU47QUFBQSxvQixTQUFtQkcsTUFBbkI7QUFBQSxpQkFBcEIsR0FDVzVCLEtBQUQsQ0FBTzBCLE9BQVAsQ0FBSixJQUFrQixDLEdBQUcsRSxPQUFPaEMsSUFBRCxDQUFNK0IsT0FBTixFQUFZRyxNQUFaLENBQU4sRSxZQUNmLEMsVUFBUWxDLElBQUQsQ0FBTStCLE9BQU4sRUFBWUcsTUFBWixDQUFQLEUsVUFDUTlCLElBQUQsQ0FBTTRCLE9BQU4sQ0FEUCxFLFVBRVFoQyxJQUFELENBQU1pQyxLQUFOLEVBQVUsRSxNQUFLRSxJQUFMLEVBQVYsQ0FGUCxFLElBQUEsQyxTQUZaLENBSkk7QUFBQSxhLEtBQU4sQyxJQUFBLEM7aUJBTktKLE8sWUFDQUMsTyxZQUNBQyxLOztVQUZQLEMsSUFBQTtBQUFBLENBRkYsQztBQWtCQSxJQUFNRyxPQUFBLEdBQUF0QixPQUFBLENBQUFzQixPQUFBLEdBQU4sU0FBTUEsT0FBTixHOzs7WUFzQkloQixNQUFBLEc7UUFBUSxPQUFDZ0IsT0FBRCxDQUFTaEIsTUFBVCxFQUFnQixFQUFoQixFOztZQUNSQSxNQUFBLEc7WUFBT2lCLE9BQUEsRztRQUNSLE8sWUFBTTtBQUFBLGdCQUFBQyxXLElBQTRCRCxPLE1BQWIsQyxZQUFBLENBQUosSUFBMkI1QixJQUFELEMsZ0JBQUEsQ0FBckM7QUFBQSxZQUNBLElBQUFlLE8sR0FBT0wsU0FBRCxDQUFZQyxNQUFaLEVBQW1Ca0IsV0FBbkIsQ0FBTixDQURBO0FBQUEsWUFHQSxJQUFBQyxLLElBQWdCZixPLE1BQVIsQyxPQUFBLENBQUosR0FDRUEsT0FERixHQUVHSyxZQUFELEMsQ0FBdUJMLE8sTUFBUixDLE9BQUEsQ0FBZixDQUZOLENBSEE7QUFBQSxZQU9BLElBQUFnQixRLElBQW1CRCxLLE1BQVIsQyxPQUFBLENBQUosR0FDRUEsS0FERixHLGFBRUU7QUFBQSxvQkFFRTtBQUFBLDJCQUFPMUIsUSxNQUFQLEMsTUFBQSxFQUFpQlgsR0FBRCxDQUFNRCxJQUFELENBQU9ELElBQUQsQ0FBTXFDLE9BQU4sRUFDTTtBQUFBLHdCLFVBQVNqQixNQUFUO0FBQUEsd0IsY0FDYWtCLFdBRGI7QUFBQSxxQkFETixDQUFOLEUsQ0FHWUMsSyxNQUFOLEMsS0FBQSxDQUhOLENBQUwsQ0FBaEI7QUFBQSxpQkFGRixDLE9BTVNyQixLLEVBQU07QUFBQSw2QixTQUFRQSxLQUFSO0FBQUEsaUJBTmY7QUFBQSxhLENBQUEsRUFGVCxDQVBBO0FBQUEsWUFpQkEsSUFBQXVCLFcsY0FBYyxLLENBQStCSixPLE1BQVIsQyxPQUFBLENBQTNCLEdBQ0d0QyxNQUFELENBQVEsVUFBSzJDLE1BQUwsRUFBWUMsSUFBWixFQUNLO0FBQUEsdUIsS0FBS0QsTSxHQUFRL0IsS0FBRCxDQUFnQmdDLElBQVIsQ0FBR2YsSUFBWCxDQUFaLEdBQW1DLElBQW5DO0FBQUEsYUFEYixFQUVhLEVBRmIsRUFFdUJXLEtBQVAsQ0FBR0ssR0FGbkIsQ0FERixHLE1BQVYsQ0FqQkE7QUFBQSxZQXNCQSxJQUFBQyxRLEdBQU87QUFBQSxnQixjQUFhUCxXQUFiO0FBQUEsZ0IsUUFDWUMsSyxNQUFOLEMsS0FBQSxDQUROO0FBQUEsZ0IsVUFFZ0JmLE8sTUFBUixDLE9BQUEsQ0FGUjtBQUFBLGdCLGFBR1lpQixXQUhaO0FBQUEsYUFBUCxDQXRCQTtBQUFBLFlBMEJKLE9BQUN6QyxJQUFELENBQU1xQyxPQUFOLEVBQWNHLFFBQWQsRUFBcUJLLFFBQXJCLEVBMUJJO0FBQUEsUyxLQUFOLEMsSUFBQSxFOzs7O0NBeEJILEM7QUFvREEsSUFBTUMsUUFBQSxHQUFBaEMsT0FBQSxDQUFBZ0MsUUFBQSxHQUFOLFNBQU1BLFFBQU4sQ0FDRzFCLE1BREgsRUFFRTtBQUFBLFcsWUFBTTtBQUFBLFlBQUFvQixRLEdBQVFKLE9BQUQsQ0FBU2hCLE1BQVQsQ0FBUDtBQUFBLFFBQ0osTyxDQUFZb0IsUSxNQUFSLEMsT0FBQSxDQUFKLEcsYUFDRTtBQUFBLGtCLENBQWVBLFEsTUFBUixDLE9BQUEsQ0FBUDtBQUFBLFMsQ0FBQSxFQURGLEdBRUdPLElBQUQsQyxDQUFhUCxRLE1BQVAsQyxNQUFBLENBQU4sQ0FGRixDQURJO0FBQUEsSyxLQUFOLEMsSUFBQTtBQUFBLENBRkYiLCJzb3VyY2VzQ29udGVudCI6WyIobnMgd2lzcC5jb21waWxlclxuICAoOnJlcXVpcmUgW3dpc3AuYW5hbHl6ZXIgOnJlZmVyIFthbmFseXplXV1cbiAgICAgICAgICAgIFt3aXNwLnJlYWRlciA6cmVmZXIgW3JlYWQqIHJlYWQgcHVzaC1iYWNrLXJlYWRlcl1dXG4gICAgICAgICAgICBbd2lzcC5zdHJpbmcgOnJlZmVyIFtyZXBsYWNlXV1cbiAgICAgICAgICAgIFt3aXNwLnNlcXVlbmNlIDpyZWZlciBbbWFwIHJlZHVjZSBjb25qIGNvbnMgdmVjIGZpcnN0IHJlc3QgZW1wdHk/IGNvdW50XV1cbiAgICAgICAgICAgIFt3aXNwLnJ1bnRpbWUgOnJlZmVyIFtlcnJvcj8gPV1dXG4gICAgICAgICAgICBbd2lzcC5hc3QgOnJlZmVyIFtuYW1lIHN5bWJvbCBwci1zdHJdXVxuXG4gICAgICAgICAgICBbd2lzcC5iYWNrZW5kLmVzY29kZWdlbi5nZW5lcmF0b3IgOnJlZmVyIFtnZW5lcmF0ZV1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA6cmVuYW1lIHtnZW5lcmF0ZSBnZW5lcmF0ZS1qc31dXG4gICAgICAgICAgICBbYmFzZTY0LWVuY29kZSA6YXMgYnRvYV0pKVxuXG4oZGVmIGdlbmVyYXRlIGdlbmVyYXRlLWpzKVxuXG4oZGVmbiByZWFkLWZvcm1cbiAgW3JlYWRlciBlb2ZdXG4gICh0cnkgKHJlYWQgcmVhZGVyIGZhbHNlIGVvZiBmYWxzZSlcbiAgICAoY2F0Y2ggZXJyb3IgZXJyb3IpKSlcblxuKGRlZm4gcmVhZC1mb3Jtc1xuICBbc291cmNlIHVyaV1cbiAgKGxldCBbcmVhZGVyIChwdXNoLWJhY2stcmVhZGVyIHNvdXJjZSB1cmkpXG4gICAgICAgIGVvZiB7fV1cbiAgICAobG9vcCBbZm9ybXMgW11cbiAgICAgICAgICAgZm9ybSAocmVhZC1mb3JtIHJlYWRlciBlb2YpXVxuICAgICAgKGNvbmQgKGVycm9yPyBmb3JtKSB7OmZvcm1zIGZvcm1zIDplcnJvciBmb3JtfVxuICAgICAgICAgICAgKGlkZW50aWNhbD8gZm9ybSBlb2YpIHs6Zm9ybXMgZm9ybXN9XG4gICAgICAgICAgICA6ZWxzZSAocmVjdXIgKGNvbmogZm9ybXMgZm9ybSlcbiAgICAgICAgICAgICAgICAgICAgICAgICAocmVhZC1mb3JtIHJlYWRlciBlb2YpKSkpKSlcblxuKGRlZm4gYW5hbHl6ZS1mb3JtXG4gIFtlbnYgZm9ybV1cbiAgKHRyeSAoYW5hbHl6ZSBlbnYgZm9ybSkgKGNhdGNoIGVycm9yIGVycm9yKSkpXG5cbihkZWZuIGFuYWx5emUtZm9ybXNcbiAgW2Zvcm1zXVxuICAobG9vcCBbbm9kZXMgW11cbiAgICAgICAgIGZvcm1zIGZvcm1zXG4gICAgICAgICBlbnYgezpsb2NhbHMge31cbiAgICAgICAgICAgICAgOmJpbmRpbmdzIFtdXG4gICAgICAgICAgICAgIDp0b3AgdHJ1ZVxuICAgICAgICAgICAgICA6bnMgezpuYW1lICd1c2VyLndpc3B9fV1cbiAgICAobGV0IFtub2RlIChhbmFseXplLWZvcm0gZW52IChmaXJzdCBmb3JtcykpXG4gICAgICAgICAgbnMgKGlmICg9ICg6b3Agbm9kZSkgOm5zKVxuICAgICAgICAgICAgICAgbm9kZVxuICAgICAgICAgICAgICAgKDpucyBlbnYpKV1cbiAgICAgIChjb25kIChlcnJvcj8gbm9kZSkgezphc3Qgbm9kZXMgOmVycm9yIG5vZGV9XG4gICAgICAgICAgICAoPD0gKGNvdW50IGZvcm1zKSAxKSB7OmFzdCAoY29uaiBub2RlcyBub2RlKX1cbiAgICAgICAgICAgIDplbHNlIChyZWN1ciAoY29uaiBub2RlcyBub2RlKVxuICAgICAgICAgICAgICAgICAgICAgICAgIChyZXN0IGZvcm1zKVxuICAgICAgICAgICAgICAgICAgICAgICAgIChjb25qIGVudiB7Om5zIG5zfSkpKSkpKVxuXG4oZGVmbiBjb21waWxlXG4gIFwiQ29tcGlsZXIgdGFrZXMgd2lzcCBjb2RlIGluIGZvcm0gb2Ygc3RyaW5nIGFuZCByZXR1cm5zIGEgaGFzaFxuICBjb250YWluaW5nIGA6c291cmNlYCByZXByZXNlbnRpbmcgY29tcGlsYXRpb24gcmVzdWx0LiBJZlxuICBgKDpzb3VyY2UtbWFwIG9wdGlvbnMpYCBpcyBgdHJ1ZWAgdGhlbiBgOnNvdXJjZS1tYXBgIG9mIHRoZSByZXR1cm5lZFxuICBoYXNoIHdpbGwgY29udGFpbiBzb3VyY2UgbWFwIGZvciBpdC5cbiAgOm91dHB1dC11cmlcbiAgOnNvdXJjZS1tYXAtdXJpXG5cbiAgUmV0dXJucyBoYXNoIHdpdGggZm9sbG93aW5nIGZpZWxkczpcblxuICA6Y29kZSAtIEdlbmVyYXRlZCBjb2RlLlxuXG4gIDpzb3VyY2UtbWFwIC0gR2VuZXJhdGVkIHNvdXJjZSBtYXAuIE9ubHkgaWYgKDpzb3VyY2UtbWFwIG9wdGlvbnMpXG4gICAgICAgICAgICAgICAgd2FzIHRydWUuXG5cbiAgOm91dHB1dC11cmkgLSBSZXR1cm5zIGJhY2sgKDpvdXRwdXQtdXJpIG9wdGlvbnMpIGlmIHdhcyBwYXNzZWQgaW4sXG4gICAgICAgICAgICAgICAgb3RoZXJ3aXNlIGNvbXB1dGVzIG9uZSBmcm9tICg6c291cmNlLXVyaSBvcHRpb25zKSBieVxuICAgICAgICAgICAgICAgIGNoYW5naW5nIGZpbGUgZXh0ZW5zaW9uLlxuXG4gIDpzb3VyY2UtbWFwLXVyaSAtIFJldHVybnMgYmFjayAoOnNvdXJjZS1tYXAtdXJpIG9wdGlvbnMpIGlmIHdhcyBwYXNzZWRcbiAgICAgICAgICAgICAgICAgICAgaW4sIG90aGVyd2lzZSBjb21wdXRlcyBvbmUgZnJvbSAoOnNvdXJjZS11cmkgb3B0aW9ucylcbiAgICAgICAgICAgICAgICAgICAgYnkgYWRkaW5nIGAubWFwYCBmaWxlIGV4dGVuc2lvbi5cIlxuICAoW3NvdXJjZV0gKGNvbXBpbGUgc291cmNlIHt9KSlcbiAgKFtzb3VyY2Ugb3B0aW9uc11cbiAgIChsZXQgW3NvdXJjZS11cmkgKG9yICg6c291cmNlLXVyaSBvcHRpb25zKSAobmFtZSA6YW5vbnltb3VzLndpc3ApKSA7OyBIQUNLOiBXb3JrYXJvdW5kIGZvciBzZWdmYXVsdCAjNjY5MVxuICAgICAgICAgZm9ybXMgKHJlYWQtZm9ybXMgc291cmNlIHNvdXJjZS11cmkpXG5cbiAgICAgICAgIGFzdCAoaWYgKDplcnJvciBmb3JtcylcbiAgICAgICAgICAgICAgIGZvcm1zXG4gICAgICAgICAgICAgICAoYW5hbHl6ZS1mb3JtcyAoOmZvcm1zIGZvcm1zKSkpXG5cbiAgICAgICAgIG91dHB1dCAoaWYgKDplcnJvciBhc3QpXG4gICAgICAgICAgICAgICAgICBhc3RcbiAgICAgICAgICAgICAgICAgICh0cnkgICAgICAgICAgICAgIDs7IFRPRE86IFJlbW92ZSB0aGlzXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA7OyBPbGQgY29tcGlsZXIgaGFzIGluY29ycmVjdCBhcHBseS5cbiAgICAgICAgICAgICAgICAgICAgKGFwcGx5IGdlbmVyYXRlICh2ZWMgKGNvbnMgKGNvbmogb3B0aW9uc1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7OnNvdXJjZSBzb3VyY2VcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDpzb3VyY2UtdXJpIHNvdXJjZS11cml9KVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAoOmFzdCBhc3QpKSkpXG4gICAgICAgICAgICAgICAgICAgIChjYXRjaCBlcnJvciB7OmVycm9yIGVycm9yfSkpKVxuXG4gICAgICAgICBleHBhbnNpb24gKGlmIChpZGVudGljYWw/IDpleHBhbnNpb24gKDpwcmludCBvcHRpb25zKSlcbiAgICAgICAgICAgICAgICAgICAgIChyZWR1Y2UgKGZuIFtyZXN1bHQgaXRlbV1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAoc3RyIHJlc3VsdCAocHItc3RyICguLWZvcm0gaXRlbSkpIFwiXFxuXCIpKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiXCIgKC4tYXN0IGFzdCkpKVxuXG4gICAgICAgICByZXN1bHQgezpzb3VyY2UtdXJpIHNvdXJjZS11cmlcbiAgICAgICAgICAgICAgICAgOmFzdCAoOmFzdCBhc3QpXG4gICAgICAgICAgICAgICAgIDpmb3JtcyAoOmZvcm1zIGZvcm1zKVxuICAgICAgICAgICAgICAgICA6ZXhwYW5zaW9uIGV4cGFuc2lvbn1dXG4gICAgIChjb25qIG9wdGlvbnMgb3V0cHV0IHJlc3VsdCkpKSlcblxuKGRlZm4gZXZhbHVhdGVcbiAgW3NvdXJjZV1cbiAgKGxldCBbb3V0cHV0IChjb21waWxlIHNvdXJjZSldXG4gICAgKGlmICg6ZXJyb3Igb3V0cHV0KVxuICAgICAgKHRocm93ICg6ZXJyb3Igb3V0cHV0KSlcbiAgICAgIChldmFsICg6Y29kZSBvdXRwdXQpKSkpKVxuIl19
