{
    var _ns_ = {
            id: 'wisp.compiler',
            doc: void 0
        };
    var wisp_analyzer = require('./analyzer');
    var analyze = wisp_analyzer.analyze;
    var wisp_reader = require('./reader');
    var read_ = wisp_reader.read_;
    var read = wisp_reader.read;
    var pushBackReader = wisp_reader.pushBackReader;
    var wisp_string = require('./string');
    var replace = wisp_string.replace;
    var wisp_sequence = require('./sequence');
    var map = wisp_sequence.map;
    var reduce = wisp_sequence.reduce;
    var conj = wisp_sequence.conj;
    var cons = wisp_sequence.cons;
    var vec = wisp_sequence.vec;
    var first = wisp_sequence.first;
    var rest = wisp_sequence.rest;
    var isEmpty = wisp_sequence.isEmpty;
    var count = wisp_sequence.count;
    var wisp_runtime = require('./runtime');
    var isError = wisp_runtime.isError;
    var isEqual = wisp_runtime.isEqual;
    var wisp_ast = require('./ast');
    var name = wisp_ast.name;
    var symbol = wisp_ast.symbol;
    var prStr = wisp_ast.prStr;
    var wisp_backend_escodegen_generator = require('./backend/escodegen/generator');
    var generateJs = wisp_backend_escodegen_generator.generate;
    var base64Encode = require('base64-encode');
    var btoa = base64Encode;
}
var generate = exports.generate = generateJs;
var readForm = exports.readForm = function readForm(reader, eof) {
        return (function () {
            try {
                return read(reader, false, eof, false);
            } catch (error) {
                return error;
            }
        })();
    };
var readForms = exports.readForms = function readForms(source, uri) {
        return function () {
            var readerø1 = pushBackReader(source, uri);
            var eofø1 = {};
            return function loop() {
                var recur = loop;
                var formsø1 = [];
                var formø1 = readForm(readerø1, eofø1);
                do {
                    recur = isError(formø1) ? {
                        'forms': formsø1,
                        'error': formø1
                    } : formø1 === eofø1 ? { 'forms': formsø1 } : 'else' ? (loop[0] = conj(formsø1, formø1), loop[1] = readForm(readerø1, eofø1), loop) : void 0;
                } while (formsø1 = loop[0], formø1 = loop[1], recur === loop);
                return recur;
            }.call(this);
        }.call(this);
    };
var analyzeForm = exports.analyzeForm = function analyzeForm(env, form) {
        return (function () {
            try {
                return analyze(env, form);
            } catch (error) {
                return error;
            }
        })();
    };
var analyzeForms = exports.analyzeForms = function analyzeForms(forms) {
        return function loop() {
            var recur = loop;
            var nodesø1 = [];
            var formsø2 = forms;
            var envø1 = {
                    'locals': {},
                    'bindings': [],
                    'top': true,
                    'ns': { 'name': symbol(void 0, 'user.wisp') }
                };
            do {
                recur = function () {
                    var nodeø1 = analyzeForm(envø1, first(formsø2));
                    var nsø1 = isEqual((nodeø1 || 0)['op'], 'ns') ? nodeø1 : (envø1 || 0)['ns'];
                    return isError(nodeø1) ? {
                        'ast': nodesø1,
                        'error': nodeø1
                    } : count(formsø2) <= 1 ? { 'ast': conj(nodesø1, nodeø1) } : 'else' ? (loop[0] = conj(nodesø1, nodeø1), loop[1] = rest(formsø2), loop[2] = conj(envø1, { 'ns': nsø1 }), loop) : void 0;
                }.call(this);
            } while (nodesø1 = loop[0], formsø2 = loop[1], envø1 = loop[2], recur === loop);
            return recur;
        }.call(this);
    };
var compile = exports.compile = function compile() {
        switch (arguments.length) {
        case 1:
            var source = arguments[0];
            return compile(source, {});
        case 2:
            var source = arguments[0];
            var options = arguments[1];
            return function () {
                var sourceUriø1 = (options || 0)['source-uri'] || name('anonymous.wisp');
                var formsø1 = readForms(source, sourceUriø1);
                var astø1 = (formsø1 || 0)['error'] ? formsø1 : analyzeForms((formsø1 || 0)['forms']);
                var outputø1 = (astø1 || 0)['error'] ? astø1 : (function () {
                        try {
                            return generate.apply(void 0, vec(cons(conj(options, {
                                'source': source,
                                'source-uri': sourceUriø1
                            }), (astø1 || 0)['ast'])));
                        } catch (error) {
                            return { 'error': error };
                        }
                    })();
                var expansionø1 = 'expansion' === (options || 0)['print'] ? reduce(function (result, item) {
                        return '' + result + prStr(item.form) + '\n';
                    }, '', astø1.ast) : void 0;
                var resultø1 = {
                        'source-uri': sourceUriø1,
                        'ast': (astø1 || 0)['ast'],
                        'forms': (formsø1 || 0)['forms'],
                        'expansion': expansionø1
                    };
                return conj(options, outputø1, resultø1);
            }.call(this);
        default:
            throw RangeError('Wrong number of arguments passed');
        }
    };
var evaluate = exports.evaluate = function evaluate(source) {
        return function () {
            var outputø1 = compile(source);
            return (outputø1 || 0)['error'] ? (function () {
                throw (outputø1 || 0)['error'];
            })() : eval((outputø1 || 0)['code']);
        }.call(this);
    };
//# sourceMappingURL=data:application/json;base64,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
