{
    var _ns_ = {
            id: 'wisp.backend.escodegen.writer',
            doc: void 0
        };
    var wisp_reader = require('./../../reader');
    var readFromString = wisp_reader.readFromString;
    var wisp_ast = require('./../../ast');
    var meta = wisp_ast.meta;
    var withMeta = wisp_ast.withMeta;
    var isSymbol = wisp_ast.isSymbol;
    var symbol = wisp_ast.symbol;
    var isKeyword = wisp_ast.isKeyword;
    var keyword = wisp_ast.keyword;
    var namespace = wisp_ast.namespace;
    var isUnquote = wisp_ast.isUnquote;
    var isUnquoteSplicing = wisp_ast.isUnquoteSplicing;
    var isQuote = wisp_ast.isQuote;
    var isSyntaxQuote = wisp_ast.isSyntaxQuote;
    var name = wisp_ast.name;
    var gensym = wisp_ast.gensym;
    var prStr = wisp_ast.prStr;
    var wisp_sequence = require('./../../sequence');
    var isEmpty = wisp_sequence.isEmpty;
    var count = wisp_sequence.count;
    var isList = wisp_sequence.isList;
    var list = wisp_sequence.list;
    var first = wisp_sequence.first;
    var second = wisp_sequence.second;
    var third = wisp_sequence.third;
    var rest = wisp_sequence.rest;
    var cons = wisp_sequence.cons;
    var conj = wisp_sequence.conj;
    var butlast = wisp_sequence.butlast;
    var reverse = wisp_sequence.reverse;
    var reduce = wisp_sequence.reduce;
    var vec = wisp_sequence.vec;
    var last = wisp_sequence.last;
    var map = wisp_sequence.map;
    var filter = wisp_sequence.filter;
    var take = wisp_sequence.take;
    var concat = wisp_sequence.concat;
    var partition = wisp_sequence.partition;
    var repeat = wisp_sequence.repeat;
    var interleave = wisp_sequence.interleave;
    var assoc = wisp_sequence.assoc;
    var wisp_runtime = require('./../../runtime');
    var isOdd = wisp_runtime.isOdd;
    var isDictionary = wisp_runtime.isDictionary;
    var dictionary = wisp_runtime.dictionary;
    var merge = wisp_runtime.merge;
    var keys = wisp_runtime.keys;
    var vals = wisp_runtime.vals;
    var isContainsVector = wisp_runtime.isContainsVector;
    var mapDictionary = wisp_runtime.mapDictionary;
    var isString = wisp_runtime.isString;
    var isNumber = wisp_runtime.isNumber;
    var isVector = wisp_runtime.isVector;
    var isBoolean = wisp_runtime.isBoolean;
    var subs = wisp_runtime.subs;
    var reFind = wisp_runtime.reFind;
    var isTrue = wisp_runtime.isTrue;
    var isFalse = wisp_runtime.isFalse;
    var isNil = wisp_runtime.isNil;
    var isRePattern = wisp_runtime.isRePattern;
    var inc = wisp_runtime.inc;
    var dec = wisp_runtime.dec;
    var str = wisp_runtime.str;
    var char = wisp_runtime.char;
    var int = wisp_runtime.int;
    var isEqual = wisp_runtime.isEqual;
    var isStrictEqual = wisp_runtime.isStrictEqual;
    var wisp_string = require('./../../string');
    var split = wisp_string.split;
    var join = wisp_string.join;
    var upperCase = wisp_string.upperCase;
    var replace = wisp_string.replace;
    var triml = wisp_string.triml;
    var wisp_expander = require('./../../expander');
    var installMacro = wisp_expander.installMacro;
    var escodegen = require('escodegen');
    var generate = escodegen.generate;
}
var __uniqueChar__ = exports.__uniqueChar__ = '\xF8';
var toCamelJoin = exports.toCamelJoin = function toCamelJoin(prefix, key) {
        return '' + prefix + (!isEmpty(prefix) && !isEmpty(key) ? '' + upperCase((key || 0)[0]) + subs(key, 1) : key);
    };
var toPrivatePrefix = exports.toPrivatePrefix = function toPrivatePrefix(id) {
        return function () {
            var spaceDelimitedø1 = join(' ', split(id, /-/));
            var leftTrimmedø1 = triml(spaceDelimitedø1);
            var nø1 = count(id) - count(leftTrimmedø1);
            return nø1 > 0 ? '' + join('_', repeat(inc(nø1), '')) + subs(id, nø1) : id;
        }.call(this);
    };
var translateIdentifierWord = exports.translateIdentifierWord = function translateIdentifierWord(form) {
        var id = name(form);
        id = id === '*' ? 'multiply' : id === '/' ? 'divide' : id === '+' ? 'sum' : id === '-' ? 'subtract' : id === '=' ? 'equal?' : id === '==' ? 'strict-equal?' : id === '<=' ? 'not-greater-than' : id === '>=' ? 'not-less-than' : id === '>' ? 'greater-than' : id === '<' ? 'less-than' : id === '->' ? 'thread-first' : 'else' ? id : void 0;
        id = join('_', split(id, '*'));
        id = join('_', split(id, '.'));
        id = subs(id, 0, 2) === '->' ? subs(join('-to-', split(id, '->')), 1) : join('-to-', split(id, '->'));
        id = join(split(id, '!'));
        id = join('$', split(id, '%'));
        id = join('-equal-', split(id, '='));
        id = join('-plus-', split(id, '+'));
        id = join('-and-', split(id, '&'));
        id = last(id) === '?' ? '' + 'is-' + subs(id, 0, dec(count(id))) : id;
        id = toPrivatePrefix(id);
        id = reduce(toCamelJoin, '', split(id, '-'));
        return id;
    };
var translateIdentifier = exports.translateIdentifier = function translateIdentifier(form) {
        return function () {
            var nsø1 = namespace(form);
            return '' + (nsø1 && !isEqual(nsø1, 'js') ? '' + translateIdentifierWord(namespace(form)) + '.' : '') + join('.', map(translateIdentifierWord, split(name(form), '.')));
        }.call(this);
    };
var errorArgCount = exports.errorArgCount = function errorArgCount(callee, n) {
        return (function () {
            throw SyntaxError('' + 'Wrong number of arguments (' + n + ') passed to: ' + callee);
        })();
    };
var inheritLocation = exports.inheritLocation = function inheritLocation(body) {
        return function () {
            var startø1 = ((first(body) || 0)['loc'] || 0)['start'];
            var endø1 = ((last(body) || 0)['loc'] || 0)['end'];
            return !(isNil(startø1) || isNil(endø1)) ? {
                'start': startø1,
                'end': endø1
            } : void 0;
        }.call(this);
    };
var writeLocation = exports.writeLocation = function writeLocation(form, original) {
        return function () {
            var dataø1 = meta(form);
            var inheritedø1 = meta(original);
            var startø1 = (form || 0)['start'] || (dataø1 || 0)['start'] || (inheritedø1 || 0)['start'];
            var endø1 = (form || 0)['end'] || (dataø1 || 0)['end'] || (inheritedø1 || 0)['end'];
            return !isNil(startø1) ? {
                'loc': {
                    'start': {
                        'line': inc((startø1 || 0)['line']),
                        'column': (startø1 || 0)['column']
                    },
                    'end': {
                        'line': inc((endø1 || 0)['line']),
                        'column': (endø1 || 0)['column']
                    }
                }
            } : {};
        }.call(this);
    };
var __writers__ = exports.__writers__ = {};
var installWriter = exports.installWriter = function installWriter(op, writer) {
        return (__writers__ || 0)[op] = writer;
    };
var writeOp = exports.writeOp = function writeOp(op, form) {
        return function () {
            var writerø1 = (__writers__ || 0)[op];
            !writerø1 ? (function () {
                throw Error('' + 'Assert failed: ' + ('' + 'Unsupported operation: ' + op) + 'writer');
            })() : void 0;
            return conj(writeLocation((form || 0)['form'], (form || 0)['original-form']), writerø1(form));
        }.call(this);
    };
var __specials__ = exports.__specials__ = {};
var installSpecial = exports.installSpecial = function installSpecial(op, writer) {
        return (__specials__ || 0)[name(op)] = writer;
    };
var writeSpecial = exports.writeSpecial = function writeSpecial(writer, form) {
        return conj(writeLocation((form || 0)['form'], (form || 0)['original-form']), writer.apply(void 0, (form || 0)['params']));
    };
var writeNil = exports.writeNil = function writeNil(form) {
        return {
            'type': 'UnaryExpression',
            'operator': 'void',
            'argument': {
                'type': 'Literal',
                'value': 0
            },
            'prefix': true
        };
    };
installWriter('nil', writeNil);
var writeLiteral = exports.writeLiteral = function writeLiteral(form) {
        return {
            'type': 'Literal',
            'value': form
        };
    };
var writeList = exports.writeList = function writeList(form) {
        return {
            'type': 'CallExpression',
            'callee': write({
                'op': 'var',
                'form': symbol(void 0, 'list')
            }),
            'arguments': map(write, (form || 0)['items'])
        };
    };
installWriter('list', writeList);
var writeSymbol = exports.writeSymbol = function writeSymbol(form) {
        return {
            'type': 'CallExpression',
            'callee': write({
                'op': 'var',
                'form': symbol(void 0, 'symbol')
            }),
            'arguments': [
                writeConstant((form || 0)['namespace']),
                writeConstant((form || 0)['name'])
            ]
        };
    };
installWriter('symbol', writeSymbol);
var writeConstant = exports.writeConstant = function writeConstant(form) {
        return isNil(form) ? writeNil(form) : isKeyword(form) ? writeLiteral(namespace(form) ? '' + namespace(form) + '/' + name(form) : name(form)) : isNumber(form) ? writeNumber(form.valueOf()) : isString(form) ? writeString(form) : 'else' ? writeLiteral(form) : void 0;
    };
installWriter('constant', function ($1) {
    return writeConstant(($1 || 0)['form']);
});
var writeString = exports.writeString = function writeString(form) {
        return {
            'type': 'Literal',
            'value': '' + form
        };
    };
var writeNumber = exports.writeNumber = function writeNumber(form) {
        return form < 0 ? {
            'type': 'UnaryExpression',
            'operator': '-',
            'prefix': true,
            'argument': writeNumber(form * -1)
        } : writeLiteral(form);
    };
var writeKeyword = exports.writeKeyword = function writeKeyword(form) {
        return {
            'type': 'Literal',
            'value': (form || 0)['form']
        };
    };
installWriter('keyword', writeKeyword);
var toIdentifier = exports.toIdentifier = function toIdentifier(form) {
        return {
            'type': 'Identifier',
            'name': translateIdentifier(form)
        };
    };
var writeBindingVar = exports.writeBindingVar = function writeBindingVar(form) {
        return function () {
            var baseIdø1 = (form || 0)['id'];
            var resolvedIdø1 = (form || 0)['shadow'] ? symbol(void 0, '' + translateIdentifier(baseIdø1) + __uniqueChar__ + (form || 0)['depth']) : baseIdø1;
            return conj(toIdentifier(resolvedIdø1), writeLocation(baseIdø1));
        }.call(this);
    };
var writeVar = exports.writeVar = function writeVar(node) {
        return isEqual('binding', ((node || 0)['binding'] || 0)['type']) ? conj(writeBindingVar((node || 0)['binding']), writeLocation((node || 0)['form'])) : conj(writeLocation((node || 0)['form']), toIdentifier((node || 0)['form']));
    };
installWriter('var', writeVar);
installWriter('param', writeVar);
var writeInvoke = exports.writeInvoke = function writeInvoke(form) {
        return {
            'type': 'CallExpression',
            'callee': write((form || 0)['callee']),
            'arguments': map(write, (form || 0)['params'])
        };
    };
installWriter('invoke', writeInvoke);
var writeVector = exports.writeVector = function writeVector(form) {
        return {
            'type': 'ArrayExpression',
            'elements': map(write, (form || 0)['items'])
        };
    };
installWriter('vector', writeVector);
var writeDictionary = exports.writeDictionary = function writeDictionary(form) {
        return function () {
            var propertiesø1 = partition(2, interleave((form || 0)['keys'], (form || 0)['values']));
            return {
                'type': 'ObjectExpression',
                'properties': map(function (pair) {
                    return function () {
                        var keyø1 = first(pair);
                        var valueø1 = second(pair);
                        return {
                            'kind': 'init',
                            'type': 'Property',
                            'key': isEqual('symbol', (keyø1 || 0)['op']) ? writeConstant('' + (keyø1 || 0)['form']) : write(keyø1),
                            'value': write(valueø1)
                        };
                    }.call(this);
                }, propertiesø1)
            };
        }.call(this);
    };
installWriter('dictionary', writeDictionary);
var writeExport = exports.writeExport = function writeExport(form) {
        return write({
            'op': 'set!',
            'target': {
                'op': 'member-expression',
                'computed': false,
                'target': {
                    'op': 'var',
                    'form': withMeta(symbol(void 0, 'exports'), meta(((form || 0)['id'] || 0)['form']))
                },
                'property': (form || 0)['id'],
                'form': ((form || 0)['id'] || 0)['form']
            },
            'value': (form || 0)['init'],
            'form': ((form || 0)['id'] || 0)['form']
        });
    };
var writeDef = exports.writeDef = function writeDef(form) {
        return conj({
            'type': 'VariableDeclaration',
            'kind': 'var',
            'declarations': [conj({
                    'type': 'VariableDeclarator',
                    'id': write((form || 0)['id']),
                    'init': conj((form || 0)['export'] ? writeExport(form) : write((form || 0)['init']))
                }, writeLocation(((form || 0)['id'] || 0)['form']))]
        }, writeLocation((form || 0)['form'], (form || 0)['original-form']));
    };
installWriter('def', writeDef);
var writeBinding = exports.writeBinding = function writeBinding(form) {
        return function () {
            var idø1 = writeBindingVar(form);
            var initø1 = write((form || 0)['init']);
            return {
                'type': 'VariableDeclaration',
                'kind': 'var',
                'loc': inheritLocation([
                    idø1,
                    initø1
                ]),
                'declarations': [{
                        'type': 'VariableDeclarator',
                        'id': idø1,
                        'init': initø1
                    }]
            };
        }.call(this);
    };
installWriter('binding', writeBinding);
var writeThrow = exports.writeThrow = function writeThrow(form) {
        return toExpression(conj({
            'type': 'ThrowStatement',
            'argument': write((form || 0)['throw'])
        }, writeLocation((form || 0)['form'], (form || 0)['original-form'])));
    };
installWriter('throw', writeThrow);
var writeNew = exports.writeNew = function writeNew(form) {
        return {
            'type': 'NewExpression',
            'callee': write((form || 0)['constructor']),
            'arguments': map(write, (form || 0)['params'])
        };
    };
installWriter('new', writeNew);
var writeSet = exports.writeSet = function writeSet(form) {
        return {
            'type': 'AssignmentExpression',
            'operator': '=',
            'left': write((form || 0)['target']),
            'right': write((form || 0)['value'])
        };
    };
installWriter('set!', writeSet);
var writeAget = exports.writeAget = function writeAget(form) {
        return {
            'type': 'MemberExpression',
            'computed': (form || 0)['computed'],
            'object': write((form || 0)['target']),
            'property': write((form || 0)['property'])
        };
    };
installWriter('member-expression', writeAget);
var __statements__ = exports.__statements__ = {
        'EmptyStatement': true,
        'BlockStatement': true,
        'ExpressionStatement': true,
        'IfStatement': true,
        'LabeledStatement': true,
        'BreakStatement': true,
        'ContinueStatement': true,
        'SwitchStatement': true,
        'ReturnStatement': true,
        'ThrowStatement': true,
        'TryStatement': true,
        'WhileStatement': true,
        'DoWhileStatement': true,
        'ForStatement': true,
        'ForInStatement': true,
        'ForOfStatement': true,
        'LetStatement': true,
        'VariableDeclaration': true,
        'FunctionDeclaration': true
    };
var writeStatement = exports.writeStatement = function writeStatement(form) {
        return toStatement(write(form));
    };
var toStatement = exports.toStatement = function toStatement(node) {
        return (__statements__ || 0)[(node || 0)['type']] ? node : {
            'type': 'ExpressionStatement',
            'expression': node,
            'loc': (node || 0)['loc']
        };
    };
var toReturn = exports.toReturn = function toReturn(form) {
        return conj({
            'type': 'ReturnStatement',
            'argument': write(form)
        }, writeLocation((form || 0)['form'], (form || 0)['original-form']));
    };
var writeBody = exports.writeBody = function writeBody(form) {
        return function () {
            var statementsø1 = map(writeStatement, (form || 0)['statements'] || []);
            var resultø1 = (form || 0)['result'] ? toReturn((form || 0)['result']) : void 0;
            return resultø1 ? conj(statementsø1, resultø1) : statementsø1;
        }.call(this);
    };
var toBlock = exports.toBlock = function toBlock(body) {
        return isVector(body) ? {
            'type': 'BlockStatement',
            'body': body,
            'loc': inheritLocation(body)
        } : {
            'type': 'BlockStatement',
            'body': [body],
            'loc': (body || 0)['loc']
        };
    };
var toExpression = exports.toExpression = function toExpression() {
        var body = Array.prototype.slice.call(arguments, 0);
        return {
            'type': 'CallExpression',
            'arguments': [],
            'loc': inheritLocation(body),
            'callee': toSequence([{
                    'type': 'FunctionExpression',
                    'id': void 0,
                    'params': [],
                    'defaults': [],
                    'expression': false,
                    'generator': false,
                    'rest': void 0,
                    'body': toBlock(body)
                }])
        };
    };
var writeDo = exports.writeDo = function writeDo(form) {
        return (meta(first((form || 0)['form'])) || 0)['block'] ? toBlock(writeBody(conj(form, {
            'result': void 0,
            'statements': conj((form || 0)['statements'], (form || 0)['result'])
        }))) : toExpression.apply(void 0, writeBody(form));
    };
installWriter('do', writeDo);
var writeIf = exports.writeIf = function writeIf(form) {
        return {
            'type': 'ConditionalExpression',
            'test': write((form || 0)['test']),
            'consequent': write((form || 0)['consequent']),
            'alternate': write((form || 0)['alternate'])
        };
    };
installWriter('if', writeIf);
var writeTry = exports.writeTry = function writeTry(form) {
        return function () {
            var handlerø1 = (form || 0)['handler'];
            var finalizerø1 = (form || 0)['finalizer'];
            return toExpression(conj({
                'type': 'TryStatement',
                'guardedHandlers': [],
                'block': toBlock(writeBody((form || 0)['body'])),
                'handlers': handlerø1 ? [{
                        'type': 'CatchClause',
                        'param': write((handlerø1 || 0)['name']),
                        'body': toBlock(writeBody(handlerø1))
                    }] : [],
                'finalizer': finalizerø1 ? toBlock(writeBody(finalizerø1)) : !handlerø1 ? toBlock([]) : 'else' ? void 0 : void 0
            }, writeLocation((form || 0)['form'], (form || 0)['original-form'])));
        }.call(this);
    };
installWriter('try', writeTry);
var writeBindingValue = function writeBindingValue(form) {
    return write((form || 0)['init']);
};
var writeBindingParam = function writeBindingParam(form) {
    return writeVar({ 'form': (form || 0)['name'] });
};
var writeBinding = exports.writeBinding = function writeBinding(form) {
        return write({
            'op': 'def',
            'var': form,
            'init': (form || 0)['init'],
            'form': form
        });
    };
var writeLet = exports.writeLet = function writeLet(form) {
        return function () {
            var bodyø1 = conj(form, { 'statements': vec(concat((form || 0)['bindings'], (form || 0)['statements'])) });
            return toIife(toBlock(writeBody(bodyø1)));
        }.call(this);
    };
installWriter('let', writeLet);
var toRebind = exports.toRebind = function toRebind(form) {
        return function loop() {
            var recur = loop;
            var resultø1 = [];
            var bindingsø1 = (form || 0)['bindings'];
            do {
                recur = isEmpty(bindingsø1) ? resultø1 : (loop[0] = conj(resultø1, {
                    'type': 'AssignmentExpression',
                    'operator': '=',
                    'left': writeBindingVar(first(bindingsø1)),
                    'right': {
                        'type': 'MemberExpression',
                        'computed': true,
                        'object': {
                            'type': 'Identifier',
                            'name': 'loop'
                        },
                        'property': {
                            'type': 'Literal',
                            'value': count(resultø1)
                        }
                    }
                }), loop[1] = rest(bindingsø1), loop);
            } while (resultø1 = loop[0], bindingsø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var toSequence = exports.toSequence = function toSequence(expressions) {
        return {
            'type': 'SequenceExpression',
            'expressions': expressions
        };
    };
var toIife = exports.toIife = function toIife(body, id) {
        return {
            'type': 'CallExpression',
            'arguments': [{ 'type': 'ThisExpression' }],
            'callee': {
                'type': 'MemberExpression',
                'computed': false,
                'object': {
                    'type': 'FunctionExpression',
                    'id': id,
                    'params': [],
                    'defaults': [],
                    'expression': false,
                    'generator': false,
                    'rest': void 0,
                    'body': body
                },
                'property': {
                    'type': 'Identifier',
                    'name': 'call'
                }
            }
        };
    };
var toLoopInit = exports.toLoopInit = function toLoopInit() {
        return {
            'type': 'VariableDeclaration',
            'kind': 'var',
            'declarations': [{
                    'type': 'VariableDeclarator',
                    'id': {
                        'type': 'Identifier',
                        'name': 'recur'
                    },
                    'init': {
                        'type': 'Identifier',
                        'name': 'loop'
                    }
                }]
        };
    };
var toDoWhile = exports.toDoWhile = function toDoWhile(body, test) {
        return {
            'type': 'DoWhileStatement',
            'body': body,
            'test': test
        };
    };
var toSetRecur = exports.toSetRecur = function toSetRecur(form) {
        return {
            'type': 'AssignmentExpression',
            'operator': '=',
            'left': {
                'type': 'Identifier',
                'name': 'recur'
            },
            'right': write(form)
        };
    };
var toLoop = exports.toLoop = function toLoop(form) {
        return toSequence(conj(toRebind(form), {
            'type': 'BinaryExpression',
            'operator': '===',
            'left': {
                'type': 'Identifier',
                'name': 'recur'
            },
            'right': {
                'type': 'Identifier',
                'name': 'loop'
            }
        }));
    };
var writeLoop = exports.writeLoop = function writeLoop(form) {
        return function () {
            var statementsø1 = (form || 0)['statements'];
            var resultø1 = (form || 0)['result'];
            var bindingsø1 = (form || 0)['bindings'];
            var loopBodyø1 = conj(map(writeStatement, statementsø1), toStatement(toSetRecur(resultø1)));
            var bodyø1 = concat([toLoopInit()], map(write, bindingsø1), [toDoWhile(toBlock(vec(loopBodyø1)), toLoop(form))], [{
                        'type': 'ReturnStatement',
                        'argument': {
                            'type': 'Identifier',
                            'name': 'recur'
                        }
                    }]);
            return toIife(toBlock(vec(bodyø1)), symbol(void 0, 'loop'));
        }.call(this);
    };
installWriter('loop', writeLoop);
var toRecur = exports.toRecur = function toRecur(form) {
        return function loop() {
            var recur = loop;
            var resultø1 = [];
            var paramsø1 = (form || 0)['params'];
            do {
                recur = isEmpty(paramsø1) ? resultø1 : (loop[0] = conj(resultø1, {
                    'type': 'AssignmentExpression',
                    'operator': '=',
                    'right': write(first(paramsø1)),
                    'left': {
                        'type': 'MemberExpression',
                        'computed': true,
                        'object': {
                            'type': 'Identifier',
                            'name': 'loop'
                        },
                        'property': {
                            'type': 'Literal',
                            'value': count(resultø1)
                        }
                    }
                }), loop[1] = rest(paramsø1), loop);
            } while (resultø1 = loop[0], paramsø1 = loop[1], recur === loop);
            return recur;
        }.call(this);
    };
var writeRecur = exports.writeRecur = function writeRecur(form) {
        return toSequence(conj(toRecur(form), {
            'type': 'Identifier',
            'name': 'loop'
        }));
    };
installWriter('recur', writeRecur);
var fallbackOverload = exports.fallbackOverload = function fallbackOverload() {
        return {
            'type': 'SwitchCase',
            'test': void 0,
            'consequent': [{
                    'type': 'ThrowStatement',
                    'argument': {
                        'type': 'CallExpression',
                        'callee': {
                            'type': 'Identifier',
                            'name': 'RangeError'
                        },
                        'arguments': [{
                                'type': 'Literal',
                                'value': 'Wrong number of arguments passed'
                            }]
                    }
                }]
        };
    };
var spliceBinding = exports.spliceBinding = function spliceBinding(form) {
        return {
            'op': 'def',
            'id': last((form || 0)['params']),
            'init': {
                'op': 'invoke',
                'callee': {
                    'op': 'var',
                    'form': symbol(void 0, 'Array.prototype.slice.call')
                },
                'params': [
                    {
                        'op': 'var',
                        'form': symbol(void 0, 'arguments')
                    },
                    {
                        'op': 'constant',
                        'form': (form || 0)['arity'],
                        'type': 'number'
                    }
                ]
            }
        };
    };
var writeOverloadingParams = exports.writeOverloadingParams = function writeOverloadingParams(params) {
        return reduce(function (forms, param) {
            return conj(forms, {
                'op': 'def',
                'id': param,
                'init': {
                    'op': 'member-expression',
                    'computed': true,
                    'target': {
                        'op': 'var',
                        'form': symbol(void 0, 'arguments')
                    },
                    'property': {
                        'op': 'constant',
                        'type': 'number',
                        'form': count(forms)
                    }
                }
            });
        }, [], params);
    };
var writeOverloadingFn = exports.writeOverloadingFn = function writeOverloadingFn(form) {
        return function () {
            var overloadsø1 = map(writeFnOverload, (form || 0)['methods']);
            return {
                'params': [],
                'body': toBlock({
                    'type': 'SwitchStatement',
                    'discriminant': {
                        'type': 'MemberExpression',
                        'computed': false,
                        'object': {
                            'type': 'Identifier',
                            'name': 'arguments'
                        },
                        'property': {
                            'type': 'Identifier',
                            'name': 'length'
                        }
                    },
                    'cases': (form || 0)['variadic'] ? overloadsø1 : conj(overloadsø1, fallbackOverload())
                })
            };
        }.call(this);
    };
var writeFnOverload = exports.writeFnOverload = function writeFnOverload(form) {
        return function () {
            var paramsø1 = (form || 0)['params'];
            var bindingsø1 = (form || 0)['variadic'] ? conj(writeOverloadingParams(butlast(paramsø1)), spliceBinding(form)) : writeOverloadingParams(paramsø1);
            var statementsø1 = vec(concat(bindingsø1, (form || 0)['statements']));
            return {
                'type': 'SwitchCase',
                'test': !(form || 0)['variadic'] ? {
                    'type': 'Literal',
                    'value': (form || 0)['arity']
                } : void 0,
                'consequent': writeBody(conj(form, { 'statements': statementsø1 }))
            };
        }.call(this);
    };
var writeSimpleFn = exports.writeSimpleFn = function writeSimpleFn(form) {
        return function () {
            var methodø1 = first((form || 0)['methods']);
            var paramsø1 = (methodø1 || 0)['variadic'] ? butlast((methodø1 || 0)['params']) : (methodø1 || 0)['params'];
            var bodyø1 = (methodø1 || 0)['variadic'] ? conj(methodø1, { 'statements': vec(cons(spliceBinding(methodø1), (methodø1 || 0)['statements'])) }) : methodø1;
            return {
                'params': map(writeVar, paramsø1),
                'body': toBlock(writeBody(bodyø1))
            };
        }.call(this);
    };
var resolve = exports.resolve = function resolve(from, to) {
        return function () {
            var requirerø1 = split(name(from), '.');
            var requirementø1 = split(name(to), '.');
            var isRelativeø1 = !(name(from) === name(to)) && first(requirerø1) === first(requirementø1);
            return isRelativeø1 ? function loop() {
                var recur = loop;
                var fromø2 = requirerø1;
                var toø2 = requirementø1;
                do {
                    recur = first(fromø2) === first(toø2) ? (loop[0] = rest(fromø2), loop[1] = rest(toø2), loop) : join('/', concat(['.'], repeat(dec(count(fromø2)), '..'), toø2));
                } while (fromø2 = loop[0], toø2 = loop[1], recur === loop);
                return recur;
            }.call(this) : join('/', requirementø1);
        }.call(this);
    };
var idToNs = exports.idToNs = function idToNs(id) {
        return symbol(void 0, join('*', split(name(id), '.')));
    };
var writeRequire = exports.writeRequire = function writeRequire(form, requirer) {
        return function () {
            var nsBindingø1 = {
                    'op': 'def',
                    'id': {
                        'op': 'var',
                        'type': 'identifier',
                        'form': idToNs((form || 0)['ns'])
                    },
                    'init': {
                        'op': 'invoke',
                        'callee': {
                            'op': 'var',
                            'type': 'identifier',
                            'form': symbol(void 0, 'require')
                        },
                        'params': [{
                                'op': 'constant',
                                'form': resolve(requirer, (form || 0)['ns'])
                            }]
                    }
                };
            var nsAliasø1 = (form || 0)['alias'] ? {
                    'op': 'def',
                    'id': {
                        'op': 'var',
                        'type': 'identifier',
                        'form': idToNs((form || 0)['alias'])
                    },
                    'init': (nsBindingø1 || 0)['id']
                } : void 0;
            var referencesø1 = reduce(function (references, form) {
                    return conj(references, {
                        'op': 'def',
                        'id': {
                            'op': 'var',
                            'type': 'identifier',
                            'form': (form || 0)['rename'] || (form || 0)['name']
                        },
                        'init': {
                            'op': 'member-expression',
                            'computed': false,
                            'target': (nsBindingø1 || 0)['id'],
                            'property': {
                                'op': 'var',
                                'type': 'identifier',
                                'form': (form || 0)['name']
                            }
                        }
                    });
                }, [], (form || 0)['refer']);
            return vec(cons(nsBindingø1, nsAliasø1 ? cons(nsAliasø1, referencesø1) : referencesø1));
        }.call(this);
    };
var writeNs = exports.writeNs = function writeNs(form) {
        return function () {
            var nodeø1 = (form || 0)['form'];
            var requirerø1 = (form || 0)['name'];
            var nsBindingø1 = {
                    'op': 'def',
                    'original-form': nodeø1,
                    'id': {
                        'op': 'var',
                        'type': 'identifier',
                        'original-form': first(nodeø1),
                        'form': symbol(void 0, '*ns*')
                    },
                    'init': {
                        'op': 'dictionary',
                        'form': nodeø1,
                        'keys': [
                            {
                                'op': 'var',
                                'type': 'identifier',
                                'original-form': nodeø1,
                                'form': symbol(void 0, 'id')
                            },
                            {
                                'op': 'var',
                                'type': 'identifier',
                                'original-form': nodeø1,
                                'form': symbol(void 0, 'doc')
                            }
                        ],
                        'values': [
                            {
                                'op': 'constant',
                                'type': 'identifier',
                                'original-form': (form || 0)['name'],
                                'form': name((form || 0)['name'])
                            },
                            {
                                'op': 'constant',
                                'original-form': nodeø1,
                                'form': (form || 0)['doc']
                            }
                        ]
                    }
                };
            var requirementsø1 = vec(concat.apply(void 0, map(function ($1) {
                    return writeRequire($1, requirerø1);
                }, (form || 0)['require'])));
            return toBlock(map(write, vec(cons(nsBindingø1, requirementsø1))));
        }.call(this);
    };
installWriter('ns', writeNs);
var writeFn = exports.writeFn = function writeFn(form) {
        return function () {
            var baseø1 = count((form || 0)['methods']) > 1 ? writeOverloadingFn(form) : writeSimpleFn(form);
            return conj(baseø1, {
                'type': 'FunctionExpression',
                'id': (form || 0)['id'] ? writeVar((form || 0)['id']) : void 0,
                'defaults': void 0,
                'rest': void 0,
                'generator': false,
                'expression': false
            });
        }.call(this);
    };
installWriter('fn', writeFn);
var write = exports.write = function write(form) {
        return function () {
            var opø1 = (form || 0)['op'];
            var writerø1 = isEqual('invoke', (form || 0)['op']) && isEqual('var', ((form || 0)['callee'] || 0)['op']) && (__specials__ || 0)[name(((form || 0)['callee'] || 0)['form'])];
            return writerø1 ? writeSpecial(writerø1, form) : writeOp((form || 0)['op'], form);
        }.call(this);
    };
var write_ = exports.write_ = function write_() {
        var forms = Array.prototype.slice.call(arguments, 0);
        return function () {
            var bodyø1 = map(writeStatement, forms);
            return {
                'type': 'Program',
                'body': bodyø1,
                'loc': inheritLocation(bodyø1)
            };
        }.call(this);
    };
var compile = exports.compile = function compile() {
        switch (arguments.length) {
        case 1:
            var form = arguments[0];
            return compile({}, form);
        default:
            var options = arguments[0];
            var forms = Array.prototype.slice.call(arguments, 1);
            return generate(write_.apply(void 0, forms), options);
        }
    };
var getMacro = exports.getMacro = function getMacro(target, property) {
        return list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, 'or')].concat([target], [0]))], [property]));
    };
installMacro('get', getMacro);
var installLogicalOperator = exports.installLogicalOperator = function installLogicalOperator(callee, operator, fallback) {
        var writeLogicalOperator = function writeLogicalOperator() {
            var operands = Array.prototype.slice.call(arguments, 0);
            return function () {
                var nø1 = count(operands);
                return isEqual(nø1, 0) ? writeConstant(fallback) : isEqual(nø1, 1) ? write(first(operands)) : 'else' ? reduce(function (left, right) {
                    return {
                        'type': 'LogicalExpression',
                        'operator': operator,
                        'left': left,
                        'right': write(right)
                    };
                }, write(first(operands)), rest(operands)) : void 0;
            }.call(this);
        };
        return installSpecial(callee, writeLogicalOperator);
    };
installLogicalOperator('or', '||', void 0);
installLogicalOperator('and', '&&', true);
var installUnaryOperator = exports.installUnaryOperator = function installUnaryOperator(callee, operator, isPrefix) {
        var writeUnaryOperator = function writeUnaryOperator() {
            var params = Array.prototype.slice.call(arguments, 0);
            return count(params) === 1 ? {
                'type': 'UnaryExpression',
                'operator': operator,
                'argument': write(first(params)),
                'prefix': isPrefix
            } : errorArgCount(callee, count(params));
        };
        return installSpecial(callee, writeUnaryOperator);
    };
installUnaryOperator('not', '!');
installUnaryOperator('bit-not', '~');
var installBinaryOperator = exports.installBinaryOperator = function installBinaryOperator(callee, operator) {
        var writeBinaryOperator = function writeBinaryOperator() {
            var params = Array.prototype.slice.call(arguments, 0);
            return count(params) < 2 ? errorArgCount(callee, count(params)) : reduce(function (left, right) {
                return {
                    'type': 'BinaryExpression',
                    'operator': operator,
                    'left': left,
                    'right': write(right)
                };
            }, write(first(params)), rest(params));
        };
        return installSpecial(callee, writeBinaryOperator);
    };
installBinaryOperator('bit-and', '&');
installBinaryOperator('bit-or', '|');
installBinaryOperator('bit-xor', '^');
installBinaryOperator('bit-shift-left', '<<');
installBinaryOperator('bit-shift-right', '>>');
installBinaryOperator('bit-shift-right-zero-fil', '>>>');
var installArithmeticOperator = exports.installArithmeticOperator = function installArithmeticOperator(callee, operator, isValid, fallback) {
        var writeBinaryOperator = function writeBinaryOperator(left, right) {
            return {
                'type': 'BinaryExpression',
                'operator': name(operator),
                'left': left,
                'right': write(right)
            };
        };
        var writeArithmeticOperator = function writeArithmeticOperator() {
            var params = Array.prototype.slice.call(arguments, 0);
            return function () {
                var nø1 = count(params);
                return isValid && !isValid(nø1) ? errorArgCount(name(callee), nø1) : nø1 == 0 ? writeLiteral(fallback) : nø1 == 1 ? reduce(writeBinaryOperator, writeLiteral(fallback), params) : 'else' ? reduce(writeBinaryOperator, write(first(params)), rest(params)) : void 0;
            }.call(this);
        };
        return installSpecial(callee, writeArithmeticOperator);
    };
installArithmeticOperator('+', '+', void 0, 0);
installArithmeticOperator('-', '-', function ($1) {
    return $1 >= 1;
}, 0);
installArithmeticOperator('*', '*', void 0, 1);
installArithmeticOperator(keyword('/'), keyword('/'), function ($1) {
    return $1 >= 1;
}, 1);
installArithmeticOperator('mod', keyword('%'), function ($1) {
    return $1 == 2;
}, 1);
var installComparisonOperator = exports.installComparisonOperator = function installComparisonOperator(callee, operator, fallback) {
        var writeComparisonOperator = function writeComparisonOperator() {
            switch (arguments.length) {
            case 0:
                return errorArgCount(callee, 0);
            case 1:
                var form = arguments[0];
                return toSequence([
                    write(form),
                    writeLiteral(fallback)
                ]);
            case 2:
                var left = arguments[0];
                var right = arguments[1];
                return {
                    'type': 'BinaryExpression',
                    'operator': operator,
                    'left': write(left),
                    'right': write(right)
                };
            default:
                var left = arguments[0];
                var right = arguments[1];
                var more = Array.prototype.slice.call(arguments, 2);
                return reduce(function (left, right) {
                    return {
                        'type': 'LogicalExpression',
                        'operator': '&&',
                        'left': left,
                        'right': {
                            'type': 'BinaryExpression',
                            'operator': operator,
                            'left': isEqual('LogicalExpression', (left || 0)['type']) ? ((left || 0)['right'] || 0)['right'] : (left || 0)['right'],
                            'right': write(right)
                        }
                    };
                }, writeComparisonOperator(left, right), more);
            }
        };
        return installSpecial(callee, writeComparisonOperator);
    };
installComparisonOperator('==', '==', true);
installComparisonOperator('>', '>', true);
installComparisonOperator('>=', '>=', true);
installComparisonOperator('<', '<', true);
installComparisonOperator('<=', '<=', true);
var isWriteIdentical = exports.isWriteIdentical = function isWriteIdentical() {
        var params = Array.prototype.slice.call(arguments, 0);
        return count(params) === 2 ? {
            'type': 'BinaryExpression',
            'operator': '===',
            'left': write(first(params)),
            'right': write(second(params))
        } : errorArgCount('identical?', count(params));
    };
installSpecial('identical?', isWriteIdentical);
var isWriteInstance = exports.isWriteInstance = function isWriteInstance() {
        var params = Array.prototype.slice.call(arguments, 0);
        return function () {
            var constructorø1 = first(params);
            var instanceø1 = second(params);
            return count(params) < 1 ? errorArgCount('instance?', count(params)) : {
                'type': 'BinaryExpression',
                'operator': 'instanceof',
                'left': instanceø1 ? write(instanceø1) : writeConstant(instanceø1),
                'right': write(constructorø1)
            };
        }.call(this);
    };
installSpecial('instance?', isWriteInstance);
var expandApply = exports.expandApply = function expandApply(f) {
        var params = Array.prototype.slice.call(arguments, 1);
        return function () {
            var prefixø1 = vec(butlast(params));
            return isEmpty(prefixø1) ? list.apply(void 0, [symbol(void 0, '.apply')].concat([f], [void 0], vec(params))) : list.apply(void 0, [symbol(void 0, '.apply')].concat([f], [void 0], [list.apply(void 0, [symbol(void 0, '.concat')].concat([prefixø1], [last(params)]))]));
        }.call(this);
    };
installMacro('apply', expandApply);
var expandPrint = exports.expandPrint = function expandPrint(_andForm) {
        var more = Array.prototype.slice.call(arguments, 1);
        'Prints the object(s) to the output for human consumption.';
        return function () {
            var opø1 = withMeta(symbol(void 0, 'console.log'), meta(_andForm));
            return list.apply(void 0, [opø1].concat(vec(more)));
        }.call(this);
    };
installMacro('print', withMeta(expandPrint, { 'implicit': ['&form'] }));
var expandStr = exports.expandStr = function expandStr() {
        var forms = Array.prototype.slice.call(arguments, 0);
        return list.apply(void 0, [symbol(void 0, '+')].concat([''], vec(forms)));
    };
installMacro('str', expandStr);
var expandDebug = exports.expandDebug = function expandDebug() {
        return symbol(void 0, 'debugger');
    };
installMacro('debugger!', expandDebug);
var expandAssert = exports.expandAssert = function expandAssert() {
        switch (arguments.length) {
        case 1:
            var x = arguments[0];
            return expandAssert(x, '');
        case 2:
            var x = arguments[0];
            var message = arguments[1];
            return function () {
                var formø1 = prStr(x);
                return list.apply(void 0, [symbol(void 0, 'if')].concat([list.apply(void 0, [symbol(void 0, 'not')].concat([x]))], [list.apply(void 0, [symbol(void 0, 'throw')].concat([list.apply(void 0, [symbol(void 0, 'Error')].concat([list.apply(void 0, [symbol(void 0, 'str')].concat(['Assert failed: '], [message], [formø1]))]))]))]));
            }.call(this);
        default:
            throw RangeError('Wrong number of arguments passed');
        }
    };
installMacro('assert', expandAssert);
var expandDefprotocol = exports.expandDefprotocol = function expandDefprotocol(_andEnv, id) {
        var forms = Array.prototype.slice.call(arguments, 2);
        return function () {
            var nsø1 = name(((_andEnv || 0)['ns'] || 0)['name']);
            var protocolNameø1 = name(id);
            var protocolDocø1 = isString(first(forms)) ? first(forms) : void 0;
            var protocolMethodsø1 = protocolDocø1 ? rest(forms) : forms;
            var protocolø1 = reduce(function (protocol, method) {
                    return function () {
                        var methodNameø1 = first(method);
                        var idø2 = idToNs('' + nsø1 + '$' + protocolNameø1 + '$' + name(methodNameø1));
                        return conj(protocol, {
                            'id': methodNameø1,
                            'fn': list.apply(void 0, [symbol(void 0, 'fn')].concat([idø2], [[symbol(void 0, 'self')].concat()], [list.apply(void 0, [symbol(void 0, 'def')].concat([symbol(void 0, 'f')], [list.apply(void 0, [symbol(void 0, 'cond')].concat([list.apply(void 0, [symbol(void 0, 'identical?')].concat([symbol(void 0, 'self')], [symbol(void 0, 'null')]))], [list.apply(void 0, [symbol(void 0, '.-nil')].concat([idø2]))], [list.apply(void 0, [symbol(void 0, 'identical?')].concat([symbol(void 0, 'self')], [void 0]))], [list.apply(void 0, [symbol(void 0, '.-nil')].concat([idø2]))], ['\uA789else'], [list.apply(void 0, [symbol(void 0, 'or')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([symbol(void 0, 'self')], [list.apply(void 0, [symbol(void 0, 'quote')].concat([idø2]))]))], [list.apply(void 0, [symbol(void 0, 'aget')].concat([idø2], [list.apply(void 0, [symbol(void 0, '.replace')].concat([list.apply(void 0, [symbol(void 0, '.replace')].concat([list.apply(void 0, [symbol(void 0, '.call')].concat([symbol(void 0, 'Object.prototype.toString')], [symbol(void 0, 'self')]))], ['[object '], ['']))], [/\]$/], ['']))]))], [list.apply(void 0, [symbol(void 0, '.-_')].concat([idø2]))]))]))]))], [list.apply(void 0, [symbol(void 0, '.apply')].concat([symbol(void 0, 'f')], [symbol(void 0, 'self')], [symbol(void 0, 'arguments')]))]))
                        });
                    }.call(this);
                }, [], protocolMethodsø1);
            var fnsø1 = map(function (form) {
                    return list.apply(void 0, [symbol(void 0, 'def')].concat([(form || 0)['id']], [list.apply(void 0, [symbol(void 0, 'aget')].concat([id], [list.apply(void 0, [symbol(void 0, 'quote')].concat([(form || 0)['id']]))]))]));
                }, protocolø1);
            var satisfyø1 = assoc({}, symbol(void 0, 'wisp_core$IProtocol$id'), '' + nsø1 + '/' + protocolNameø1);
            var bodyø1 = reduce(function (body, method) {
                    return assoc(body, (method || 0)['id'], (method || 0)['fn']);
                }, satisfyø1, protocolø1);
            return list.apply(void 0, [withMeta(symbol(void 0, 'do'), { 'block': true })].concat([list.apply(void 0, [symbol(void 0, 'def')].concat([id], [bodyø1]))], vec(fnsø1), [id]));
        }.call(this);
    };
installMacro('defprotocol', withMeta(expandDefprotocol, { 'implicit': ['&env'] }));
var expandDeftype = exports.expandDeftype = function expandDeftype(id, fields) {
        var forms = Array.prototype.slice.call(arguments, 2);
        return function () {
            var typeInitø1 = map(function (field) {
                    return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([symbol(void 0, 'this')], [list.apply(void 0, [symbol(void 0, 'quote')].concat([field]))]))], [field]));
                }, fields);
            var constructorø1 = conj(typeInitø1, symbol(void 0, 'this'));
            var methodInitø1 = map(function (field) {
                    return list.apply(void 0, [symbol(void 0, 'def')].concat([field], [list.apply(void 0, [symbol(void 0, 'aget')].concat([symbol(void 0, 'this')], [list.apply(void 0, [symbol(void 0, 'quote')].concat([field]))]))]));
                }, fields);
            var makeMethodø1 = function (protocol, form) {
                return function () {
                    var methodNameø1 = first(form);
                    var paramsø1 = second(form);
                    var bodyø1 = rest(rest(form));
                    var fieldNameø1 = isEqual(name(protocol), 'Object') ? list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1])) : list.apply(void 0, [symbol(void 0, '.-name')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1]))]))]));
                    return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([id]))], [fieldNameø1]))], [list.apply(void 0, [symbol(void 0, 'fn')].concat([paramsø1], vec(methodInitø1), vec(bodyø1)))]));
                }.call(this);
            };
            var satisfyø1 = function (protocol) {
                return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([id]))], [list.apply(void 0, [symbol(void 0, '.-wisp_core$IProtocol$id')].concat([protocol]))]))], [true]));
            };
            var bodyø1 = reduce(function (type, form) {
                    return isList(form) ? conj(type, { 'body': conj((type || 0)['body'], makeMethodø1((type || 0)['protocol'], form)) }) : conj(type, {
                        'protocol': form,
                        'body': conj((type || 0)['body'], satisfyø1(form))
                    });
                }, {
                    'protocol': void 0,
                    'body': []
                }, forms);
            var methodsø1 = (bodyø1 || 0)['body'];
            return list.apply(void 0, [symbol(void 0, 'def')].concat([id], [list.apply(void 0, [symbol(void 0, 'do')].concat([list.apply(void 0, [symbol(void 0, 'defn-')].concat([id], [fields], vec(constructorø1)))], vec(methodsø1), [id]))]));
        }.call(this);
    };
installMacro('deftype', expandDeftype);
installMacro('defrecord', expandDeftype);
var expandExtendType = exports.expandExtendType = function expandExtendType(type) {
        var forms = Array.prototype.slice.call(arguments, 1);
        return function () {
            var isDefaultTypeø1 = isEqual(type, symbol(void 0, 'default'));
            var isNilTypeø1 = isNil(type);
            var typeNameø1 = isNil(type) ? symbol('nil') : isEqual(type, symbol(void 0, 'default')) ? symbol(void 0, '_') : isEqual(type, symbol(void 0, 'number')) ? symbol(void 0, 'Number') : isEqual(type, symbol(void 0, 'string')) ? symbol(void 0, 'String') : isEqual(type, symbol(void 0, 'boolean')) ? symbol(void 0, 'Boolean') : isEqual(type, symbol(void 0, 'vector')) ? symbol(void 0, 'Array') : isEqual(type, symbol(void 0, 'function')) ? symbol(void 0, 'Function') : isEqual(type, symbol(void 0, 're-pattern')) ? symbol(void 0, 'RegExp') : isEqual(namespace(type), 'js') ? type : 'else' ? void 0 : void 0;
            var satisfyø1 = function (protocol) {
                return typeNameø1 ? list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([symbol('' + 'wisp_core$IProtocol$' + name(typeNameø1))]))]))], [true])) : list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([type]))], [list.apply(void 0, [symbol(void 0, '.-wisp_core$IProtocol$id')].concat([protocol]))]))], [true]));
            };
            var makeMethodø1 = function (protocol, form) {
                return function () {
                    var methodNameø1 = first(form);
                    var paramsø1 = second(form);
                    var bodyø1 = rest(rest(form));
                    var targetø1 = typeNameø1 ? list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1]))]))], [list.apply(void 0, [symbol(void 0, 'quote')].concat([typeNameø1]))])) : list.apply(void 0, [symbol(void 0, 'aget')].concat([list.apply(void 0, [symbol(void 0, '.-prototype')].concat([type]))], [list.apply(void 0, [symbol(void 0, '.-name')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([protocol], [list.apply(void 0, [symbol(void 0, 'quote')].concat([methodNameø1]))]))]))]));
                    return list.apply(void 0, [symbol(void 0, 'set!')].concat([targetø1], [list.apply(void 0, [symbol(void 0, 'fn')].concat([paramsø1], vec(bodyø1)))]));
                }.call(this);
            };
            var bodyø1 = reduce(function (body, form) {
                    return isList(form) ? conj(body, { 'methods': conj((body || 0)['methods'], makeMethodø1((body || 0)['protocol'], form)) }) : conj(body, {
                        'protocol': form,
                        'methods': conj((body || 0)['methods'], satisfyø1(form))
                    });
                }, {
                    'protocol': void 0,
                    'methods': []
                }, forms);
            var methodsø1 = (bodyø1 || 0)['methods'];
            return list.apply(void 0, [symbol(void 0, 'do')].concat(vec(methodsø1), [void 0]));
        }.call(this);
    };
installMacro('extend-type', expandExtendType);
var expandExtendProtocol = exports.expandExtendProtocol = function expandExtendProtocol(protocol) {
        var forms = Array.prototype.slice.call(arguments, 1);
        return function () {
            var specsø1 = reduce(function (specs, form) {
                    return isList(form) ? cons({
                        'type': (first(specs) || 0)['type'],
                        'methods': conj((first(specs) || 0)['methods'], form)
                    }, rest(specs)) : cons({
                        'type': form,
                        'methods': []
                    }, specs);
                }, void 0, forms);
            var bodyø1 = map(function (form) {
                    return list.apply(void 0, [symbol(void 0, 'extend-type')].concat([(form || 0)['type']], [protocol], vec((form || 0)['methods'])));
                }, specsø1);
            return list.apply(void 0, [symbol(void 0, 'do')].concat(vec(bodyø1), [void 0]));
        }.call(this);
    };
installMacro('extend-protocol', expandExtendProtocol);
var asetExpand = exports.asetExpand = function asetExpand() {
        switch (arguments.length) {
        case 3:
            var target = arguments[0];
            var field = arguments[1];
            var value = arguments[2];
            return list.apply(void 0, [symbol(void 0, 'set!')].concat([list.apply(void 0, [symbol(void 0, 'aget')].concat([target], [field]))], [value]));
        default:
            var target = arguments[0];
            var field = arguments[1];
            var subField = arguments[2];
            var subFieldsAndValue = Array.prototype.slice.call(arguments, 3);
            return function () {
                var resolvedTargetø1 = reduce(function (form, node) {
                        return list.apply(void 0, [symbol(void 0, 'aget')].concat([form], [node]));
                    }, list.apply(void 0, [symbol(void 0, 'aget')].concat([target], [field])), cons(subField, butlast(subFieldsAndValue)));
                var valueø1 = last(subFieldsAndValue);
                return list.apply(void 0, [symbol(void 0, 'set!')].concat([resolvedTargetø1], [valueø1]));
            }.call(this);
        }
    };
installMacro('aset', asetExpand);
var alengthExpand = exports.alengthExpand = function alengthExpand(array) {
        return list.apply(void 0, [symbol(void 0, '.-length')].concat([array]));
    };
installMacro('alength', alengthExpand);
//# sourceMappingURL=data:application/json;base64,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
