(ns leiningen.new.purefrege
    (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
      [leiningen.core.main :as main])
    (:import (java.util Calendar)))

(def render (renderer "purefrege"))

(defn purefrege
      "Create a Pure Frege project template."
      [name]
      (let [data {:name      name
                  :sanitized (name-to-path name)
                  :year      (.get (Calendar/getInstance) Calendar/YEAR)}]
           (main/info "Generating fresh 'lein new' purefrege project.")
           (->files data
                    ["README.md" (render "README.md" data)]
                    ["LICENSE" (render "LICENSE" data)]
                    ["project.clj" (render "project.clj" data)]
                    ["src/{{sanitized}}/Core.fr" (render "Core.fr" data)]
                    ["test/{{sanitized}}/CoreTest.fr" (render "CoreTest.fr" data)])))
