/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.ssl_utils;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class ExtensionsUtils {
    public static final String CRL_NUMBER_OID = Extension.cRLNumber.toString();
    public static final String AUTHORITY_KEY_IDENTIFIER_OID = Extension.authorityKeyIdentifier.toString();
    public static final String SUBJECT_ALTERNATIVE_NAME_OID = Extension.subjectAlternativeName.toString();
    public static final String DELTA_CRL_INDICATOR_OID = Extension.deltaCRLIndicator.toString();
    private static final Map<String, Integer> keyUsageFlags = new HashMap<String, Integer>(){
        {
            this.put("digital_signature", 128);
            this.put("non_repudiation", 64);
            this.put("key_encipherment", 32);
            this.put("data_encipherment", 16);
            this.put("key_agreement", 8);
            this.put("key_cert_sign", 4);
            this.put("crl_sign", 2);
            this.put("encipher_only", 1);
            this.put("decipher_only", 32768);
        }
    };
    private static final Map<Integer, String> generalNameTags = new HashMap<Integer, String>(){
        {
            this.put(0, "other_name");
            this.put(1, "rfc822_name");
            this.put(2, "dns_name");
            this.put(3, "x400_address");
            this.put(4, "directory_name");
            this.put(5, "edi_party_name");
            this.put(6, "uri");
            this.put(7, "ip");
            this.put(8, "registered_id");
        }
    };

    public static boolean isSubtreeOf(String string, String string2) {
        String[] stringArray;
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length >= (stringArray = string2.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static List<Map<String, Object>> getExtensionList(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(x509Certificate);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static List<Map<String, Object>> getExtensionList(X509CRL x509CRL) throws IOException, CRLException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCRL(x509CRL);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static List<Map<String, Object>> getExtensionList(PKCS10CertificationRequest pKCS10CertificationRequest) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(pKCS10CertificationRequest);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static Map<String, Object> getExtension(X509Certificate x509Certificate, String string) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(x509Certificate);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(X509CRL x509CRL, String string) throws IOException, CRLException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCRL(x509CRL);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(pKCS10CertificationRequest);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(List<Map<String, Object>> list, String string) {
        for (Map<String, Object> map : list) {
            if (!map.get("oid").equals(string)) continue;
            return map;
        }
        return null;
    }

    public static Object getExtensionValue(X509Certificate x509Certificate, String string) throws IOException, CertificateEncodingException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(x509Certificate, string));
    }

    public static Object getExtensionValue(X509CRL x509CRL, String string) throws IOException, CRLException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(x509CRL, string));
    }

    public static Object getExtensionValue(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(pKCS10CertificationRequest, string));
    }

    public static Object getExtensionValue(List<Map<String, Object>> list, String string) {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(list, string));
    }

    public static Object getExtensionValue(Map<String, Object> map) {
        if (map != null) {
            return map.get("value");
        }
        return null;
    }

    private static List<Map<String, Object>> getExtensionList(Extensions extensions) throws IOException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getCriticalExtensionOIDs()) {
            arrayList.add(ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, true));
        }
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getNonCriticalExtensionOIDs()) {
            arrayList.add(ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, false));
        }
        return arrayList;
    }

    private static Map<String, Object> makeExtensionMap(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        boolean bl = Arrays.asList(extensions.getCriticalExtensionOIDs()).contains(aSN1ObjectIdentifier);
        return ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, bl);
    }

    static Extensions getExtensionsFromCSR(PKCS10CertificationRequest pKCS10CertificationRequest) {
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = pKCS10CertificationRequest.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) {
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set == null) continue;
            ASN1Encodable aSN1Encodable = aSN1Set.getObjectAt(0);
            return Extensions.getInstance((Object)aSN1Encodable);
        }
        return null;
    }

    static Extensions getExtensionsObjFromMap(List<Map<String, Object>> list) throws IOException, OperatorCreationException {
        if (list != null && list.size() > 0) {
            ArrayList<Extension> arrayList = new ArrayList<Extension>();
            for (Map<String, Object> map : list) {
                arrayList.add(ExtensionsUtils.parseExtensionObject(map));
            }
            return new Extensions(arrayList.toArray(new Extension[arrayList.size()]));
        }
        return null;
    }

    static Extension parseExtensionObject(Map<String, Object> map) throws IOException, OperatorCreationException {
        String string = (String)map.get("oid");
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        Boolean bl = (Boolean)map.get("critical");
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.subjectAlternativeName) || aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.issuerAlternativeName)) {
            Map map2 = (Map)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToGeneralNames(map2)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)MiscObjectIdentifiers.netscapeCertComment)) {
            DERIA5String dERIA5String = new DERIA5String((String)map.get("value"));
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)dERIA5String));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.keyUsage)) {
            Set set = (Set)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.setToKeyUsage(set)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.extendedKeyUsage)) {
            List list = (List)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.listToExtendedKeyUsage(list)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.basicConstraints)) {
            Map map3 = (Map)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToBasicConstraints(map3)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.subjectKeyIdentifier)) {
            PublicKey publicKey = (PublicKey)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.publicKeyToSubjectKeyIdentifier(publicKey)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.authorityKeyIdentifier)) {
            Map map4 = (Map)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToAuthorityKeyIdentifier(map4)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.cRLNumber)) {
            BigInteger bigInteger = (BigInteger)map.get("value");
            return new Extension(aSN1ObjectIdentifier, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)new CRLNumber(bigInteger)));
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.deltaCRLIndicator)) {
            BigInteger bigInteger = (BigInteger)map.get("value");
            return new Extension(aSN1ObjectIdentifier, true, (ASN1OctetString)new DEROctetString((ASN1Encodable)new CRLNumber(bigInteger)));
        }
        String string2 = (String)map.get("value");
        return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)new DERUTF8String(string2)));
    }

    private static Extensions getExtensionsFromCert(X509Certificate x509Certificate) throws CertificateEncodingException, IOException {
        return new X509CertificateHolder(x509Certificate.getEncoded()).getExtensions();
    }

    private static Extensions getExtensionsFromCRL(X509CRL x509CRL) throws CRLException, IOException {
        return new X509CRLHolder(x509CRL.getEncoded()).getExtensions();
    }

    private static Map<String, Object> makeExtensionMap(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl) throws IOException {
        Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
        if (extension != null) {
            byte[] byArray = extension.getExtnValue().getOctets();
            ASN1Object aSN1Object = ExtensionsUtils.binaryToASN1Object(aSN1ObjectIdentifier, byArray);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("oid", aSN1ObjectIdentifier.getId());
            hashMap.put("critical", bl);
            hashMap.put("value", ExtensionsUtils.asn1ObjToObj((ASN1Encodable)aSN1Object));
            return hashMap;
        }
        return null;
    }

    private static ASN1Object binaryToASN1Object(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.subjectAlternativeName) || aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.issuerAlternativeName)) {
            return GeneralNames.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.authorityKeyIdentifier)) {
            return AuthorityKeyIdentifier.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.subjectKeyIdentifier)) {
            return SubjectKeyIdentifier.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.basicConstraints)) {
            return BasicConstraints.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.keyUsage)) {
            DERBitString dERBitString = (DERBitString)ASN1Primitive.fromByteArray((byte[])byArray);
            return KeyUsage.getInstance((Object)dERBitString);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.extendedKeyUsage)) {
            return ExtendedKeyUsage.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)MiscObjectIdentifiers.netscapeCertComment)) {
            try {
                return ASN1Primitive.fromByteArray((byte[])byArray);
            }
            catch (IOException iOException) {
                return new DERIA5String(new String(byArray, Charset.forName("US-ASCII")));
            }
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)Extension.cRLNumber)) {
            return CRLNumber.getInstance((Object)byArray);
        }
        try {
            return DERUTF8String.getInstance((Object)byArray);
        }
        catch (Exception exception) {
            return new DERUTF8String(new String(byArray, Charset.forName("US-ASCII")));
        }
    }

    private static Object asn1ObjToObj(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable instanceof GeneralNames) {
            return ExtensionsUtils.generalNamesToMap((GeneralNames)aSN1Encodable);
        }
        if (aSN1Encodable instanceof ASN1ObjectIdentifier) {
            return ((ASN1ObjectIdentifier)aSN1Encodable).getId();
        }
        if (aSN1Encodable instanceof AuthorityKeyIdentifier) {
            return ExtensionsUtils.authorityKeyIdToMap((AuthorityKeyIdentifier)aSN1Encodable);
        }
        if (aSN1Encodable instanceof BasicConstraints) {
            return ExtensionsUtils.basicConstraintsToMap((BasicConstraints)aSN1Encodable);
        }
        if (aSN1Encodable instanceof CRLNumber) {
            CRLNumber cRLNumber = (CRLNumber)aSN1Encodable;
            return cRLNumber.getCRLNumber();
        }
        if (aSN1Encodable instanceof SubjectKeyIdentifier) {
            SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)aSN1Encodable;
            return subjectKeyIdentifier.getKeyIdentifier();
        }
        if (aSN1Encodable instanceof ExtendedKeyUsage) {
            return ExtensionsUtils.extKeyUsageToList((ExtendedKeyUsage)aSN1Encodable);
        }
        if (aSN1Encodable instanceof KeyPurposeId) {
            KeyPurposeId keyPurposeId = (KeyPurposeId)aSN1Encodable;
            return keyPurposeId.getId();
        }
        if (aSN1Encodable instanceof KeyUsage) {
            KeyUsage keyUsage = (KeyUsage)aSN1Encodable;
            return ExtensionsUtils.keyUsageToSet(keyUsage);
        }
        if (aSN1Encodable instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)aSN1Encodable;
            return dERBitString.getString();
        }
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable;
            return ExtensionsUtils.asn1ObjToObj((ASN1Encodable)aSN1TaggedObject.getObject());
        }
        if (aSN1Encodable instanceof ASN1Sequence) {
            return ExtensionsUtils.asn1SeqToList((ASN1Sequence)aSN1Encodable);
        }
        if (aSN1Encodable instanceof ASN1String) {
            ASN1String aSN1String = (ASN1String)aSN1Encodable;
            return aSN1String.getString();
        }
        if (aSN1Encodable instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Encodable;
            return new String(aSN1OctetString.getOctets(), "UTF-8");
        }
        if (aSN1Encodable instanceof X500Name) {
            X500Name x500Name = (X500Name)aSN1Encodable;
            return x500Name.toString();
        }
        return aSN1Encodable.toASN1Primitive().getEncoded();
    }

    private static Set<String> keyUsageToSet(KeyUsage keyUsage) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : keyUsageFlags.keySet()) {
            if (!keyUsage.hasUsages(keyUsageFlags.get(string).intValue())) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static KeyUsage setToKeyUsage(Set<String> set) {
        int n = 0;
        for (String string : set) {
            Integer n2 = keyUsageFlags.get(string);
            if (n2 == null) {
                throw new IllegalArgumentException("The provided usage key does not exist: '" + string + "'");
            }
            n |= n2.intValue();
        }
        return new KeyUsage(n);
    }

    private static ExtendedKeyUsage listToExtendedKeyUsage(List<String> list) {
        ArrayList<KeyPurposeId> arrayList = new ArrayList<KeyPurposeId>();
        for (String string : list) {
            arrayList.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(string)));
        }
        return new ExtendedKeyUsage(arrayList.toArray(new KeyPurposeId[arrayList.size()]));
    }

    private static List<Object> extKeyUsageToList(ExtendedKeyUsage extendedKeyUsage) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (KeyPurposeId keyPurposeId : extendedKeyUsage.getUsages()) {
            arrayList.add(ExtensionsUtils.asn1ObjToObj((ASN1Encodable)keyPurposeId));
        }
        return arrayList;
    }

    private static Map<String, Object> basicConstraintsToMap(BasicConstraints basicConstraints) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("is_ca", basicConstraints.isCA());
        hashMap.put("path_len_constraint", basicConstraints.getPathLenConstraint());
        return hashMap;
    }

    private static BasicConstraints mapToBasicConstraints(Map<String, Object> map) {
        BasicConstraints basicConstraints;
        Boolean bl = (Boolean)map.get("is_ca");
        if (bl == null) {
            throw new IllegalArgumentException("The 'is_ca' key must be present in a basic constraint.");
        }
        Integer n = (Integer)map.get("path_len_constraint");
        if (n != null) {
            if (!bl.booleanValue()) {
                throw new IllegalArgumentException("The 'path_len_constraint' key is not supported for an 'is_ca' value of 'false'");
            }
            basicConstraints = new BasicConstraints(n.intValue());
        } else {
            basicConstraints = new BasicConstraints(bl.booleanValue());
        }
        return basicConstraints;
    }

    private static SubjectKeyIdentifier publicKeyToSubjectKeyIdentifier(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(digestCalculator);
        return x509ExtensionUtils.createSubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    private static AuthorityKeyIdentifier mapToAuthorityKeyIdentifier(Map<String, Object> map) throws OperatorCreationException {
        X509ExtensionUtils x509ExtensionUtils;
        String string;
        Object object;
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        PublicKey publicKey = (PublicKey)map.get("public_key");
        if (publicKey != null) {
            object = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            string = new JcaDigestCalculatorProviderBuilder().build().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
            x509ExtensionUtils = new X509ExtensionUtils((DigestCalculator)string);
            authorityKeyIdentifier = x509ExtensionUtils.createAuthorityKeyIdentifier(object);
        }
        object = (BigInteger)map.get("serial_number");
        if (publicKey == null && object == null) {
            throw new IllegalArgumentException("Neither 'public_key' nor 'serial_number' provided for auth key identifier.  At least one of these must be provided.");
        }
        string = (String)map.get("issuer_dn");
        if (string == null) {
            if (object != null) {
                throw new IllegalArgumentException("'issuer' not provided for auth key identifier but was expected since 'serial_number' was provided");
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("'serial_number' not provided for auth key identifierbut was expected since 'issuer' was provided");
            }
            x509ExtensionUtils = new GeneralNames(new GeneralName(new X500Name(string)));
            authorityKeyIdentifier = authorityKeyIdentifier != null ? new AuthorityKeyIdentifier(authorityKeyIdentifier.getKeyIdentifier(), (GeneralNames)x509ExtensionUtils, (BigInteger)object) : new AuthorityKeyIdentifier((GeneralNames)x509ExtensionUtils, (BigInteger)object);
        }
        return authorityKeyIdentifier;
    }

    private static Map<String, Object> authorityKeyIdToMap(AuthorityKeyIdentifier authorityKeyIdentifier) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("issuer", ExtensionsUtils.generalNamesToMap(authorityKeyIdentifier.getAuthorityCertIssuer()));
        hashMap.put("serial_number", authorityKeyIdentifier.getAuthorityCertSerialNumber());
        hashMap.put("key_identifier", authorityKeyIdentifier.getKeyIdentifier());
        return hashMap;
    }

    private static List<Object> asn1SeqToList(ASN1Sequence aSN1Sequence) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            arrayList.add(ExtensionsUtils.asn1ObjToObj(aSN1Sequence.getObjectAt(i)));
        }
        return arrayList;
    }

    private static Integer getGnTagFromName(String string) {
        for (int i = 0; i < generalNameTags.size(); ++i) {
            if (!generalNameTags.get(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return null;
    }

    public static String octetStringToIpString(ASN1OctetString aSN1OctetString) throws UnknownHostException {
        return InetAddress.getByAddress(aSN1OctetString.getOctets()).toString().split("/")[1];
    }

    private static Map<String, List<String>> generalNamesToMap(GeneralNames generalNames) throws IOException {
        if (generalNames != null) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (GeneralName generalName : generalNames.getNames()) {
                String string;
                String string2 = generalNameTags.get(generalName.getTagNo());
                if (hashMap.get(string2) == null) {
                    hashMap.put(string2, new ArrayList());
                }
                switch (generalName.getTagNo()) {
                    case 7: {
                        string = ExtensionsUtils.octetStringToIpString((ASN1OctetString)generalName.getName());
                        break;
                    }
                    default: {
                        string = ExtensionsUtils.asn1ObjToObj(generalName.getName()).toString();
                    }
                }
                ((List)hashMap.get(string2)).add(string);
            }
            return hashMap;
        }
        return null;
    }

    private static GeneralNames mapToGeneralNames(Map<String, List<String>> map) {
        ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
        for (String string : map.keySet()) {
            Integer n = ExtensionsUtils.getGnTagFromName(string);
            if (n == null) {
                throw new IllegalArgumentException("Could not find a tag number for the type name '" + string + '\"');
            }
            for (String string2 : map.get(string)) {
                arrayList.add(new GeneralName(n.intValue(), string2));
            }
        }
        return new GeneralNames(arrayList.toArray(new GeneralName[arrayList.size()]));
    }
}

