/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.etc;

import java.util.concurrent.atomic.AtomicBoolean;
import jnr.posix.Group;
import jnr.posix.POSIX;
import jnr.posix.Passwd;
import jnr.posix.util.Platform;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Etc"})
public class RubyEtc {
    private static final AtomicBoolean iteratingPasswd = new AtomicBoolean(false);

    public static RubyModule createEtcModule(Ruby runtime) {
        RubyModule etcModule = runtime.defineModule("Etc");
        runtime.setEtc(etcModule);
        etcModule.defineAnnotatedMethods(RubyEtc.class);
        RubyEtc.definePasswdStruct(runtime);
        RubyEtc.defineGroupStruct(runtime);
        return etcModule;
    }

    private static void definePasswdStruct(Ruby runtime) {
        IRubyObject[] args2 = new IRubyObject[]{runtime.newString("Passwd"), runtime.newSymbol("name"), runtime.newSymbol("passwd"), runtime.newSymbol("uid"), runtime.newSymbol("gid"), runtime.newSymbol("gecos"), runtime.newSymbol("dir"), runtime.newSymbol("shell"), runtime.newSymbol("change"), runtime.newSymbol("uclass"), runtime.newSymbol("expire")};
        runtime.setPasswdStruct(RubyStruct.newInstance(runtime.getStructClass(), args2, Block.NULL_BLOCK));
        if (runtime.is1_9()) {
            runtime.getEtc().defineConstant("Passwd", runtime.getPasswdStruct());
        }
    }

    private static void defineGroupStruct(Ruby runtime) {
        IRubyObject[] args2 = new IRubyObject[]{runtime.newString("Group"), runtime.newSymbol("name"), runtime.newSymbol("passwd"), runtime.newSymbol("gid"), runtime.newSymbol("mem")};
        runtime.setGroupStruct(RubyStruct.newInstance(runtime.getStructClass(), args2, Block.NULL_BLOCK));
        if (runtime.is1_9()) {
            runtime.getEtc().defineConstant("Group", runtime.getGroupStruct());
        }
    }

    private static IRubyObject setupPasswd(Ruby runtime, Passwd passwd2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime.newString(passwd2.getLoginName()), runtime.newString(passwd2.getPassword()), runtime.newFixnum(passwd2.getUID()), runtime.newFixnum(passwd2.getGID()), runtime.newString(passwd2.getGECOS()), runtime.newString(passwd2.getHome()), runtime.newString(passwd2.getShell()), runtime.newFixnum(passwd2.getPasswdChangeTime()), runtime.newString(passwd2.getAccessClass()), runtime.newFixnum(passwd2.getExpire())};
        return RubyStruct.newStruct(runtime.getPasswdStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject setupGroup(Ruby runtime, Group group2) {
        IRubyObject[] args2 = new IRubyObject[]{runtime.newString(group2.getName()), runtime.newString(group2.getPassword()), runtime.newFixnum(group2.getGID()), RubyEtc.intoStringArray(runtime, group2.getMembers())};
        return RubyStruct.newStruct(runtime.getGroupStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject intoStringArray(Ruby runtime, String[] members2) {
        IRubyObject[] arr = new IRubyObject[members2.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = runtime.newString(members2[i2]);
        }
        return runtime.newArrayNoCopy(arr);
    }

    @JRubyMethod(name={"getpwuid"}, optional=1, module=true)
    public static IRubyObject getpwuid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = recv2.getRuntime();
        POSIX posix = runtime.getPosix();
        try {
            int uid2 = args2.length == 0 ? posix.getuid() : RubyNumeric.fix2int(args2[0]);
            Passwd pwd = posix.getpwuid(uid2);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return recv2.getRuntime().getNil();
                }
                throw runtime.newArgumentError("can't find user for " + uid2);
            }
            return RubyEtc.setupPasswd(runtime, pwd);
        }
        catch (RaiseException re) {
            if (runtime.getNotImplementedError().isInstance(re.getException())) {
                return runtime.getNil();
            }
            throw re;
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwuid is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod(name={"getpwnam"}, required=1, module=true)
    public static IRubyObject getpwnam(IRubyObject recv2, IRubyObject name2) {
        Ruby runtime = recv2.getRuntime();
        String nam = name2.convertToString().toString();
        try {
            Passwd pwd = runtime.getPosix().getpwnam(nam);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime.getNil();
                }
                throw runtime.newArgumentError("can't find user for " + nam);
            }
            return RubyEtc.setupPasswd(recv2.getRuntime(), pwd);
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwnam is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject passwd(IRubyObject recv2, Block block) {
        Ruby runtime = recv2.getRuntime();
        POSIX posix = runtime.getPosix();
        try {
            Passwd pw;
            posix.getpwent();
            if (block.isGiven()) {
                ThreadContext context = runtime.getCurrentContext();
                if (!iteratingPasswd.compareAndSet(false, true)) {
                    throw runtime.newRuntimeError("parallel passwd iteration");
                }
                posix.setpwent();
                try {
                    Passwd pw2;
                    while ((pw2 = posix.getpwent()) != null) {
                        block.yield(context, RubyEtc.setupPasswd(runtime, pw2));
                    }
                }
                finally {
                    posix.endpwent();
                    iteratingPasswd.set(false);
                }
            }
            if ((pw = posix.getpwent()) != null) {
                return RubyEtc.setupPasswd(runtime, pw);
            }
            return runtime.getNil();
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.passwd is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod(name={"getlogin"}, module=true)
    public static IRubyObject getlogin(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        try {
            String login = runtime.getPosix().getlogin();
            if (login != null) {
                return runtime.newString(login);
            }
            login = System.getenv("USER");
            if (login != null) {
                return runtime.newString(login);
            }
            return runtime.getNil();
        }
        catch (Exception e) {
            return runtime.newString(System.getProperty("user.name"));
        }
    }

    @JRubyMethod(name={"endpwent"}, module=true)
    public static IRubyObject endpwent(IRubyObject recv2) {
        Ruby runtime;
        block2: {
            runtime = recv2.getRuntime();
            try {
                runtime.getPosix().endpwent();
            }
            catch (Exception e) {
                if (!runtime.getDebug().isTrue()) break block2;
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.endpwent is not supported by JRuby on this platform");
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"setpwent"}, module=true)
    public static IRubyObject setpwent(IRubyObject recv2) {
        Ruby runtime;
        block2: {
            runtime = recv2.getRuntime();
            try {
                runtime.getPosix().setpwent();
            }
            catch (Exception e) {
                if (!runtime.getDebug().isTrue()) break block2;
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.setpwent is not supported by JRuby on this platform");
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"getpwent"}, module=true)
    public static IRubyObject getpwent(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        try {
            Passwd passwd2 = runtime.getPosix().getpwent();
            if (passwd2 != null) {
                return RubyEtc.setupPasswd(runtime, passwd2);
            }
            return runtime.getNil();
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getpwent is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod(name={"getgrnam"}, required=1, module=true)
    public static IRubyObject getgrnam(IRubyObject recv2, IRubyObject name2) {
        Ruby runtime = recv2.getRuntime();
        String nam = name2.convertToString().toString();
        try {
            Group grp = runtime.getPosix().getgrnam(nam);
            if (grp == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime.getNil();
                }
                throw runtime.newArgumentError("can't find group for " + nam);
            }
            return RubyEtc.setupGroup(runtime, grp);
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrnam is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod(name={"getgrgid"}, optional=1, module=true)
    public static IRubyObject getgrgid(IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = recv2.getRuntime();
        POSIX posix = runtime.getPosix();
        try {
            int gid2 = args2.length == 0 ? posix.getgid() : RubyNumeric.fix2int(args2[0]);
            Group gr = posix.getgrgid(gid2);
            if (gr == null) {
                if (Platform.IS_WINDOWS) {
                    return runtime.getNil();
                }
                throw runtime.newArgumentError("can't find group for " + gid2);
            }
            return RubyEtc.setupGroup(runtime, gr);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrgid is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod(name={"endgrent"}, module=true)
    public static IRubyObject endgrent(IRubyObject recv2) {
        Ruby runtime;
        block2: {
            runtime = recv2.getRuntime();
            try {
                runtime.getPosix().endgrent();
            }
            catch (Exception e) {
                if (!runtime.getDebug().isTrue()) break block2;
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.engrent is not supported by JRuby on this platform");
            }
        }
        return runtime.getNil();
    }

    @JRubyMethod(module=true)
    public static IRubyObject setgrent(IRubyObject recv2) {
        Ruby runtime;
        block2: {
            runtime = recv2.getRuntime();
            try {
                runtime.getPosix().setgrent();
            }
            catch (Exception e) {
                if (!runtime.getDebug().isTrue()) break block2;
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.setgrent is not supported by JRuby on this platform");
            }
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject group(IRubyObject recv2, Block block) {
        POSIX posix;
        Ruby runtime;
        block10: {
            runtime = recv2.getRuntime();
            posix = runtime.getPosix();
            try {
                posix.getgrent();
            }
            catch (Exception e) {
                if (!runtime.getDebug().isTrue()) break block10;
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.group is not supported by JRuby on this platform");
            }
        }
        if (block.isGiven()) {
            Boolean blocking = (Boolean)recv2.getInternalVariables().getInternalVariable("group_blocking");
            if (blocking != null && blocking.booleanValue()) {
                throw runtime.newRuntimeError("parallel group iteration");
            }
            try {
                Group gr;
                recv2.getInternalVariables().setInternalVariable("group_blocking", true);
                ThreadContext context = runtime.getCurrentContext();
                posix.setgrent();
                while ((gr = posix.getgrent()) != null) {
                    block.yield(context, RubyEtc.setupGroup(runtime, gr));
                }
            }
            finally {
                posix.endgrent();
                recv2.getInternalVariables().setInternalVariable("group_blocking", false);
            }
        } else {
            Group gr = posix.getgrent();
            if (gr != null) {
                return RubyEtc.setupGroup(runtime, gr);
            }
            return runtime.getNil();
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getgrent"}, module=true)
    public static IRubyObject getgrent(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        try {
            Class<RubyEtc> clazz = RubyEtc.class;
            synchronized (RubyEtc.class) {
                Group gr = runtime.getPosix().getgrent();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (gr != null) {
                    return RubyEtc.setupGroup(recv2.getRuntime(), gr);
                }
                return runtime.getNil();
            }
        }
        catch (Exception e) {
            if (runtime.getDebug().isTrue()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.NOT_IMPLEMENTED, "Etc.getgrent is not supported by JRuby on this platform");
            }
            return runtime.getNil();
        }
    }

    @JRubyMethod(name={"systmpdir"}, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject systmpdir(ThreadContext context, IRubyObject recv2) {
        String commonAppData;
        Ruby runtime = context.getRuntime();
        ByteList tmp = ByteList.create((CharSequence)System.getProperty("java.io.tmpdir"));
        if (Platform.IS_WINDOWS && (commonAppData = System.getenv("CSIDL_COMMON_APPDATA")) != null) {
            tmp = ByteList.create((CharSequence)commonAppData);
        }
        RubyString ret = RubyString.newString(runtime, tmp, runtime.getDefaultExternalEncoding());
        ret.untaint(context);
        ret.trust(context);
        return ret;
    }

    @JRubyMethod(name={"sysconfdir"}, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject sysconfdir(ThreadContext context, IRubyObject recv2) {
        String localAppData;
        Ruby runtime = context.getRuntime();
        ByteList tmp = ByteList.create((CharSequence)RbConfigLibrary.getSysConfDir(runtime));
        if (Platform.IS_WINDOWS && (localAppData = System.getenv("CSIDL_LOCAL_APPDATA")) != null) {
            tmp = ByteList.create((CharSequence)localAppData);
        }
        RubyString ret = RubyString.newString(runtime, tmp, runtime.getDefaultExternalEncoding());
        ret.untaint(context);
        ret.trust(context);
        return ret;
    }
}

