/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.ClientOptions;
import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.ssl_utils.SSLUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    public static ClientOptions configureSsl(ClientOptions clientOptions) {
        if (clientOptions.getSslContext() != null) {
            return clientOptions;
        }
        if (clientOptions.getSslCert() != null && clientOptions.getSslKey() != null && clientOptions.getSslCaCert() != null) {
            try {
                clientOptions.setSslContext(SSLUtils.pemsToSSLContext((Reader)new FileReader(clientOptions.getSslCert()), (Reader)new FileReader(clientOptions.getSslKey()), (Reader)new FileReader(clientOptions.getSslCaCert())));
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException exception) {
                LOGGER.error("Error while configuring SSL", (Throwable)exception);
                throw new HttpClientException("Error while configuring SSL", exception);
            }
            clientOptions.setSslCert(null);
            clientOptions.setSslKey(null);
            clientOptions.setSslCaCert(null);
            return clientOptions;
        }
        if (clientOptions.getSslCaCert() != null) {
            try {
                clientOptions.setSslContext(SSLUtils.caCertPemToSSLContext((Reader)new FileReader(clientOptions.getSslCaCert())));
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException exception) {
                LOGGER.error("Error while configuring SSL", (Throwable)exception);
                throw new HttpClientException("Error while configuring SSL", exception);
            }
            clientOptions.setSslCaCert(null);
            return clientOptions;
        }
        return clientOptions;
    }
}

