/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.codahale.metrics.MetricRegistry;
import com.puppetlabs.http.client.AsyncHttpClient;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.JavaResponseDeliveryDelegate;
import com.puppetlabs.http.client.impl.Promise;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public class PersistentAsyncHttpClient
implements AsyncHttpClient {
    private CloseableHttpAsyncClient client;
    private MetricRegistry metricRegistry;
    private String metricNamespace;

    public PersistentAsyncHttpClient(CloseableHttpAsyncClient closeableHttpAsyncClient, MetricRegistry metricRegistry, String string) {
        this.client = closeableHttpAsyncClient;
        this.metricRegistry = metricRegistry;
        this.metricNamespace = string;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public String getMetricNamespace() {
        return this.metricNamespace;
    }

    private Promise<Response> request(RequestOptions requestOptions, HttpMethod httpMethod) {
        Promise<Response> promise = new Promise<Response>();
        JavaResponseDeliveryDelegate javaResponseDeliveryDelegate = new JavaResponseDeliveryDelegate(promise);
        JavaClient.requestWithClient(requestOptions, httpMethod, null, this.client, javaResponseDeliveryDelegate, this.metricRegistry, this.metricNamespace);
        return promise;
    }

    @Override
    public Promise<Response> get(String string) throws URISyntaxException {
        return this.get(new URI(string));
    }

    @Override
    public Promise<Response> get(URI uRI) {
        return this.get(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> get(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.GET);
    }

    @Override
    public Promise<Response> head(String string) throws URISyntaxException {
        return this.head(new URI(string));
    }

    @Override
    public Promise<Response> head(URI uRI) {
        return this.head(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> head(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.HEAD);
    }

    @Override
    public Promise<Response> post(String string) throws URISyntaxException {
        return this.post(new URI(string));
    }

    @Override
    public Promise<Response> post(URI uRI) {
        return this.post(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> post(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.POST);
    }

    @Override
    public Promise<Response> put(String string) throws URISyntaxException {
        return this.put(new URI(string));
    }

    @Override
    public Promise<Response> put(URI uRI) {
        return this.put(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> put(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.PUT);
    }

    @Override
    public Promise<Response> delete(String string) throws URISyntaxException {
        return this.delete(new URI(string));
    }

    @Override
    public Promise<Response> delete(URI uRI) {
        return this.delete(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> delete(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.DELETE);
    }

    @Override
    public Promise<Response> trace(String string) throws URISyntaxException {
        return this.trace(new URI(string));
    }

    @Override
    public Promise<Response> trace(URI uRI) {
        return this.trace(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> trace(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.TRACE);
    }

    @Override
    public Promise<Response> options(String string) throws URISyntaxException {
        return this.options(new URI(string));
    }

    @Override
    public Promise<Response> options(URI uRI) {
        return this.options(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> options(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.OPTIONS);
    }

    @Override
    public Promise<Response> patch(String string) throws URISyntaxException {
        return this.patch(new URI(string));
    }

    @Override
    public Promise<Response> patch(URI uRI) {
        return this.patch(new RequestOptions(uRI));
    }

    @Override
    public Promise<Response> patch(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.PATCH);
    }
}

