/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.SyncHttpClient;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.Promise;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSyncHttpClient
implements SyncHttpClient {
    private CloseableHttpAsyncClient client;
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentSyncHttpClient.class);

    public PersistentSyncHttpClient(CloseableHttpAsyncClient closeableHttpAsyncClient) {
        this.client = closeableHttpAsyncClient;
    }

    private static void logAndRethrow(String string, Throwable throwable) {
        LOGGER.error(string, throwable);
        throw new HttpClientException(string, throwable);
    }

    @Override
    public Response request(RequestOptions requestOptions, HttpMethod httpMethod) {
        Promise<Response> promise = JavaClient.requestWithClient(requestOptions, httpMethod, null, this.client);
        Response response = null;
        try {
            response = promise.deref();
        }
        catch (InterruptedException interruptedException) {
            PersistentSyncHttpClient.logAndRethrow("Error while waiting for http response", interruptedException);
        }
        if (response.getError() != null) {
            PersistentSyncHttpClient.logAndRethrow("Error executing http request", response.getError());
        }
        return response;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public Response get(String string) throws URISyntaxException {
        return this.get(new URI(string));
    }

    @Override
    public Response get(URI uRI) {
        return this.get(new RequestOptions(uRI));
    }

    @Override
    public Response get(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.GET);
    }

    @Override
    public Response head(String string) throws URISyntaxException {
        return this.head(new URI(string));
    }

    @Override
    public Response head(URI uRI) {
        return this.head(new RequestOptions(uRI));
    }

    @Override
    public Response head(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.HEAD);
    }

    @Override
    public Response post(String string) throws URISyntaxException {
        return this.post(new URI(string));
    }

    @Override
    public Response post(URI uRI) {
        return this.post(new RequestOptions(uRI));
    }

    @Override
    public Response post(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.POST);
    }

    @Override
    public Response put(String string) throws URISyntaxException {
        return this.put(new URI(string));
    }

    @Override
    public Response put(URI uRI) {
        return this.put(new RequestOptions(uRI));
    }

    @Override
    public Response put(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.PUT);
    }

    @Override
    public Response delete(String string) throws URISyntaxException {
        return this.delete(new URI(string));
    }

    @Override
    public Response delete(URI uRI) {
        return this.delete(new RequestOptions(uRI));
    }

    @Override
    public Response delete(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.DELETE);
    }

    @Override
    public Response trace(String string) throws URISyntaxException {
        return this.trace(new URI(string));
    }

    @Override
    public Response trace(URI uRI) {
        return this.trace(new RequestOptions(uRI));
    }

    @Override
    public Response trace(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.TRACE);
    }

    @Override
    public Response options(String string) throws URISyntaxException {
        return this.options(new URI(string));
    }

    @Override
    public Response options(URI uRI) {
        return this.options(new RequestOptions(uRI));
    }

    @Override
    public Response options(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.OPTIONS);
    }

    @Override
    public Response patch(String string) throws URISyntaxException {
        return this.patch(new URI(string));
    }

    @Override
    public Response patch(URI uRI) {
        return this.patch(new RequestOptions(uRI));
    }

    @Override
    public Response patch(RequestOptions requestOptions) {
        return this.request(requestOptions, HttpMethod.PATCH);
    }
}

