/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClose {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncClose.class);
    private static final ExecutorService closerPool = Executors.newFixedThreadPool(3);

    public static void close(Closeable closeable) {
        if (closeable != null) {
            closerPool.submit(new RunnableCloser(closeable));
        }
    }

    private static class RunnableCloser
    implements Runnable {
        private Closeable closeable;

        public RunnableCloser(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public void run() {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Async close error", (Throwable)iOException);
                throw new RuntimeException("Async close error", iOException);
            }
        }
    }
}

