/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.certificate_authority;

import java.io.EOFException;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class ExtensionsUtils {
    private static final Map<String, Integer> keyUsageFlags = new HashMap<String, Integer>(){
        {
            this.put("digital_signature", 128);
            this.put("non_repudiation", 64);
            this.put("key_encipherment", 32);
            this.put("data_encipherment", 16);
            this.put("key_agreement", 8);
            this.put("key_cert_sign", 4);
            this.put("crl_sign", 2);
            this.put("encipher_only", 1);
            this.put("decipher_only", 32768);
        }
    };
    private static final Map<Integer, String> generalNameTags = new HashMap<Integer, String>(){
        {
            this.put(0, "other_name");
            this.put(1, "rfc822_name");
            this.put(2, "dns_name");
            this.put(3, "x400_address");
            this.put(4, "directory_name");
            this.put(5, "edi_party_name");
            this.put(6, "uri");
            this.put(7, "ip");
            this.put(8, "registered_id");
        }
    };

    public static boolean isSubtreeOf(String string, String string2) {
        if (string.equals(string2)) {
            return false;
        }
        return string2.startsWith(string);
    }

    public static List<Map<String, Object>> getExtensionList(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(x509Certificate);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static List<Map<String, Object>> getExtensionList(PKCS10CertificationRequest pKCS10CertificationRequest) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(pKCS10CertificationRequest);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static Map<String, Object> getExtension(X509Certificate x509Certificate, String string) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(x509Certificate);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(pKCS10CertificationRequest);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(List<Map<String, Object>> list, String string) {
        for (Map<String, Object> map : list) {
            if (!map.get("oid").equals(string)) continue;
            return map;
        }
        return null;
    }

    public static Object getExtensionValue(X509Certificate x509Certificate, String string) throws IOException, CertificateEncodingException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(x509Certificate, string));
    }

    public static Object getExtensionValue(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(pKCS10CertificationRequest, string));
    }

    public static Object getExtensionValue(List<Map<String, Object>> list, String string) {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(list, string));
    }

    public static Object getExtensionValue(Map<String, Object> map) {
        if (map != null) {
            return map.get("value");
        }
        return null;
    }

    private static List<Map<String, Object>> getExtensionList(Extensions extensions) throws IOException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getCriticalExtensionOIDs()) {
            arrayList.add(ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, true));
        }
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getNonCriticalExtensionOIDs()) {
            arrayList.add(ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, false));
        }
        return arrayList;
    }

    private static Map<String, Object> makeExtensionMap(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        boolean bl = Arrays.asList(extensions.getCriticalExtensionOIDs()).contains(aSN1ObjectIdentifier);
        return ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, bl);
    }

    static Extensions getExtensionsFromCSR(PKCS10CertificationRequest pKCS10CertificationRequest) {
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = pKCS10CertificationRequest.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) {
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set == null) continue;
            ASN1Encodable aSN1Encodable = aSN1Set.getObjectAt(0);
            if (aSN1Encodable instanceof Extensions) {
                return (Extensions)aSN1Encodable;
            }
            if (!(aSN1Encodable instanceof DERSequence)) continue;
            return Extensions.getInstance((Object)aSN1Encodable);
        }
        return null;
    }

    static Extensions getExtensionsObjFromMap(List<Map<String, Object>> list) throws IOException, OperatorCreationException {
        if (list != null && list.size() > 0) {
            ArrayList<Extension> arrayList = new ArrayList<Extension>();
            for (Map<String, Object> map : list) {
                arrayList.add(ExtensionsUtils.parseExtensionObject(map));
            }
            return new Extensions(arrayList.toArray(new Extension[arrayList.size()]));
        }
        return null;
    }

    static Extension parseExtensionObject(Map<String, Object> map) throws IOException, OperatorCreationException {
        String string = (String)map.get("oid");
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        Boolean bl = (Boolean)map.get("critical");
        if (aSN1ObjectIdentifier.equals((Object)Extension.subjectAlternativeName) || aSN1ObjectIdentifier.equals((Object)Extension.issuerAlternativeName)) {
            Map map2 = (Map)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToGeneralNames(map2)));
        }
        if (aSN1ObjectIdentifier.equals((Object)MiscObjectIdentifiers.netscapeCertComment)) {
            DERIA5String dERIA5String = new DERIA5String((String)map.get("value"));
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)dERIA5String));
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.keyUsage)) {
            Set set = (Set)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.setToKeyUsage(set)));
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.extendedKeyUsage)) {
            List list = (List)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.listToExtendedKeyUsage(list)));
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.basicConstraints)) {
            Map map3 = (Map)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.mapToBasicConstraints(map3)));
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.subjectKeyIdentifier)) {
            PublicKey publicKey = (PublicKey)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.publicKeyToSubjectKeyIdentifier(publicKey)));
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.authorityKeyIdentifier)) {
            PublicKey publicKey = (PublicKey)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)ExtensionsUtils.publicKeyToAuthorityKeyIdentifier(publicKey)));
        }
        if (string.equals("1.3.6.1.4.1.34380.1.1.1") || string.equals("1.3.6.1.4.1.34380.1.1.2") || string.equals("1.3.6.1.4.1.34380.1.1.3") || string.equals("1.3.6.1.4.1.34380.1.1.4")) {
            String string2 = (String)map.get("value");
            return new Extension(aSN1ObjectIdentifier, bl.booleanValue(), (ASN1OctetString)new DEROctetString(string2.getBytes()));
        }
        throw new IllegalArgumentException("Parsing an extension with an OID=" + aSN1ObjectIdentifier.getId() + " is not yet supported.");
    }

    private static Extensions getExtensionsFromCert(X509Certificate x509Certificate) throws CertificateEncodingException, IOException {
        return new X509CertificateHolder(x509Certificate.getEncoded()).getExtensions();
    }

    private static Map<String, Object> makeExtensionMap(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl) throws IOException {
        Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
        if (extension != null) {
            byte[] byArray = extension.getExtnValue().getOctets();
            ASN1Object aSN1Object = ExtensionsUtils.binaryToASN1Object(aSN1ObjectIdentifier, byArray);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("oid", aSN1ObjectIdentifier.getId());
            hashMap.put("critical", bl);
            hashMap.put("value", ExtensionsUtils.asn1ObjToObj((ASN1Encodable)aSN1Object));
            return hashMap;
        }
        return null;
    }

    private static ASN1Object binaryToASN1Object(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        if (aSN1ObjectIdentifier.equals((Object)Extension.subjectAlternativeName) || aSN1ObjectIdentifier.equals((Object)Extension.issuerAlternativeName)) {
            return GeneralNames.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.authorityKeyIdentifier)) {
            return AuthorityKeyIdentifier.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.subjectKeyIdentifier)) {
            return SubjectKeyIdentifier.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.basicConstraints)) {
            return BasicConstraints.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.keyUsage)) {
            DERBitString dERBitString = (DERBitString)ASN1Primitive.fromByteArray((byte[])byArray);
            return KeyUsage.getInstance((Object)dERBitString);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.extendedKeyUsage)) {
            return ExtendedKeyUsage.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)MiscObjectIdentifiers.netscapeCertComment)) {
            try {
                return ASN1Primitive.fromByteArray((byte[])byArray);
            }
            catch (EOFException eOFException) {
                return new DERPrintableString(new String(byArray, "UTF8"));
            }
        }
        return new DERPrintableString(new String(byArray, "UTF8"));
    }

    private static Object asn1ObjToObj(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable instanceof GeneralNames) {
            return ExtensionsUtils.generalNamesToMap((GeneralNames)aSN1Encodable);
        }
        if (aSN1Encodable instanceof AuthorityKeyIdentifier) {
            return ExtensionsUtils.authorityKeyIdToMap((AuthorityKeyIdentifier)aSN1Encodable);
        }
        if (aSN1Encodable instanceof BasicConstraints) {
            return ExtensionsUtils.basicConstraintsToMap((BasicConstraints)aSN1Encodable);
        }
        if (aSN1Encodable instanceof SubjectKeyIdentifier) {
            SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)aSN1Encodable;
            return subjectKeyIdentifier.getKeyIdentifier();
        }
        if (aSN1Encodable instanceof ExtendedKeyUsage) {
            return ExtensionsUtils.extKeyUsageToList((ExtendedKeyUsage)aSN1Encodable);
        }
        if (aSN1Encodable instanceof KeyPurposeId) {
            KeyPurposeId keyPurposeId = (KeyPurposeId)aSN1Encodable;
            return keyPurposeId.getId();
        }
        if (aSN1Encodable instanceof KeyUsage) {
            KeyUsage keyUsage = (KeyUsage)aSN1Encodable;
            return ExtensionsUtils.keyUsageToSet(keyUsage);
        }
        if (aSN1Encodable instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)aSN1Encodable;
            return dERBitString.getString();
        }
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable;
            return ExtensionsUtils.asn1ObjToObj((ASN1Encodable)aSN1TaggedObject.getObject());
        }
        if (aSN1Encodable instanceof ASN1Sequence) {
            return ExtensionsUtils.asn1SeqToList((ASN1Sequence)aSN1Encodable);
        }
        if (aSN1Encodable instanceof ASN1String) {
            ASN1String aSN1String = (ASN1String)aSN1Encodable;
            return aSN1String.getString();
        }
        if (aSN1Encodable instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Encodable;
            return new String(aSN1OctetString.getOctets(), "UTF-8");
        }
        return aSN1Encodable.toASN1Primitive().getEncoded();
    }

    private static Set<String> keyUsageToSet(KeyUsage keyUsage) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : keyUsageFlags.keySet()) {
            if (!keyUsage.hasUsages(keyUsageFlags.get(string).intValue())) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static KeyUsage setToKeyUsage(Set<String> set) {
        int n = 0;
        for (String string : set) {
            Integer n2 = keyUsageFlags.get(string);
            if (n2 == null) {
                throw new IllegalArgumentException("The provided usage key does not exist: '" + string + "'");
            }
            n |= n2.intValue();
        }
        return new KeyUsage(n);
    }

    private static ExtendedKeyUsage listToExtendedKeyUsage(List<String> list) {
        ArrayList<KeyPurposeId> arrayList = new ArrayList<KeyPurposeId>();
        for (String string : list) {
            arrayList.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(string)));
        }
        return new ExtendedKeyUsage(arrayList.toArray(new KeyPurposeId[arrayList.size()]));
    }

    private static List<Object> extKeyUsageToList(ExtendedKeyUsage extendedKeyUsage) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (KeyPurposeId keyPurposeId : extendedKeyUsage.getUsages()) {
            arrayList.add(ExtensionsUtils.asn1ObjToObj((ASN1Encodable)keyPurposeId));
        }
        return arrayList;
    }

    private static Map<String, Object> basicConstraintsToMap(BasicConstraints basicConstraints) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("is_ca", basicConstraints.isCA());
        hashMap.put("path_len_constraint", basicConstraints.getPathLenConstraint());
        return hashMap;
    }

    private static BasicConstraints mapToBasicConstraints(Map<String, Object> map) {
        if (map.keySet().size() > 2) {
            throw new IllegalArgumentException("There should be two keys present in the basic constrains map, 'is_ca' and 'path_len_constraint'");
        }
        Boolean bl = (Boolean)map.get("is_ca");
        if (bl == null) {
            throw new IllegalArgumentException("The 'is_ca' key must be present.");
        }
        if (bl.booleanValue()) {
            Integer n = (Integer)map.get("path_len_constraint");
            if (n == null) {
                n = 0;
            }
            return new BasicConstraints(n.intValue());
        }
        return new BasicConstraints(false);
    }

    private static SubjectKeyIdentifier publicKeyToSubjectKeyIdentifier(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(digestCalculator);
        return x509ExtensionUtils.createSubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    private static AuthorityKeyIdentifier publicKeyToAuthorityKeyIdentifier(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(digestCalculator);
        return x509ExtensionUtils.createAuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    private static Map<String, Object> authorityKeyIdToMap(AuthorityKeyIdentifier authorityKeyIdentifier) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("issuer", ExtensionsUtils.generalNamesToMap(authorityKeyIdentifier.getAuthorityCertIssuer()));
        hashMap.put("serial_number", authorityKeyIdentifier.getAuthorityCertSerialNumber());
        hashMap.put("key_identifier", authorityKeyIdentifier.getKeyIdentifier());
        return hashMap;
    }

    private static List<Object> asn1SeqToList(ASN1Sequence aSN1Sequence) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            arrayList.add(ExtensionsUtils.asn1ObjToObj(aSN1Sequence.getObjectAt(i)));
        }
        return arrayList;
    }

    private static Integer getGnTagFromName(String string) {
        for (int i = 0; i < generalNameTags.size(); ++i) {
            if (!generalNameTags.get(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return null;
    }

    private static Map<String, List<String>> generalNamesToMap(GeneralNames generalNames) throws IOException {
        if (generalNames != null) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (GeneralName generalName : generalNames.getNames()) {
                String string = generalNameTags.get(generalName.getTagNo());
                if (hashMap.get(string) == null) {
                    hashMap.put(string, new ArrayList());
                }
                String string2 = (String)ExtensionsUtils.asn1ObjToObj((ASN1Encodable)generalName.getName().toASN1Primitive());
                ((List)hashMap.get(string)).add(string2);
            }
            return hashMap;
        }
        return null;
    }

    private static GeneralNames mapToGeneralNames(Map<String, List<String>> map) {
        ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
        for (String string : map.keySet()) {
            Integer n = ExtensionsUtils.getGnTagFromName(string);
            if (n == null) {
                throw new IllegalArgumentException("Could not find a tag number for the type name '" + string + '\"');
            }
            for (String string2 : map.get(string)) {
                arrayList.add(new GeneralName(n.intValue(), string2));
            }
        }
        return new GeneralNames(arrayList.toArray(new GeneralName[arrayList.size()]));
    }

    private static interface PuppetExtensionOids {
        public static final String parent = "1.3.6.1.4.1.34380";
        public static final String certExt = "1.3.6.1.4.1.34380.1";
        public static final String regCertExt = "1.3.6.1.4.1.34380.1.1";
        public static final String nodeUid = "1.3.6.1.4.1.34380.1.1.1";
        public static final String nodeInstanceId = "1.3.6.1.4.1.34380.1.1.2";
        public static final String nodeImageName = "1.3.6.1.4.1.34380.1.1.3";
        public static final String nodePresharedKey = "1.3.6.1.4.1.34380.1.1.4";
        public static final String privateCertExt = "1.3.6.1.4.1.34380.1.2";
    }
}

