/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.certificate_authority;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class ExtensionsUtils {
    private static final Map<Integer, String> generalNameTags = new HashMap<Integer, String>(){
        {
            this.put(0, "other_name");
            this.put(1, "rfc822_name");
            this.put(2, "dns_name");
            this.put(3, "x400_address");
            this.put(4, "directory_name");
            this.put(5, "edi_party_name");
            this.put(6, "uri");
            this.put(7, "ip");
            this.put(8, "registered_id");
        }
    };

    public static List<Map<String, Object>> getExtensionList(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(x509Certificate);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static List<Map<String, Object>> getExtensionList(PKCS10CertificationRequest pKCS10CertificationRequest) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(pKCS10CertificationRequest);
        if (extensions != null) {
            return ExtensionsUtils.getExtensionList(extensions);
        }
        return null;
    }

    public static Map<String, Object> getExtension(X509Certificate x509Certificate, String string) throws IOException, CertificateEncodingException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCert(x509Certificate);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        Extensions extensions = ExtensionsUtils.getExtensionsFromCSR(pKCS10CertificationRequest);
        if (extensions != null) {
            return ExtensionsUtils.makeExtensionMap(extensions, new ASN1ObjectIdentifier(string));
        }
        return null;
    }

    public static Map<String, Object> getExtension(List<Map<String, Object>> list, String string) {
        for (Map<String, Object> map : list) {
            if (!map.get("oid").equals(string)) continue;
            return map;
        }
        return null;
    }

    public static Object getExtensionValue(X509Certificate x509Certificate, String string) throws IOException, CertificateEncodingException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(x509Certificate, string));
    }

    public static Object getExtensionValue(PKCS10CertificationRequest pKCS10CertificationRequest, String string) throws IOException {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(pKCS10CertificationRequest, string));
    }

    public static Object getExtensionValue(List<Map<String, Object>> list, String string) {
        return ExtensionsUtils.getExtensionValue(ExtensionsUtils.getExtension(list, string));
    }

    public static Object getExtensionValue(Map<String, Object> map) {
        if (map != null) {
            return map.get("value");
        }
        return null;
    }

    private static List<Map<String, Object>> getExtensionList(Extensions extensions) throws IOException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getCriticalExtensionOIDs()) {
            arrayList.add(ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, true));
        }
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier : extensions.getNonCriticalExtensionOIDs()) {
            arrayList.add(ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, false));
        }
        return arrayList;
    }

    private static Map<String, Object> makeExtensionMap(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        boolean bl = Arrays.asList(extensions.getCriticalExtensionOIDs()).contains(aSN1ObjectIdentifier);
        return ExtensionsUtils.makeExtensionMap(extensions, aSN1ObjectIdentifier, bl);
    }

    static Extensions getExtensionsFromCSR(PKCS10CertificationRequest pKCS10CertificationRequest) {
        for (Attribute attribute : pKCS10CertificationRequest.getAttributes()) {
            ASN1Set aSN1Set;
            if (attribute.getAttrType() != PKCSObjectIdentifiers.pkcs_9_at_extensionRequest || (aSN1Set = attribute.getAttrValues()) == null) continue;
            DERSet dERSet = (DERSet)aSN1Set.getObjectAt(0);
            if (dERSet != null) {
                return (Extensions)dERSet.getObjectAt(0);
            }
            return null;
        }
        return null;
    }

    static Extensions getExtensionsObjFromMap(List<Map<String, Object>> list) throws IOException {
        if (list != null && list.size() > 0) {
            ArrayList<Extension> arrayList = new ArrayList<Extension>();
            for (Map<String, Object> map : list) {
                arrayList.add(ExtensionsUtils.parseExtensionObject(map));
            }
            return new Extensions(arrayList.toArray(new Extension[arrayList.size()]));
        }
        return null;
    }

    static Extension parseExtensionObject(Map<String, Object> map) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier((String)map.get("oid"));
        if (!aSN1ObjectIdentifier.equals((Object)Extension.subjectAlternativeName) && !aSN1ObjectIdentifier.equals((Object)Extension.issuerAlternativeName)) {
            throw new IllegalArgumentException("Parsing an extension with an OID=" + aSN1ObjectIdentifier.getId() + " is not yet supported.");
        }
        Map map2 = (Map)map.get("value");
        GeneralNames generalNames = ExtensionsUtils.mapToGeneralNames(map2);
        return new Extension(aSN1ObjectIdentifier, ((Boolean)map.get("critical")).booleanValue(), (ASN1OctetString)new DEROctetString((ASN1Encodable)generalNames));
    }

    private static Extensions getExtensionsFromCert(X509Certificate x509Certificate) throws CertificateEncodingException, IOException {
        return new X509CertificateHolder(x509Certificate.getEncoded()).getExtensions();
    }

    private static Map<String, Object> makeExtensionMap(Extensions extensions, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl) throws IOException {
        Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
        if (extension != null) {
            byte[] byArray = extension.getExtnValue().getOctets();
            ASN1Object aSN1Object = ExtensionsUtils.binaryToASN1Object(aSN1ObjectIdentifier, byArray);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("oid", aSN1ObjectIdentifier.getId());
            hashMap.put("critical", bl);
            hashMap.put("value", ExtensionsUtils.asn1ObjToObj((ASN1Encodable)aSN1Object));
            return hashMap;
        }
        return null;
    }

    private static ASN1Object binaryToASN1Object(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        if (aSN1ObjectIdentifier.equals((Object)Extension.subjectAlternativeName) || aSN1ObjectIdentifier.equals((Object)Extension.issuerAlternativeName)) {
            return GeneralNames.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.authorityKeyIdentifier)) {
            return AuthorityKeyIdentifier.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.subjectKeyIdentifier)) {
            return SubjectKeyIdentifier.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.basicConstraints)) {
            return BasicConstraints.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.keyUsage)) {
            DERBitString dERBitString = new DERBitString(byArray);
            return new KeyUsage(dERBitString.getPadBits());
        }
        if (aSN1ObjectIdentifier.equals((Object)Extension.extendedKeyUsage)) {
            return ExtendedKeyUsage.getInstance((Object)byArray);
        }
        if (aSN1ObjectIdentifier.equals((Object)MiscObjectIdentifiers.netscapeCertComment)) {
            return new DERPrintableString(new String(byArray, "UTF8"));
        }
        return new DERPrintableString(new String(byArray, "UTF8"));
    }

    private static Object asn1ObjToObj(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable instanceof GeneralNames) {
            return ExtensionsUtils.generalNamesToMap((GeneralNames)aSN1Encodable);
        }
        if (aSN1Encodable instanceof AuthorityKeyIdentifier) {
            return ExtensionsUtils.authorityKeyIdToMap((AuthorityKeyIdentifier)aSN1Encodable);
        }
        if (aSN1Encodable instanceof BasicConstraints) {
            return ExtensionsUtils.basicConstraintsToMap((BasicConstraints)aSN1Encodable);
        }
        if (aSN1Encodable instanceof SubjectKeyIdentifier) {
            SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)aSN1Encodable;
            return subjectKeyIdentifier.getKeyIdentifier();
        }
        if (aSN1Encodable instanceof ExtendedKeyUsage) {
            return ExtensionsUtils.extKeyUsageToList((ExtendedKeyUsage)aSN1Encodable);
        }
        if (aSN1Encodable instanceof KeyPurposeId) {
            KeyPurposeId keyPurposeId = (KeyPurposeId)aSN1Encodable;
            return keyPurposeId.getId();
        }
        if (aSN1Encodable instanceof KeyUsage) {
            KeyUsage keyUsage = (KeyUsage)aSN1Encodable;
            return ExtensionsUtils.keyUsageToMap(keyUsage);
        }
        if (aSN1Encodable instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)aSN1Encodable;
            return dERBitString.getString();
        }
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable;
            return ExtensionsUtils.asn1ObjToObj((ASN1Encodable)aSN1TaggedObject.getObject());
        }
        if (aSN1Encodable instanceof ASN1Sequence) {
            return ExtensionsUtils.asn1SeqToList((ASN1Sequence)aSN1Encodable);
        }
        if (aSN1Encodable instanceof ASN1String) {
            ASN1String aSN1String = (ASN1String)aSN1Encodable;
            return aSN1String.getString();
        }
        if (aSN1Encodable instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Encodable;
            return new String(aSN1OctetString.getOctets(), "UTF-8");
        }
        return aSN1Encodable.toASN1Primitive().getEncoded();
    }

    private static Map<String, Boolean> keyUsageToMap(KeyUsage keyUsage) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("digital_signature", keyUsage.hasUsages(128));
        hashMap.put("non_repudiation", keyUsage.hasUsages(64));
        hashMap.put("key_encipherment", keyUsage.hasUsages(32));
        hashMap.put("data_encipherment", keyUsage.hasUsages(16));
        hashMap.put("key_agreement", keyUsage.hasUsages(8));
        hashMap.put("key_cert_sign", keyUsage.hasUsages(4));
        hashMap.put("crl_sign", keyUsage.hasUsages(2));
        hashMap.put("encipher_only", keyUsage.hasUsages(1));
        hashMap.put("decipher_only", keyUsage.hasUsages(32768));
        return hashMap;
    }

    private static List<Object> extKeyUsageToList(ExtendedKeyUsage extendedKeyUsage) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (KeyPurposeId keyPurposeId : extendedKeyUsage.getUsages()) {
            arrayList.add(ExtensionsUtils.asn1ObjToObj((ASN1Encodable)keyPurposeId));
        }
        return arrayList;
    }

    private static Map<String, Object> basicConstraintsToMap(BasicConstraints basicConstraints) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("is_ca", basicConstraints.isCA());
        hashMap.put("path_len_constraint", basicConstraints.getPathLenConstraint());
        return hashMap;
    }

    private static Map<String, Object> authorityKeyIdToMap(AuthorityKeyIdentifier authorityKeyIdentifier) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("issuer", ExtensionsUtils.generalNamesToMap(authorityKeyIdentifier.getAuthorityCertIssuer()));
        hashMap.put("serial_number", authorityKeyIdentifier.getAuthorityCertSerialNumber());
        hashMap.put("key_identifier", authorityKeyIdentifier.getKeyIdentifier());
        return hashMap;
    }

    private static List<Object> asn1SeqToList(ASN1Sequence aSN1Sequence) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            arrayList.add(ExtensionsUtils.asn1ObjToObj(aSN1Sequence.getObjectAt(i)));
        }
        return arrayList;
    }

    private static Integer getGnTagFromName(String string) {
        for (int i = 0; i < generalNameTags.size(); ++i) {
            if (!generalNameTags.get(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return null;
    }

    private static Map<String, List<String>> generalNamesToMap(GeneralNames generalNames) throws IOException {
        if (generalNames != null) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            for (GeneralName generalName : generalNames.getNames()) {
                String string = generalNameTags.get(generalName.getTagNo());
                if (hashMap.get(string) == null) {
                    hashMap.put(string, new ArrayList());
                }
                String string2 = (String)ExtensionsUtils.asn1ObjToObj((ASN1Encodable)generalName.getName().toASN1Primitive());
                ((List)hashMap.get(string)).add(string2);
            }
            return hashMap;
        }
        return null;
    }

    private static GeneralNames mapToGeneralNames(Map<String, List<String>> map) {
        ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
        for (String string : map.keySet()) {
            Integer n = ExtensionsUtils.getGnTagFromName(string);
            if (n == null) {
                throw new IllegalArgumentException("Could not find a tag number for the type name '" + string + '\"');
            }
            for (String string2 : map.get(string)) {
                arrayList.add(new GeneralName(n.intValue(), string2));
            }
        }
        return new GeneralNames(arrayList.toArray(new GeneralName[arrayList.size()]));
    }
}

