/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.certificate_authority;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v2CRLBuilder;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class CertificateAuthority {
    public static final int DEFAULT_KEY_LENGTH = 4096;

    public static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException {
        return CertificateAuthority.generateKeyPair(4096);
    }

    public static KeyPair generateKeyPair(int n) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n);
        return keyPairGenerator.generateKeyPair();
    }

    public static X500Name generateX500Name(String string) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, string);
        return x500NameBuilder.build();
    }

    public static String getCommonNameFromX500Name(X500Name x500Name) {
        return x500Name.getRDNs(BCStyle.CN)[0].getFirst().getValue().toString();
    }

    public static PKCS10CertificationRequest generateCertificateRequest(KeyPair keyPair, X500Name x500Name) throws IOException, OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder jcaPKCS10CertificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(x500Name, keyPair.getPublic());
        return jcaPKCS10CertificationRequestBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").build(keyPair.getPrivate()));
    }

    public static X509Certificate signCertificateRequest(PKCS10CertificationRequest pKCS10CertificationRequest, X500Name x500Name, BigInteger bigInteger, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        DateTime dateTime = DateTime.now().minus((ReadablePeriod)Period.days((int)1));
        DateTime dateTime2 = DateTime.now().plus((ReadablePeriod)Period.years((int)5));
        X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, bigInteger, dateTime.toDate(), dateTime2.toDate(), pKCS10CertificationRequest.getSubject(), pKCS10CertificationRequest.getSubjectPublicKeyInfo());
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder("SHA256WithRSA");
        ContentSigner contentSigner = jcaContentSignerBuilder.build(privateKey);
        X509CertificateHolder x509CertificateHolder = x509v3CertificateBuilder.build(contentSigner);
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        return jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
    }

    public static X509CRL generateCRL(X500Principal x500Principal, PrivateKey privateKey) throws CRLException, OperatorCreationException {
        Date date = DateTime.now().toDate();
        Date date2 = DateTime.now().plusYears(100).toDate();
        JcaX509v2CRLBuilder jcaX509v2CRLBuilder = new JcaX509v2CRLBuilder(x500Principal, date);
        jcaX509v2CRLBuilder.setNextUpdate(date2);
        JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder("SHA256withRSA");
        ContentSigner contentSigner = jcaContentSignerBuilder.build(privateKey);
        X509CRLHolder x509CRLHolder = jcaX509v2CRLBuilder.build(contentSigner);
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        return jcaX509CRLConverter.getCRL(x509CRLHolder);
    }

    public static X509CRL pemToCRL(Reader reader) throws IOException, CRLException {
        List<Object> list = CertificateAuthority.pemToObjects(reader);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one object");
        }
        JcaX509CRLConverter jcaX509CRLConverter = new JcaX509CRLConverter();
        return jcaX509CRLConverter.getCRL((X509CRLHolder)list.get(0));
    }

    public static PKCS10CertificationRequest pemToCertificateRequest(Reader reader) throws IOException {
        List<Object> list = CertificateAuthority.pemToObjects(reader);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one object");
        }
        return (PKCS10CertificationRequest)list.get(0);
    }

    public static KeyStore createKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        return keyStore;
    }

    public static List<Object> pemToObjects(Reader reader) throws IOException {
        PEMParser pEMParser = new PEMParser(reader);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = pEMParser.readObject();
        while (object != null) {
            arrayList.add(object);
            object = pEMParser.readObject();
        }
        return arrayList;
    }

    public static void writeToPEM(Object object, Writer writer) throws IOException {
        PEMWriter pEMWriter = new PEMWriter(writer);
        pEMWriter.writeObject(object);
        pEMWriter.flush();
    }

    public static List<X509Certificate> pemToCerts(Reader reader) throws CertificateException, IOException {
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        List<Object> list = CertificateAuthority.pemToObjects(reader);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        for (Object object : list) {
            arrayList.add(jcaX509CertificateConverter.getCertificate((X509CertificateHolder)object));
        }
        return arrayList;
    }

    public static X509Certificate pemToCert(Reader reader) throws CertificateException, IOException {
        List<X509Certificate> list = CertificateAuthority.pemToCerts(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly 1 certificate");
        }
        return list.get(0);
    }

    public static PrivateKey objectToPrivateKey(Object object) throws PEMException {
        if (object instanceof PrivateKeyInfo) {
            return new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)object);
        }
        if (object instanceof PEMKeyPair) {
            return new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)object).getPrivate();
        }
        throw new IllegalArgumentException("Expected a KeyPair or PrivateKey, got " + object);
    }

    public static List<PrivateKey> pemToPrivateKeys(Reader reader) throws IOException, PEMException {
        List<Object> list = CertificateAuthority.pemToObjects(reader);
        ArrayList<PrivateKey> arrayList = new ArrayList<PrivateKey>(list.size());
        for (Object object : list) {
            arrayList.add(CertificateAuthority.objectToPrivateKey(object));
        }
        return arrayList;
    }

    public static PrivateKey pemToPrivateKey(Reader reader) throws IOException {
        List<PrivateKey> list = CertificateAuthority.pemToPrivateKeys(reader);
        if (list.size() != 1) {
            throw new IllegalArgumentException("The PEM stream must contain exactly one private key");
        }
        return list.get(0);
    }

    public static KeyStore associateCert(KeyStore keyStore, String string, X509Certificate x509Certificate) throws KeyStoreException {
        keyStore.setCertificateEntry(string, x509Certificate);
        return keyStore;
    }

    public static KeyStore associateCertsFromReader(KeyStore keyStore, String string, Reader reader) throws CertificateException, KeyStoreException, IOException {
        List<X509Certificate> list = CertificateAuthority.pemToCerts(reader);
        ListIterator<X509Certificate> listIterator = list.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            CertificateAuthority.associateCert(keyStore, string + "-" + n, listIterator.next());
            ++n;
        }
        return keyStore;
    }

    public static KeyStore associatePrivateKey(KeyStore keyStore, String string, PrivateKey privateKey, String string2, X509Certificate x509Certificate) throws KeyStoreException {
        keyStore.setKeyEntry(string, privateKey, string2.toCharArray(), new Certificate[]{x509Certificate});
        return keyStore;
    }

    public static KeyStore associatePrivateKeyFromReader(KeyStore keyStore, String string, Reader reader, String string2, Reader reader2) throws CertificateException, KeyStoreException, IOException {
        PrivateKey privateKey = CertificateAuthority.pemToPrivateKey(reader);
        List<X509Certificate> list = CertificateAuthority.pemToCerts(reader2);
        if (list.size() > 1) {
            throw new IllegalArgumentException("The PEM stream contains more than one certificate");
        }
        X509Certificate x509Certificate = list.get(0);
        return CertificateAuthority.associatePrivateKey(keyStore, string, privateKey, string2, x509Certificate);
    }

    public static Map<String, Object> pemsToKeyAndTrustStores(Reader reader, Reader reader2, Reader reader3) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = CertificateAuthority.createKeyStore();
        CertificateAuthority.associateCertsFromReader(keyStore, "CA Certificate", reader3);
        KeyStore keyStore2 = CertificateAuthority.createKeyStore();
        String string = UUID.randomUUID().toString();
        CertificateAuthority.associatePrivateKeyFromReader(keyStore2, "Private Key", reader2, string, reader);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("truststore", keyStore);
        hashMap.put("keystore", keyStore2);
        hashMap.put("keystore-pw", string);
        return hashMap;
    }

    public static KeyManagerFactory getKeyManagerFactory(KeyStore keyStore, String string) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string.toCharArray());
        return keyManagerFactory;
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    public static SSLContext pemsToSSLContext(Reader reader, Reader reader2, Reader reader3) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        Map<String, Object> map = CertificateAuthority.pemsToKeyAndTrustStores(reader, reader2, reader3);
        KeyStore keyStore = (KeyStore)map.get("keystore");
        String string = (String)map.get("keystore-pw");
        KeyStore keyStore2 = (KeyStore)map.get("truststore");
        KeyManagerFactory keyManagerFactory = CertificateAuthority.getKeyManagerFactory(keyStore, string);
        TrustManagerFactory trustManagerFactory = CertificateAuthority.getTrustManagerFactory(keyStore2);
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }

    public static SSLContext caCertPemToSSLContext(Reader reader) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        KeyStore keyStore = CertificateAuthority.createKeyStore();
        CertificateAuthority.associateCertsFromReader(keyStore, "CA Certificate", reader);
        TrustManagerFactory trustManagerFactory = CertificateAuthority.getTrustManagerFactory(keyStore);
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
        return sSLContext;
    }
}

