(ns pulley.usage
  (:require [pulley.ring        :as ring]
            [pulley.store.mysql :as mysql-store]
            [pulley.publish     :as publish]
            [ring.adapter.jetty :as jetty]
            [clojure.java.jdbc  :as jdbc]))

;;--------------------------------------------------------------------
;; Initialize an event store
;;

(def mysql-db {:subprotocol "mysql"
               :subname "//127.0.0.1:3306/events_test"
               :user "root"})

(def mysql-store (mysql-store/make-event-store mysql-db "switch_events4"))


;;--------------------------------------------------------------------
;; Publishing API
;;

(publish/publish! mysql-store {:event           :uswitch/received
                               :created-at      #inst "2013-05-01T17:48"
                               :received-at     #inst "2013-05-01T17:49"})

(publish/publish! mysql-store {:event           :uswitch/delivered
                               :delivered-at    #inst "2013-05-02T05:01"})

(publish/publish! mysql-store {:event           :supplier/acknowledged
                               :acknowledged-at #inst "2013-05-02T10:03"})


;;--------------------------------------------------------------------
;; Feed API
;;

;; generate a ring handler exposing all events in the supplied store
(def handler (ring/handler mysql-store :page-size 10))

(comment

  (def server (jetty/run-jetty #'handler
                               {:join? false
                                :port 8001}))

  (.stop server)

  )

(defn -main
  [& args]
  (future
    (while true
      (publish/publish! mysql-store {:event           :uswitch/received
                                     :created-at      #inst "2013-05-01T17:48"
                                     :received-at     #inst "2013-05-01T17:49"})
      
      (publish/publish! mysql-store {:event           :uswitch/delivered
                                     :delivered-at    #inst "2013-05-02T05:01"})
      
      (publish/publish! mysql-store {:event           :supplier/acknowledged
                                     :acknowledged-at #inst "2013-05-02T10:03"})
      (Thread/sleep 15000)))
  (jetty/run-jetty #'handler
    {:join? true
     :port 8001}))
