(ns pulley.publish
  (:require [pulley.store :as store]))

(def ^:dynamic *store*
  "Dynamic var potentially holding an EventStore implementation"
  nil)

(defmacro with-store
  "Bind *store* to the given store, and execute body. Any events
  published in body will be persisted by this store, if no other store
  is explicitly specified."
  [store & body]
  `(binding [*store* ~store]
     ~@body))

(defn publish!
  "Publish event data to the given store, or the value of *store*."
  ([event]
     (publish! *store* event))
  ([store event]
     {:pre [(not (nil? store))
            (not (nil? event))]}
     (store/write store event)))
