(ns leiningen.new.pudge-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files
                                             sanitize]]
            [leiningen.core.main :as main]))

(def render (renderer "pudge-app"))

(defn pudge-app
  "A template to get developing an om app with a cljs repl as quickly as
possible."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              :connection-string "{{ connection-script|safe }}"}]
    (main/info "Generating fresh 'lein new' pudge-app project.")
    (->files data
             [".gitignore"                  (render "gitignore" data)]
             ["project.clj"                 (render "project.clj" data)]
             ["resources/index.html"        (render "index.html" data)]
             ["src/{{sanitized}}/core.cljs" (render "core.cljs" data)])))
