(ns om-tools.dom
  (:refer-clojure :exclude [map meta time])
  (:require
   [clojure.string :as str]
   om.dom
                  )
       
          
                                  )

     
                 
               

(defn map-keys [f m]
  (into {} (for [[k v] m]
             [(f k) v])))

(defn camel-case [s]
  (str/replace
   s #"-(\w)"
   #(str/upper-case (second %))))

(defn opt-key-alias [opt]
  (case opt
    :class :className
    :for :htmlFor
    opt))

(defn format-opt-key [opt-key]
  (-> opt-key
      opt-key-alias
      name
      camel-case
      keyword))

(defn format-opt-style [opt]
  (let [[k v] opt]
    (if (= k :style)
      [k (clj->js v)]
      opt)))

(defn format-opts [opts]
  (->> opts
       (map-keys format-opt-key)
       (clojure.core/map format-opt-style)
       (into {})
       clj->js))

(defn literal? [form]
  (not (or (symbol? form)
           (list? form))))

(defn possible-coll? [form]
  (or (coll? form)
      (symbol? form)
      (list? form)))

(def form-tags
  '[input textarea option])

(defn el-ctor [tag]
  (if (some (partial = tag) form-tags)
    (symbol "om.dom" (name tag))
    (symbol "js" (str "React.DOM." (name tag)))))

(defn valid-opts? [opts]
  (or (nil? opts) (map? opts)))

(defn element-args [opts children]
  (if (valid-opts? opts)
    [(when opts (format-opts opts)) children]
    [nil (cons opts children)]))

      
(defn element [ctor opts children]
  (let [[opts children] (element-args opts children)]
    (apply ctor (flatten (cons opts children)))))

     
                                          
                                     
                                 
                           
                                                                
                
                                                          
                                        

                                                                     
                                                           

                 
                                                                   
                                                                       

                                            
      
                                                                               

     
                       

      
(defn class-set [m]
  "Returns a string of keys with truthy values joined together by spaces,
   or returns nil when no truthy values."
  (when-let [ks (->> m (filter val) keys (clojure.core/map name) distinct seq)]
    (str/join " " ks)))

;;;;;;;;;;;; This file autogenerated from src/om_tools/dom.cljx
