(ns om-tools.dom
  (:refer-clojure :exclude [map meta time])
  (:require
   [clojure.string :as str]
   om.dom
                  )
       
          
                                  )

(defn map-keys [f m]
  (into {} (for [[k v] m]
             [(f k) v])))

(defn camel-case [s]
  (str/replace
   s #"-(\w)"
   #(str/upper-case (second %))))

(defn opt-alias [opt]
  (case opt
    :class :className
    :for :htmlFor
    opt))

(defn format-opt [opt]
  (-> opt
      opt-alias
      name
      camel-case
      keyword))

(defn literal? [form]
  (not (or (symbol? form)
           (list? form))))

(defn possible-coll? [form]
  (or (coll? form)
      (symbol? form)
      (list? form)))

(def form-tags
  '[input textarea option])

(defn el-ctor [tag]
  (if (some (partial = tag) form-tags)
    (symbol "om.dom" (name tag))
    (symbol "js" (str "React.DOM." (name tag)))))

(defn valid-opts? [opts]
  (or (nil? opts) (map? opts)))

      
(defn element [ctor opts children]
  (let [[opts children] (if (valid-opts? opts)
                          [(->> opts (map-keys format-opt) clj->js) children]
                          [nil (cons opts children)])]
    (apply ctor (flatten (cons opts children)))))

     
                                          
                                     
                                 
                           
                                                        
                                                                                                  
                                                                 
                
                                                          
                                        

                                                                     
                                                           

                 
                                                                   
                                                                       

                                            
      
                                                                               

     
                       

;;;;;;;;;;;; This file autogenerated from src/om_tools/dom.cljx
