(ns om-tools.core
  "Tools for Om"
  (:require
   [om.core :as om]
   [plumbing.fnk.schema]
   [plumbing.core :as p        :include-macros        true]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Private

     
                                 
                      
                        
             

     
                                     
                                                 
                                             
                                                   
                                             
                                           
                                                 
                                               
                                             
                                                            
                                      
                                                   
                      
                                                                            
                               
                        
                    

     
                                 
                                      
               
                                   
                  
                                        

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Public

(defn state-proxy
  "Returns an atom-like object for reading and writing Om component state"
  [owner]
        
  (let [get-state #(om.core/get-state owner)]
    (reify
      IDeref
      (-deref [_]
        (get-state))
      IReset
      (-reset! [_ v]
        (om.core/set-state! owner v))
      ISwap
      (-swap! [s f]
        (-reset! s (f (get-state))))
      (-swap! [s f x]
        (-reset! s (f (get-state) x)))
      (-swap! [s f x y]
        (-reset! s (f (get-state) x y)))
      (-swap! [s f x y more]
        (-reset! s (apply f (get-state) x y more))))))

                   
                                                                   
                                                                 
                                                             

                                                                  
                                                            
               

                                    
                            

           

             
                           
                        

                                                                                 
                               
           
                                             

                      
                                                                
                                                               
                          

                                                   
                                                           
                                      
                                                        
                                                                                          

                                                                    

                                                                    
                                                          

          

                                                       
                  
                                   
                      
               
                                                           
                                                           
                               
        
                  
                                           
                                       
                                 
                                              
                      
                        
                      
                                         
                                         

;;;;;;;;;;;; This file autogenerated from src/om_tools/core.cljx
