(ns prisma.plugins.questions)

(defprotocol IQuestions
  (integration-name [_] "Retrieves name for current questions integration")
  (integration-icon [_] "Retrieves icon for current questions integration")
  (get-questions [_ customer campaign-customer config] "Retrieves questions")
  (validate-answers [_ customer campaign-customer config data] "Validates users answers")
  )

(defprotocol IQuestionsGUI
  (render-config [_] "Return a om/component with funnel customization")
  (validate-config [_ config-data] "Validate data and return a error structure")
  )

(defprotocol IQuestionsIntegration
  (edit-integration [_] "Return a om/component with external integration configuration")
  (preview-integration [_] "Return a om/component with external integration preview")
  (validate-integration [_ data] "Return validation for this extenral integration")
  )