(ns prisma.plugins.funnel)

(defprotocol IFunnel
  (step-name [_] "Retrieves name for current step")
  (step-icon [_] "Retrives icon id ")
  (step-type [_] "Retrives current step type")

  (step-categories [_]
    "Step categories
      :visible-gui    -- Tiene una interfaz visible al usuario
      :client-side    -- Ejecuta codigo del lado del cliente
      :server-side    -- Ejecuta codigo del lado del servidor
      :interactive    -- Permite interactuar con el usuario
      :customer-data  -- Accede o modifica datos del customer
      :external-services -- Envia o recibe informacion hacia o desde servicios externos")


  (funnel-type [_] "Retrieve the funnel type")

  (get-initial-data [_] "Return a initial data for the funnel, default texts etc"))

(defprotocol IFunnelGUI
  (render-preview [_] "Return a om/component with funnel config preview")
  (render-config [_] "Return a om/component with funnel customization")
  (validate-config [_ config-data] "Validate data and return a error structure")
  (trimmed-config [_ config-data] "Returns a clean configuration leaving out data required for display"))

(defprotocol IDialogButtonBar
  (dialog-button-bar [_] "Returns an om / component with the button bar to save, close and other custom operations that will be displayed instead of the standard button bar"))

(defprotocol IDialogModalClass
  (dialog-modal-class [_ config-data] "Returns an class name to be used on step modal configuration"))

(defprotocol IFunnelAddStep
  (add-funnel-step [_ system campaign funnel-step funnel-step-s12n]
    "Return a list of transactions to be applied to support current configuration in step specialization"))

(defprotocol IFunnelStoreFunnelData
  (store-funnel-data [_ system funnel-step funnel-step-s12n company customer campaign-customer data context]
    ""))

(defprotocol IFunnelValidateFunnelData
  (validate-funnel-data [_ system funnel-step funnel-step-s12n company customer campaign-customer data]
    ""))

(defprotocol IFunnelRetrieveFunnelData
  (retrieve-funnel-data [_ s12n config-data db company campaign customer campaign-customer context]))

(defprotocol IFunnelStepConfigurationDependencies
  (step-configuration-dependencies [_ config-data]
    "Returns a list of (keywords) system configurations necessary to operate"))


(defprotocol IFunnelRenderVariables
  (render-variables [_ s12n config-data system company campaign customer campaign-customer context]))

(defprotocol IFunnelExecuteAction
  (execute-action [_ s12n system db company campaign customer campaign-customer funnel-node trace trail context]))

(defprotocol IFunnelRestRequest
  (rest-request [_ system funnel-step funnel-step-s12n company campaign customer campaign-customer data context]))





