(ns {{project-ns}}.demo-route-test
  (:require [cljs.test :refer-macros [is are deftest testing use-fixtures]]
            [reagent.core :as reagent :refer [atom]]
            [{{project-ns}}.test-resources.utils :as utils]
            [{{project-ns}}.routes.demo-route :as sut]))

(deftest test-demo-page-id
  (is (utils/regex-found-in-component? #"id=\"header\"" (sut/demo-page))))

(deftest form-can-be-properly-updated-with-user-input
  (is (utils/regex-not-found-in-component? #"Some Random Text" (sut/demo-page)))
  (swap! sut/route-state assoc :form-input-field "Some Random Text")
  (sut/update-form-data-with-form-values)
  (is (utils/regex-found-in-component? #"Some Random Text" (sut/demo-page))))
