(ns {{project-ns}}.router
  (:require [secretary.core :as secretary :include-macros true]
            [{{project-ns}}.global-state :refer [global-app-state]]
            [{{project-ns}}.routes.index :refer [index-page]]
            [{{project-ns}}.routes.demo-route :refer [demo-page]]))

(defn app-routes []
  (secretary/set-config! :prefix "#")

  (secretary/defroute "/" []
    (swap! global-app-state assoc :page {:name :index}))

  (secretary/defroute "/demo/:id" [id]
    (swap! global-app-state assoc :page {:name :demo :params id})))

(defmulti page identity)
(defmethod page :index   [] index-page)
(defmethod page :demo    [] demo-page)
(defmethod page :default [] (fn [_] [:div [:img {:src "https://http.cat/404"}]]))
