#paper-elements

The paper elements are a set of UI components designed to implement Google's [material design](http://www.google.com/design/spec/material-design/introduction.html) guidelines.

## Roadmap

### Elements recently released

* [`paper-listbox`](https://github.com/polymerelements/paper-listbox) - An alternative to `paper-menu` with a different interface, with much better accessibility and performance.
* [`paper-menu-button`](https://github.com/polymerelements/paper-menu-button) - A button that opens up a menu overlay
* [`paper-tooltip`](https://github.com/polymerelements/paper-tooltip) - A tooltip that shows on hover
* [`paper-badge`](https://github.com/polymerelements/paper-badge) - A circular text badge representing a status or notification
* [`paper-card`](https://github.com/polymerelements/paper-card) - A material design-style card
* [`paper-dropdown-menu`](https://github.com/polymerelements/paper-dropdown-menu) - A material design-style browser select element
* [`paper-submenu`](https://github.com/polymerelements/paper-menu) - A material design-style menu with nestable subsections 

### Elements in progress

We're currently working hard on honing existing elements and fixing open issues. 

### Elements planned
_Elements we're planning on building soon but haven't started yet_

**Short-term**
_Nothing on the super short-term list_

**Mid-term**
* `paper-bottom-sheet` - a [material design bottom sheet](https://www.google.com/design/spec/components/bottom-sheets.html) this can easily be created with `neon-animation` ([example](https://googlewebcomponents.github.io/places-app/))
* `paper date and time pickers` - [material design date and time pickers](https://www.google.com/design/spec/components/pickers.html#)
* `paper steppers` - [material design steppers](https://www.google.com/design/spec/components/steppers.html#)

**Longer term**
* `paper-chip` - a [material design chip](http://www.google.com/design/spec/components/chips.html)
* `paper-data-table` - a [material design data table](http://www.google.com/design/spec/components/data-tables.html). This one is very complex, and tentatively planned for the mid- to distant-future (i.e. months not weeks)

### Elements not planned, notably
_Elements we're not planning on building as part of this product line, but that one might be wondering about_

* `paper-shadow` - this behavior is now provided by [`paper-material`](https://github.com/polymerelements/paper-material)
