(ns leiningen.polylith.cmd.help.compile
  (:require [leiningen.polylith.cmd.shared :as shared]))

(defn help []
  (println "  Compiles changes since a specific point in time.")
  (println)
  (println "  The following steps are performed:")
  (println "    - checks for circular dependencies and stops if found.")
  (println "    - calculates what components and bases to process based on what has")
  (println "      changed since the last successful test or build.")
  (println "    - calls 'sync' and makes sure that all dependencies in project.clj")
  (println "      files are in sync and that all systems have all components they need.")
  (println "    - AOT compile changed components, bases and systems to check that they compile")
  (println "      and fulfill workspace interfaces and have all libraries they need.")
  (println)
  (println "  lein polylith compile [ARG]")
  (println "    ARG = (omitted) -> Since last successful test or build, stored in bookmark")
  (println "                       :last-success in WS-ROOT/.polylith/time.edn")
  (println "                       or :last-success in WS-ROOT/.polylith/git.edn")
  (println "                       if you have the CI variable set to something on the machine.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          git-hash  -> Since the given git hash if the CI variable is set.")
  (println "          bookmark  -> Since the timestamp for the given bookmark in")
  (println "                       WS-ROOT/.polylith/time.edn or since the git hash")
  (println "                       for the given bookmark in WS-ROOT/.polylith/git.edn")
  (println "                       if the CI variable is set.")
  (println)
  (println "    SKIP = (omitted)      -> Executes all steps.")
  (println "           -circular-deps -> Skips checking for circular dependencies step.")
  (println "           -sync           -> Skips dependency sync step.")
  (println)
  (println "  'lein polylith compile 0' can be used to compile all files in the workspace")
  (println "  (or at least changes since 1970-01-01).")
  (println)
  (println "  example:")
  (println "    lein polylith compile")
  (println "    lein polylith compile -sync")
  (if (shared/ci?)
    (println "    lein polylith compile 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
    (println "    lein polylith compile 1523649477000"))
  (println "    lein polylith compile mybookmark")
  (println "    lein polylith compile mybookmark -sync"))
