(ns leiningen.polylith.cmd.help.compile)

(defn help []
  (println "  Compile changes since a specific point in time.")
  (println)
  (println "  lein polylith compile [ARG]")
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.edn. or")
  (println "                       :last-successful-build in WS-ROOT/.polylith/git.edn if")
  (println "                       you have CI variable set to something on the machine.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          git-hash  -> Since the given git hash if CI variable set.")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.edn or")
  (println "                       since the git hash for the given bookmark in WS-ROOT/.polylith/git.edn if CI")
  (println "                       variable set.")
  (println)
  (println "  example:")
  (println "    lein polylith compile")
  (println "    lein polylith compile 1523649477000")
  (println "    lein polylith compile 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
  (println "    lein polylith compile mybookmark"))
