(ns leiningen.polylith.cmd.help.compile)

(defn help []
  (println "  Compile changes since a specific point in time.")
  (println)
  (println "  lein polylith compile PREFIX [ARG]")
  (println "    PREFIX = (omitted) -> Uses time.local.edn")
  (println "             prefix    -> Uses given prefix as time.PREFIX.edn.")
  (println)
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.local.edn.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.local.edn.")
  (println)
  (println "  example:")
  (println "    lein polylith compile")
  (println "    lein polylith compile local")
  (println "    lein polylith compile remote")
  (println "    lein polylith compile local 1523649477000")
  (println "    lein polylith compile remote mybookmark"))
