(ns leiningen.polylith.cmd.help.diff)

(defn help []
  (println "  List all files and directories that has been changed in the workspace")
  (println "  since a specific point in time.")
  (println)
  (println "  lein polylith diff PREFIX [ARG] [FLAG]")
  (println "    PREFIX = (omitted) -> Uses time.local.edn")
  (println "             prefix    -> Uses given prefix as time.PREFIX.edn.")
  (println)
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.local.edn.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.local.edn.")
  (println)
  (println "    FLAG = +        -> Show time information.")
  (println "                       (the + sign may occur in any order in the argument list).")
  (println)
  (println "   'lein polylith diff 0' can be used to list all files in the workspace.")
  (println)
  (println "  example:")
  (println "    lein polylith diff")
  (println "    lein polylith diff local")
  (println "    lein polylith diff remote")
  (println "    lein polylith diff local +")
  (println "    lein polylith diff remote +")
  (println "    lein polylith diff local + 1523649477000")
  (println "    lein polylith diff local 1523649477000")
  (println "    lein polylith diff local 1523649477000 +")
  (println "    lein polylith diff local mybookmark"))
