(ns polylith.clj.core.help.info
     (:require [polylith.clj.core.help.shared :as s]
               [polylith.clj.core.help.shared :as shared]
               [polylith.clj.core.util.interface.color :as color]))

(defn help-text [cm]
  (str "  Shows workspace information.\n"
       "\n"
       "  poly info [" (s/key "ARGS" cm) "]\n"
       "    ARGS = " (s/key ":loc" cm) " -> Shows the number of lines of code.
"      "\n"
       "  In addition to " (s/key ":loc" cm) ", all the arguments used by the 'test' command\n"
       "  can also be used as a way to see what tests will be executed.\n"
       "\n"
       "    stable since: " (color/grey cm "dec73ec | stable-lisa\n")
       "\n"
       "    " (color/environment "environments:" cm) " 2   " (color/interface "interfaces:" cm) " 3\n"
       "    " (color/base "bases:" cm) "        1   " (color/component "components:" cm) " 4\n"
       "\n"
       "    active profiles: " (color/profile "default" cm) "\n"
       "\n"
       "    environment   alias  source   " (color/profile "default  admin" cm) "\n"
       "    ---------------------------   --------------\n"
       "    " (color/environment "command-line  cl      ---       --      --" cm) "\n"
       "    " (color/environment "development   dev     x--       --      --" cm) "\n"
       "\n"
       "    interface  brick    " (color/environment "cl    dev  admin\n" cm)
       "    -----------------   ---   ----------\n"
       "    " (color/interface "payer" cm) "      " (color/component "payer" cm) "    " (color/environment "x--   xx-   --" cm) "\n"
       "    " (color/interface "user" cm) "       " (color/component "admin" cm) "    " (color/environment "x--   ---   xx" cm) "\n"
       "    " (color/interface "user" cm) "       " (color/component "user" cm) " *   " (color/environment "---   xx-   --" cm) "\n"
       "    " (color/interface "util" cm) "       " (color/component "util" cm) "     " (color/environment "x--   xx-   --" cm) "\n"
       "    -          " (color/base "cli" cm) "      " (color/environment "x--   xx-   --" cm) "\n"
       "\n"
       "  This example shows a sample project. Let's go through each section:\n"
       "\n"
       "  1. stable since: " (color/grey cm "dec73ec | stable-lisa\n")
       "\n"
       "     This shows the first commit or the most recent commit marked as stable,\n"
       "     including the tag name. More information can be found in the 'diff' command help.\n"
       "\n"
       "  2. " (color/environment "environments:" cm) " 2   " (color/interface "interfaces:" cm) " 3\n"
       "     " (color/base "bases:" cm) "        1   " (color/component "components:" cm) " 4\n"
       "\n"
       "     Shows how many " (color/environment "environments" cm) ", " (color/base "bases" cm) ", " (color/component "components" cm) " and " (color/interface "interfaces" cm) " there are in the workspace.\n"
       "\n"
       "  3. active profiles: " (color/profile "default" cm) "\n"
       "\n"
       "     Shows the names of active profiles. The profile paths are merged into the " (color/environment "development" cm) "\n"
       "     environment. A profiles is an aliase in ./deps.edn that starts with a " (color/purple cm "+") ". If no profile\n"
       "     is selected, the " (color/profile "default" cm) " profile is automatically selected.\n"
       "\n"
       "     Profiles are activated by passing them in by name (prefixed with '+'), e.g.:\n"
       "       poly info +admin\n"
       "\n"
       "  4. environment   alias  source   " (color/profile "default  admin" cm) "\n"
       "     ---------------------------   --------------\n"
       "     " (color/environment "command-line  cl      ---       --      --" cm) "\n"
       "     " (color/environment "development   dev     x--       --      --" cm) "\n"
       "\n"
       "    This table lists all environments. The 'environment' column shows the name of the\n"
       "    environments, which are the directory names under the 'environments' directory,\n"
       "    except for 'development' that stores its code under the 'development' directory.\n"
       "\n"
       "    The 'deps.edn' config files are stored under each environment, except for the development\n"
       "    enviroment that stores it at the workspace root.\n"
       "\n"
       "    Aliases are configured in " (color/purple cm ":env->alias") " in ./deps.edn.\n"
       "\n"
       "    The 'source' column has three x/- flags with different meaning:\n"
       "      x--  The environment has a 'src' directory, e.g. 'environments/command-line/src'.\n"
       "      -x-  The environment has a 'test' directory, e.g. 'environments/command-line/test'.\n"
       "      --x  The environment tests (its own) are marked for execution.\n"
       "\n"
       "    To show the 'resources' directory, also pass in :r or :resources, e.g. 'poly info :r':\n"
       "      x---  The environment has a 'src' directory, e.g. 'environments/command-line/src'.\n"
       "      -x--  The environment has a 'resources' directory, e.g. 'environments/command-line/resources'.\n"
       "      --x-  The environment has a 'test' directory, e.g. 'environments/command-line/test'.\n"
       "      ---x  The environment tests (its own) are marked for execution.\n"
       "\n"
       "    The last two columns, " (s/key "default admin" cm) ", are the profiles:\n"
       "      x-  The profile contains a path to the 'src' directory, e.g. 'environments/command-line/src'.\n"
       "      -x  The profile contains a path to the 'test' directory, e.g. 'environments/command-line/test'.\n"
       "\n"
       "    If also passing in :r or :resources, e.g. 'poly info +r':\n"
       "      x--  The profile contains a path to the 'src' directory, e.g. 'environments/command-line/src'.\n"
       "      -x-  The profile contains a path to the 'resources' directory, e.g. 'environments/command-line/resources'.\n"
       "      --x  The profile contains a path to the 'test' directory, e.g. 'environments/command-line/test'.\n"
       "\n"
       "  5. interface  brick    " (color/environment "cl    dev  admin\n" cm)
       "     -----------------   ---   ----------\n"
       "     " (color/interface "payer" cm) "      " (color/component "payer" cm) "    " (color/environment "x--   xx-   --" cm) "\n"
       "     " (color/interface "user" cm) "       " (color/component "admin" cm) "    " (color/environment "x--   ---   xx" cm) "\n"
       "     " (color/interface "user" cm) "       " (color/component "user" cm) " *   " (color/environment "---   xx-   --" cm) "\n"
       "     " (color/interface "util" cm) "       " (color/component "util" cm) "     " (color/environment "x--   xx-   --" cm) "\n"
       "     -          " (color/base "cli" cm) "      " (color/environment "x--   xx-   --" cm) "\n"
       "\n"
       "    This table lists all bricks and in which environments and profiles they are added to.\n"
       "\n"
       "    The 'interface' column shows what " (color/interface "interface" cm) " the component has. The name is the first\n"
       "    namespace after the component name, e.g.: " (shared/component-ns "interface" "user" cm) ".\n"
       "\n"
       "    The 'brick' column shows the name of the brick. In " (color/component "green" cm) " if a component or " (color/base "blue" cm) " if a base" ".\n"
       "    Each component lives in a directory under the 'components' directory and each base lives\n"
       "    under the 'bases' directory. If any file for a brick has changed since the last stable\n"
       "    point in time, it will be marked with an asterisk, * (" (color/component "user" cm) " in this example).\n"
       "\n"
       "    The changed files can be listed by executing 'poly diff'.\n"
       "\n"
       "    The next " (color/environment "cl" cm) " column is the " (color/environment "command-line" cm) " environment that lives under the 'environments' directory.\n"
       "    Each line in this column says whether a brick is included in the environment or not.\n"
       "\n"
       "    The flags mean:\n"
       "      x--  The environment contains a path to the 'src' directory, e.g. 'components/user/src'.\n"
       "      -x-  The environment contains a path to the 'test' directory, e.g. 'components/user/test'.\n"
       "      --x  The brick is marked to be executed from this environment.\n"
       "\n"
       "    If :r or :resources is also passed in:\n"
       "      x---  The environment contains a path to the 'src' directory, e.g. 'components/user/src'.\n"
       "      -x--  The environment contains a path to the 'resources' directory, e.g. 'components/user/resources'.\n"
       "      --x-  The environment contains a path to the 'test' directory, e.g. 'components/user/test'.\n"
       "      ---x  The brick is marked to be executed from this environment.\n"
       "\n"
       "    The next group of columns, " (color/environment "dev admin" cm) ", is the development environment with its profiles.\n"
       "    If passing in a plus with 'poly info +' then it will also show the " (color/profile "default" cm) " profile.\n"
       "    The flags for the " (color/environment "dev" cm) " environment works the same as for " (color/environment "cl" cm) ".\n"
       "\n"
       "    The flags for the " (color/profile "admin" cm) " profile means:\n"
       "      x-  The profile contains a path to the 'src' directory, e.g. 'components/user/src'.\n"
       "      -x  The profile contains a path to the 'test' directory, e.g. 'components/user/test'.\n"
       "\n"
       "    If :r or :resources is also passed in:\n"
       "      x--  The profile contains a path to the 'src' directory, e.g. 'components/user/src'.\n"
       "      -x-  The profile contains a path to the 'resources' directory, e.g. 'components/user/resources'.\n"
       "      --x  The profile contains a path to the 'test' directory, e.g. 'components/user/test'.\n"
       "\n"
       "  It's not enough that a path has been added to an environment to show an 'x', the file or directory\n"
       "  must also exist.\n"
       "\n"
       "  If any warnings or errors was found in the workspace, they will be listed at the end,\n"
       "  see the 'check' command help, for a complete list of validations.\n"
       "\n"
       "  Example:\n"
       "    poly info\n"
       "    poly info :loc\n"
       "    poly info env:myenv\n"
       "    poly info env:myenv:another-env\n"
       "    poly info :env\n"
       "    poly info :dev\n"
       "    poly info :env :dev\n"
       "    poly info :all\n"
       "    poly info :all-bricks\n"
       "    poly info ws-dir:another-ws\n"))

(defn print-help [color-mode]
  (println (help-text color-mode)))
