(ns polylith.clj.core.help.check
  (:require [polylith.clj.core.help.shared :as shared]
            [polylith.clj.core.util.interface.color :as color]))

(defn help-text [cm]
  (str "  Validates the workspace.\n"
       "\n"
       "  poly check\n"
       "\n"
       "  Prints 'OK' and returns 0 if no errors was found.\n"
       "  If errors or warnings was found, show messages and return the error code, or 0 if only warnings.\n"
       "  If internal errors, 1 is returned.\n"
       "\n"
       "  " (color/error cm "Error 101") " - Illegal dependency on namespace.\n"
       "    Triggered if a " (color/purple cm ":require") " statement refers to a component namespace other than " (color/interface "interface" cm) ".\n"
       "    Examples of valid namespaces:\n"
       "     - " (shared/component-ns "interface" cm) "\n"
       "     - " (shared/component-ns "interface.subns" cm) "\n"
       "     - " (shared/component-ns "interface.my.subns" cm) "\n"
       "\n"
       "  " (color/error cm "Error 102") " - Function or macro is defined twice.\n"
       "    Triggered if a function or macro is defined twice in the same namespace.\n"
       "\n"
       "  " (color/error cm "Error 103") " - Missing definitions.\n"
       "    Triggered if a " (color/green cm "def") ", " (color/green cm "defn") " or "
       (color/green cm "defmacro") " definition exists in one component's interface\n"
       "    but is missing in another component that uses the same interface.\n"
       "\n"
       "  " (color/error cm "Error 104") " - Circular dependencies.\n"
       "    Triggered if circular dependencies were detected, e.g.:\n"
       "    Component A depends on B that depends on A (A > B > A), or A > B > C > A.\n"
       "\n"
       "  " (color/error cm "Error 105") " - Illegal name sharing.\n"
       "    Triggered if a base has the same name as a component or interface.\n"
       "    Environments and profiles can be given any name.\n"
       "\n"
       "  " (color/error cm "Error 106") " - Multiple components that share the same interfaces in an environment.\n"
       "    Triggered if an environment contains more than one component that shares the same interface.\n"
       "\n"
       "  " (color/error cm "Error 107") " - Missing components in environment.\n"
       "    Triggered if a component depends on an interface that is not included in the environment.\n"
       "    The solution is to add a component to the environment that implements the interface.\n"
       "\n"
       "  " (color/error cm "Error 108") " - Components with an interface that is implemented by more than one component\n"
       "              is not allowed for the development environment.\n"
       "    The solution is to remove the component from the development environment and define the paths \n"
       "    for each component in separate profiles (including test paths).\n"
       "\n"
       "  " (color/error cm "Error 109") " - Missing libraries in environment.\n"
       "    Triggered if an environment doesn't contain a library that is used by one of its bricks.\n"
       "    Library usage for a brick is calculated using " (color/purple cm ":ns->lib") " in './deps.edn' for all its namespaces.\n"
       "\n"
       "  " (color/warning cm "Warning 201") " - Mismatching parameter lists in function or macro.\n"
       "    Triggered if a function or macro is defined in the interface for a component but also defined\n"
       "    in the same interface for another component but with a different parameter list.\n"
       "\n"
       "  " (color/warning cm "Warning 202") " - Missing paths in environment.\n"
       "    Triggered if a path in an environment doesn't exist on disk.\n"
       "    The solution is to add the file or directory, or to remove the path.\n"
       "\n"
       "  " (color/warning cm "Warning 203") " - Path exists in both dev and profile.\n"
       "    It's discouraged to have the same path in both the development environment and a profile.\n"
       "    The solution is to remove the path from dev or the profile. \n"
       "\n"
       "  " (color/warning cm "Warning 204") " - Library exists in both dev and a profile.\n"
       "    It's discouraged to have the same library in both development and a profile.\n"
       "    The solution is to remove the library from dev or the profile.\n"
       "\n"
       "  " (color/warning cm "Warning 205") " - Reference to missing library in " (color/purple cm ":ns->lib") " in ./deps.edn.\n"
       "    Libraries defined in " (color/purple cm ":ns->lib") " should also be defined by the environment.\n"
       "\n"
       "  " (color/warning cm "Warning 206") " - Reference to missing namespace in " (color/purple cm ":ns->lib") " in ./deps.edn.\n"
       "    Namespaces defined in " (color/purple cm ":ns->lib") " should also exist in the environment."))

(defn print-help [cm]
  (-> cm help-text println))
