(ns polylith.clj.core.help.summary
  (:require [polylith.clj.core.help.shared :as s]
            [polylith.clj.core.util.interface.color :as color]))

(defn help-text [cm]
  (str
    "  Polylith - " (color/blue cm "https://github.com/polyfy/polylith\n")
    "\n"
    "  poly " (s/key "CMD" cm) " [" (s/key "ARGS" cm) "] - where " (s/key "CMD" cm) " [" (s/key "ARGS" cm) "] are:\n"
    "\n"
    "    check                   Checks if the workspace is valid.\n"
    "    create " (s/key "E" cm) " name:" (s/key "N" cm) " [" (s/key "ARG" cm) "]   Creates a component, base, environment or workspace.\n"
    "    deps [env:" (s/key "E" cm) "] [brick:" (s/key "B" cm) "]  Shows dependencies.\n"
    "    diff                    Shows changed files since last stable point in time.\n"
    "    help [" (s/key "C" cm) "] [" (s/key "ARG" cm) "]          Shows this help or help for a specified command.\n"
    "    info [" (s/key "ARGS" cm) "]             Shows a workspace overview and checks if it's valid.\n"
    "    libs                    Shows all libraries in the workspace.\n"
    "    test [" (s/key "ARGS" cm) "]             Runs tests.\n"
    "    ws [get:" (s/key "X" cm) "]              Shows the workspace as data.\n"
    "\n"
    "  If ws-dir:" (s/key "PATH" cm) " is passed in as an argument, where " (s/key "PATH" cm) " is a relative or absolute\n"
    "  path, then the command is executed from that directory. If " (s/key "::" cm) " is passed in, then\n"
    "  ws-dir is set to the first parent directory (or current) that contains a 'deps.edn'\n"
    "  workspace config file. The exception is the 'test' command that has to be executed\n"
    "  from the workspace root.\n"
    "  The color mode can be overridden by passing in e.g. " (s/key "color-mode:none" cm) " (valid values: \n"
    "  " (s/key "none" cm) ", " (s/key "light" cm) ", " (s/key "dark" cm) ") which is otherwise configured in ~/.polylith/config.edn.\n"
    "\n"
    "  Example:\n"
    "    poly check\n"
    "    poly create c name:user\n"
    "    poly create c name:admin interface:user\n"
    "    poly create b name:mybase\n"
    "    poly create e name:myenv\n"
    "    poly create w name:myws top-ns:com.my.company\n"
    "    poly deps\n"
    "    poly deps env:myenv\n"
    "    poly deps brick:mybrick\n"
    "    poly deps env:myenv brick:mybrick\n"
    "    poly diff\n"
    "    poly help\n"
    "    poly help info\n"
    "    poly help create\n"
    "    poly help create c\n"
    "    poly help create b\n"
    "    poly help create e\n"
    "    poly help create w\n"
    "    poly help deps\n"
    "    poly help deps :env\n"
    "    poly help deps :brick\n"
    "    poly help deps :env :brick\n"
    "    poly info\n"
    "    poly info :loc\n"
    "    poly info env:myenv\n"
    "    poly info env:myenv:another-env\n"
    "    poly info :env\n"
    "    poly info :dev\n"
    "    poly info :env :dev\n"
    "    poly info :all\n"
    "    poly info :all-bricks\n"
    "    poly info ::\n"
    "    poly info color-mode:none\n"
    "    poly info ws-dir:another-ws\n"
    "    poly libs\n"
    "    poly test\n"
    "    poly test env:myenv\n"
    "    poly test env:myenv:another-env\n"
    "    poly test :env\n"
    "    poly test :dev\n"
    "    poly test :env :dev\n"
    "    poly test :all\n"
    "    poly test :all-bricks\n"
    "    poly ws\n"
    "    poly ws get:keys\n"
    "    poly ws get:count\n"
    "    poly ws get:settings\n"
    "    poly ws get:settings:user-input:args\n"
    "    poly ws get:settings:user-input:args:0\n"
    "    poly ws get:settings:keys\n"
    "    poly ws get:components:keys\n"
    "    poly ws get:components:count\n"
    "    poly ws get:components:user:lines-of-code-src"))

(defn print-help [color-mode]
  (println (help-text color-mode)))
