/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

abstract class AbstractSisuIndex {
    static final String INDEX_FOLDER = "META-INF/sisu/";
    static final String QUALIFIER = "javax.inject.Qualifier";
    static final String NAMED = "javax.inject.Named";
    private final Map<Object, Set<String>> index = new LinkedHashMap<Object, Set<String>>();

    AbstractSisuIndex() {
    }

    protected final synchronized void addClassToIndex(Object anno, Object clazz) {
        Set<String> table = this.index.get(anno);
        if (table == null) {
            table = this.readTable(anno);
            this.index.put(anno, table);
        }
        table.add(String.valueOf(clazz));
    }

    protected final synchronized void flushIndex() {
        for (Map.Entry<Object, Set<String>> entry : this.index.entrySet()) {
            this.writeTable(entry.getKey(), entry.getValue());
        }
    }

    protected abstract void info(String var1);

    protected abstract void warn(String var1);

    protected abstract Reader getReader(String var1) throws IOException;

    protected abstract Writer getWriter(String var1) throws IOException;

    private Set<String> readTable(Object name2) {
        TreeSet<String> table = new TreeSet<String>();
        try {
            BufferedReader reader2 = new BufferedReader(this.getReader(INDEX_FOLDER + name2));
            try {
                String line2 = reader2.readLine();
                while (line2 != null) {
                    table.add(line2);
                    line2 = reader2.readLine();
                }
            }
            finally {
                reader2.close();
            }
        }
        catch (IOException iOException) {}
        return table;
    }

    private void writeTable(Object name2, Set<String> table) {
        try {
            BufferedWriter writer2 = new BufferedWriter(this.getWriter(INDEX_FOLDER + name2));
            try {
                for (String line2 : table) {
                    writer2.write(line2);
                    writer2.newLine();
                }
            }
            finally {
                writer2.close();
            }
        }
        catch (IOException e2) {
            this.warn(e2.toString());
        }
    }
}

