/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.NonceGenerator;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.PushCertificateIdent;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.SignedPushConfig;
import org.eclipse.jgit.util.IO;

public class PushCertificateParser {
    static final String BEGIN_SIGNATURE = "-----BEGIN PGP SIGNATURE-----";
    static final String END_SIGNATURE = "-----END PGP SIGNATURE-----";
    static final String VERSION = "certificate version";
    static final String PUSHER = "pusher";
    static final String PUSHEE = "pushee";
    static final String NONCE = "nonce";
    static final String END_CERT = "push-cert-end";
    private static final String VERSION_0_1 = "0.1";
    private boolean received;
    private String version;
    private PushCertificateIdent pusher;
    private String pushee;
    private String sentNonce;
    private String receivedNonce;
    private PushCertificate.NonceStatus nonceStatus;
    private String signature;
    private final Repository db;
    private final int nonceSlopLimit;
    private final boolean enabled;
    private final NonceGenerator nonceGenerator;
    private final List<ReceiveCommand> commands = new ArrayList<ReceiveCommand>();

    public static PushCertificate fromReader(Reader r) throws PackProtocolException, IOException {
        return new PushCertificateParser().parse(r);
    }

    public static PushCertificate fromString(String str2) throws PackProtocolException, IOException {
        return PushCertificateParser.fromReader(new java.io.StringReader(str2));
    }

    public PushCertificateParser(Repository into2, SignedPushConfig cfg) {
        if (cfg != null) {
            this.nonceSlopLimit = cfg.getCertNonceSlopLimit();
            this.nonceGenerator = cfg.getNonceGenerator();
        } else {
            this.nonceSlopLimit = 0;
            this.nonceGenerator = null;
        }
        this.db = into2;
        this.enabled = this.nonceGenerator != null;
    }

    private PushCertificateParser() {
        this.db = null;
        this.nonceSlopLimit = 0;
        this.nonceGenerator = null;
        this.enabled = true;
    }

    public PushCertificate parse(Reader r) throws PackProtocolException, IOException {
        StreamReader reader2 = new StreamReader(r);
        this.receiveHeader(reader2, true);
        try {
            String line2;
            while (!(line2 = reader2.read()).isEmpty()) {
                if (line2.equals(BEGIN_SIGNATURE)) {
                    this.receiveSignature(reader2);
                    break;
                }
                this.addCommand(line2);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return this.build();
    }

    public PushCertificate build() throws IOException {
        if (!this.received || !this.enabled) {
            return null;
        }
        try {
            return new PushCertificate(this.version, this.pusher, this.pushee, this.receivedNonce, this.nonceStatus, Collections.unmodifiableList(this.commands), this.signature);
        }
        catch (IllegalArgumentException e2) {
            throw new IOException(e2.getMessage(), e2);
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String getAdvertiseNonce() {
        String nonce = this.sentNonce();
        if (nonce == null) {
            return null;
        }
        return "push-cert=" + nonce;
    }

    private String sentNonce() {
        if (this.sentNonce == null && this.nonceGenerator != null) {
            this.sentNonce = this.nonceGenerator.createNonce(this.db, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        }
        return this.sentNonce;
    }

    private static String parseHeader(StringReader reader2, String header) throws IOException {
        return PushCertificateParser.parseHeader(reader2.read(), header);
    }

    private static String parseHeader(String s2, String header) throws IOException {
        if (s2.isEmpty()) {
            throw new EOFException();
        }
        if (s2.length() <= header.length() || !s2.startsWith(header) || s2.charAt(header.length()) != ' ') {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, header));
        }
        return s2.substring(header.length() + 1);
    }

    public void receiveHeader(PacketLineIn pckIn, boolean stateless) throws IOException {
        this.receiveHeader(new PacketLineReader(pckIn), stateless);
    }

    private void receiveHeader(StringReader reader2, boolean stateless) throws IOException {
        try {
            try {
                this.version = PushCertificateParser.parseHeader(reader2, VERSION);
            }
            catch (EOFException e2) {
                return;
            }
            this.received = true;
            if (!this.version.equals(VERSION_0_1)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidFieldValue, VERSION, this.version));
            }
            String rawPusher = PushCertificateParser.parseHeader(reader2, PUSHER);
            this.pusher = PushCertificateIdent.parse(rawPusher);
            if (this.pusher == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidFieldValue, PUSHER, rawPusher));
            }
            String next2 = reader2.read();
            if (next2.startsWith(PUSHEE)) {
                this.pushee = PushCertificateParser.parseHeader(next2, PUSHEE);
                this.receivedNonce = PushCertificateParser.parseHeader(reader2, NONCE);
            } else {
                this.receivedNonce = PushCertificateParser.parseHeader(next2, NONCE);
            }
            PushCertificate.NonceStatus nonceStatus = this.nonceStatus = this.nonceGenerator != null ? this.nonceGenerator.verify(this.receivedNonce, this.sentNonce(), this.db, stateless, this.nonceSlopLimit) : PushCertificate.NonceStatus.UNSOLICITED;
            if (!reader2.read().isEmpty()) {
                throw new PackProtocolException(JGitText.get().pushCertificateInvalidHeader);
            }
        }
        catch (EOFException eof) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidHeader, eof);
        }
    }

    public void receiveSignature(PacketLineIn pckIn) throws IOException {
        PacketLineReader reader2 = new PacketLineReader(pckIn);
        this.receiveSignature(reader2);
        if (!reader2.read().equals(END_CERT)) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidSignature);
        }
    }

    private void receiveSignature(StringReader reader2) throws IOException {
        this.received = true;
        try {
            String line2;
            StringBuilder sig = new StringBuilder(BEGIN_SIGNATURE).append('\n');
            while (!(line2 = reader2.read()).equals(END_SIGNATURE)) {
                sig.append(line2).append('\n');
            }
            this.signature = sig.append(END_SIGNATURE).append('\n').toString();
        }
        catch (EOFException eof) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidSignature, eof);
        }
    }

    public void addCommand(ReceiveCommand cmd) {
        this.commands.add(cmd);
    }

    public void addCommand(String line2) throws PackProtocolException {
        this.commands.add(BaseReceivePack.parseCommand(line2));
    }

    private static class PacketLineReader
    implements StringReader {
        private final PacketLineIn pckIn;

        private PacketLineReader(PacketLineIn pckIn) {
            this.pckIn = pckIn;
        }

        @Override
        public String read() throws IOException {
            return this.pckIn.readString();
        }
    }

    private static class StreamReader
    implements StringReader {
        private final Reader reader;

        private StreamReader(Reader reader2) {
            this.reader = reader2;
        }

        @Override
        public String read() throws IOException {
            String line2 = IO.readLine(this.reader, 146);
            if (line2.isEmpty()) {
                throw new EOFException();
            }
            if (line2.charAt(line2.length() - 1) == '\n') {
                line2 = line2.substring(0, line2.length() - 1);
            }
            return line2;
        }
    }

    private static interface StringReader {
        public String read() throws EOFException, IOException;
    }
}

