/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschSession;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JschConfigSessionFactory
extends SshSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JschConfigSessionFactory.class);
    private final Map<String, JSch> byIdentityFile = new HashMap<String, JSch>();
    private JSch defaultJSch;
    private OpenSshConfig config;

    @Override
    public synchronized RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs2, int tms) throws TransportException {
        String user = uri.getUser();
        String pass = uri.getPass();
        String host = uri.getHost();
        int port = uri.getPort();
        try {
            if (this.config == null) {
                this.config = OpenSshConfig.get(fs2);
            }
            OpenSshConfig.Host hc = this.config.lookup(host);
            host = hc.getHostName();
            if (port <= 0) {
                port = hc.getPort();
            }
            if (user == null) {
                user = hc.getUser();
            }
            Session session = this.createSession(credentialsProvider, fs2, user, pass, host, port, hc);
            int retries = 0;
            while (!session.isConnected()) {
                try {
                    ++retries;
                    session.connect(tms);
                }
                catch (JSchException e2) {
                    session.disconnect();
                    session = null;
                    JschConfigSessionFactory.knownHosts(this.getJSch(hc, fs2), fs2);
                    if (JschConfigSessionFactory.isAuthenticationCanceled(e2)) {
                        throw e2;
                    }
                    if (JschConfigSessionFactory.isAuthenticationFailed(e2) && credentialsProvider != null) {
                        if (retries < 3) {
                            credentialsProvider.reset(uri);
                            session = this.createSession(credentialsProvider, fs2, user, pass, host, port, hc);
                            continue;
                        }
                        throw e2;
                    }
                    if (retries >= hc.getConnectionAttempts()) {
                        throw e2;
                    }
                    try {
                        Thread.sleep(1000L);
                        session = this.createSession(credentialsProvider, fs2, user, pass, host, port, hc);
                    }
                    catch (InterruptedException e1) {
                        throw new TransportException(JGitText.get().transportSSHRetryInterrupt, e1);
                    }
                }
            }
            return new JschSession(session, uri);
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(uri, JGitText.get().unknownHost, je);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(uri, c.getMessage(), je);
            }
            throw new TransportException(uri, je.getMessage(), je);
        }
    }

    private static boolean isAuthenticationFailed(JSchException e2) {
        return e2.getCause() == null && e2.getMessage().equals("Auth fail");
    }

    private static boolean isAuthenticationCanceled(JSchException e2) {
        return e2.getCause() == null && e2.getMessage().equals("Auth cancel");
    }

    private Session createSession(CredentialsProvider credentialsProvider, FS fs2, String user, String pass, String host, int port, OpenSshConfig.Host hc) throws JSchException {
        String pauth;
        String strictHostKeyCheckingPolicy;
        Session session = this.createSession(hc, user, host, port, fs2);
        this.setUserName(session, user);
        session.setConfig("MaxAuthTries", "1");
        if (pass != null) {
            session.setPassword(pass);
        }
        if ((strictHostKeyCheckingPolicy = hc.getStrictHostKeyChecking()) != null) {
            session.setConfig("StrictHostKeyChecking", strictHostKeyCheckingPolicy);
        }
        if ((pauth = hc.getPreferredAuthentications()) != null) {
            session.setConfig("PreferredAuthentications", pauth);
        }
        if (!(credentialsProvider == null || hc.isBatchMode() && credentialsProvider.isInteractive())) {
            session.setUserInfo(new CredentialsProviderUserInfo(session, credentialsProvider));
        }
        this.configure(hc, session);
        return session;
    }

    private void setUserName(Session session, String userName) {
        if (userName == null || userName.isEmpty() || userName.equals(session.getUserName())) {
            return;
        }
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Method method = Session.class.getDeclaredMethod("setUserName", parameterTypes);
            method.setAccessible(true);
            method.invoke((Object)session, userName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException e2) {
            LOG.error(MessageFormat.format(JGitText.get().sshUserNameError, userName, session.getUserName()), e2);
        }
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs2) throws JSchException {
        return this.getJSch(hc, fs2).getSession(user, host, port);
    }

    protected void configureJSch(JSch jsch) {
    }

    protected abstract void configure(OpenSshConfig.Host var1, Session var2);

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs2) throws JSchException {
        File identityFile;
        if (this.defaultJSch == null) {
            this.defaultJSch = this.createDefaultJSch(fs2);
            if (this.defaultJSch.getConfigRepository() == null) {
                this.defaultJSch.setConfigRepository(this.config);
            }
            for (Object name2 : this.defaultJSch.getIdentityNames()) {
                this.byIdentityFile.put((String)name2, this.defaultJSch);
            }
        }
        if ((identityFile = hc.getIdentityFile()) == null) {
            return this.defaultJSch;
        }
        String identityKey = identityFile.getAbsolutePath();
        JSch jsch = this.byIdentityFile.get(identityKey);
        if (jsch == null) {
            jsch = new JSch();
            this.configureJSch(jsch);
            if (jsch.getConfigRepository() == null) {
                jsch.setConfigRepository(this.defaultJSch.getConfigRepository());
            }
            jsch.setHostKeyRepository(this.defaultJSch.getHostKeyRepository());
            jsch.addIdentity(identityKey);
            this.byIdentityFile.put(identityKey, jsch);
        }
        return jsch;
    }

    protected JSch createDefaultJSch(FS fs2) throws JSchException {
        JSch jsch = new JSch();
        this.configureJSch(jsch);
        JschConfigSessionFactory.knownHosts(jsch, fs2);
        JschConfigSessionFactory.identities(jsch, fs2);
        return jsch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void knownHosts(JSch sch, FS fs2) throws JSchException {
        File home = fs2.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try (FileInputStream in = new FileInputStream(known_hosts);){
            sch.setKnownHosts(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void identities(JSch sch, FS fs2) {
        File home = fs2.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        if (sshdir.isDirectory()) {
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "identity"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_rsa"));
            JschConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_dsa"));
        }
    }

    private static void loadIdentity(JSch sch, File priv) {
        if (priv.isFile()) {
            try {
                sch.addIdentity(priv.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }
}

