/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;

public class NotesMergeConflictException
extends IOException {
    private static final long serialVersionUID = 1L;

    public NotesMergeConflictException(Note base2, Note ours, Note theirs) {
        super(MessageFormat.format(JGitText.get().mergeConflictOnNotes, NotesMergeConflictException.noteOn(base2, ours, theirs), NotesMergeConflictException.noteData(base2), NotesMergeConflictException.noteData(ours), NotesMergeConflictException.noteData(theirs)));
    }

    public NotesMergeConflictException(NonNoteEntry base2, NonNoteEntry ours, NonNoteEntry theirs) {
        super(MessageFormat.format(JGitText.get().mergeConflictOnNonNoteEntries, NotesMergeConflictException.name(base2), NotesMergeConflictException.name(ours), NotesMergeConflictException.name(theirs)));
    }

    private static String noteOn(Note base2, Note ours, Note theirs) {
        if (base2 != null) {
            return base2.name();
        }
        if (ours != null) {
            return ours.name();
        }
        return theirs.name();
    }

    private static String noteData(Note n) {
        if (n != null) {
            return n.getData().name();
        }
        return "";
    }

    private static String name(NonNoteEntry e2) {
        return e2 != null ? e2.name() : "";
    }
}

