/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryPackParser;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.file.WriteConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.sha1.SHA1;

class ObjectDirectoryInserter
extends ObjectInserter {
    private final FileObjectDatabase db;
    private final WriteConfig config;
    private Deflater deflate;

    ObjectDirectoryInserter(FileObjectDatabase dest, Config cfg) {
        this.db = dest;
        this.config = cfg.get(WriteConfig.KEY);
    }

    @Override
    public ObjectId insert(int type2, byte[] data2, int off, int len) throws IOException {
        return this.insert(type2, data2, off, len, false);
    }

    private ObjectId insert(int type2, byte[] data2, int off, int len, boolean createDuplicate) throws IOException {
        ObjectId id = this.idFor(type2, data2, off, len);
        if (!createDuplicate && this.db.has(id)) {
            return id;
        }
        File tmp = this.toTemp(type2, data2, off, len);
        return this.insertOneObject(tmp, id, createDuplicate);
    }

    @Override
    public ObjectId insert(int type2, long len, InputStream is2) throws IOException {
        return this.insert(type2, len, is2, false);
    }

    ObjectId insert(int type2, long len, InputStream is2, boolean createDuplicate) throws IOException {
        if (len <= (long)this.buffer().length) {
            byte[] buf = this.buffer();
            int actLen = IO.readFully(is2, buf, 0);
            return this.insert(type2, buf, 0, actLen, createDuplicate);
        }
        SHA1 md = this.digest();
        File tmp = this.toTemp(md, type2, len, is2);
        ObjectId id = md.toObjectId();
        return this.insertOneObject(tmp, id, createDuplicate);
    }

    private ObjectId insertOneObject(File tmp, ObjectId id, boolean createDuplicate) throws IOException, ObjectWritingException {
        switch (this.db.insertUnpackedObject(tmp, id, createDuplicate)) {
            case INSERTED: 
            case EXISTS_PACKED: 
            case EXISTS_LOOSE: {
                return id;
            }
        }
        File dst = this.db.fileFor(id);
        throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToCreateNewObject, dst));
    }

    @Override
    public PackParser newPackParser(InputStream in) throws IOException {
        return new ObjectDirectoryPackParser(this.db, in);
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db, this);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.deflate != null) {
            try {
                this.deflate.end();
            }
            finally {
                this.deflate = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File toTemp(SHA1 md, int type2, long len, InputStream is2) throws IOException, FileNotFoundException, Error {
        boolean delete2 = true;
        File tmp = this.newTempFile();
        try {
            FileOutputStream fOut = new FileOutputStream(tmp);
            try {
                OutputStream out = fOut;
                if (this.config.getFSyncObjectFiles()) {
                    out = Channels.newOutputStream(fOut.getChannel());
                }
                DeflaterOutputStream cOut = this.compress(out);
                SHA1OutputStream dOut = new SHA1OutputStream(cOut, md);
                this.writeHeader(dOut, type2, len);
                byte[] buf = this.buffer();
                while (len > 0L) {
                    int n = is2.read(buf, 0, (int)Math.min(len, (long)buf.length));
                    if (n <= 0) {
                        throw ObjectDirectoryInserter.shortInput(len);
                    }
                    dOut.write(buf, 0, n);
                    len -= (long)n;
                }
                dOut.flush();
                cOut.finish();
            }
            finally {
                if (this.config.getFSyncObjectFiles()) {
                    fOut.getChannel().force(true);
                }
                fOut.close();
            }
            delete2 = false;
            File file2 = tmp;
            return file2;
        }
        finally {
            if (delete2) {
                FileUtils.delete(tmp, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File toTemp(int type2, byte[] buf, int pos, int len) throws IOException, FileNotFoundException {
        boolean delete2 = true;
        File tmp = this.newTempFile();
        try {
            FileOutputStream fOut = new FileOutputStream(tmp);
            try {
                OutputStream out = fOut;
                if (this.config.getFSyncObjectFiles()) {
                    out = Channels.newOutputStream(fOut.getChannel());
                }
                DeflaterOutputStream cOut = this.compress(out);
                this.writeHeader(cOut, type2, len);
                cOut.write(buf, pos, len);
                cOut.finish();
            }
            finally {
                if (this.config.getFSyncObjectFiles()) {
                    fOut.getChannel().force(true);
                }
                fOut.close();
            }
            delete2 = false;
            File file2 = tmp;
            return file2;
        }
        finally {
            if (delete2) {
                FileUtils.delete(tmp, 2);
            }
        }
    }

    void writeHeader(OutputStream out, int type2, long len) throws IOException {
        out.write(Constants.encodedTypeString(type2));
        out.write(32);
        out.write(Constants.encodeASCII(len));
        out.write(0);
    }

    File newTempFile() throws IOException {
        return File.createTempFile("noz", null, this.db.getDirectory());
    }

    DeflaterOutputStream compress(OutputStream out) {
        if (this.deflate == null) {
            this.deflate = new Deflater(this.config.getCompression());
        } else {
            this.deflate.reset();
        }
        return new DeflaterOutputStream(out, this.deflate, 8192);
    }

    private static EOFException shortInput(long missing) {
        return new EOFException(MessageFormat.format(JGitText.get().inputDidntMatchLength, missing));
    }

    private static class SHA1OutputStream
    extends FilterOutputStream {
        private final SHA1 md;

        SHA1OutputStream(OutputStream out, SHA1 md) {
            super(out);
            this.md = md;
        }

        @Override
        public void write(int b) throws IOException {
            this.md.update((byte)b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] in, int p, int n) throws IOException {
            this.md.update(in, p, n);
            this.out.write(in, p, n);
        }
    }
}

