/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class StringUtils {
    public static String clean(String str2) {
        return str2 == null ? "" : str2.trim();
    }

    public static String trim(String str2) {
        return str2 == null ? null : str2.trim();
    }

    public static String deleteWhitespace(String str2) {
        StringBuilder buffer = new StringBuilder();
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            buffer.append(str2.charAt(i));
        }
        return buffer.toString();
    }

    public static boolean isNotEmpty(String str2) {
        return str2 != null && !str2.isEmpty();
    }

    public static boolean isEmpty(String str2) {
        return str2 == null || str2.trim().isEmpty();
    }

    public static boolean isBlank(String str2) {
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str2) {
        return !StringUtils.isBlank(str2);
    }

    @Deprecated
    public static boolean equals(String str1, String str2) {
        return Objects.equals(str1, str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static int indexOfAny(String str2, String[] searchStrs) {
        if (str2 == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        for (String searchStr : searchStrs) {
            int tmp = str2.indexOf(searchStr);
            if (tmp == -1 || tmp >= ret) continue;
            ret = tmp;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int lastIndexOfAny(String str2, String[] searchStrs) {
        if (str2 == null || searchStrs == null) {
            return -1;
        }
        int ret = -1;
        for (String searchStr : searchStrs) {
            int tmp = str2.lastIndexOf(searchStr);
            if (tmp <= ret) continue;
            ret = tmp;
        }
        return ret;
    }

    public static String substring(String str2, int start) {
        if (str2 == null) {
            return null;
        }
        if (start < 0) {
            start = str2.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str2.length()) {
            return "";
        }
        return str2.substring(start);
    }

    public static String substring(String str2, int start, int end) {
        if (str2 == null) {
            return null;
        }
        if (end < 0) {
            end = str2.length() + end;
        }
        if (start < 0) {
            start = str2.length() + start;
        }
        if (end > str2.length()) {
            end = str2.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str2.substring(start, end);
    }

    public static String left(String str2, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str2 == null || str2.length() <= len) {
            return str2;
        }
        return str2.substring(0, len);
    }

    public static String right(String str2, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str2 == null || str2.length() <= len) {
            return str2;
        }
        return str2.substring(str2.length() - len);
    }

    public static String mid(String str2, int pos, int len) {
        if (pos < 0 || str2 != null && pos > str2.length()) {
            throw new StringIndexOutOfBoundsException("String index " + pos + " is out of bounds");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str2 == null) {
            return null;
        }
        if (str2.length() <= pos + len) {
            return str2.substring(pos);
        }
        return str2.substring(pos, pos + len);
    }

    public static String[] split(String str2) {
        return StringUtils.split(str2, null, -1);
    }

    public static String[] split(String text, String separator) {
        return StringUtils.split(text, separator, -1);
    }

    public static String[] split(String str2, String separator, int max2) {
        StringTokenizer tok = separator == null ? new StringTokenizer(str2) : new StringTokenizer(str2, separator);
        int listSize = tok.countTokens();
        if (max2 > 0 && listSize > max2) {
            listSize = max2;
        }
        String[] list = new String[listSize];
        int i = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max2 > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str2.indexOf(endToken, lastTokenEnd);
                list[i] = str2.substring(lastTokenBegin);
                break;
            }
            list[i] = tok.nextToken();
            lastTokenBegin = str2.indexOf(list[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i].length();
            ++i;
        }
        return list;
    }

    public static String concatenate(Object[] array2) {
        return StringUtils.join(array2, "");
    }

    public static String join(Object[] array2, String separator) {
        int arraySize;
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array2.length) == 0 ? 0 : (array2[0].toString().length() + separator.length()) * arraySize;
        StringBuilder buf = new StringBuilder(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(array2[i]);
        }
        return buf.toString();
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (separator == null) {
            separator = "";
        }
        StringBuilder buf = new StringBuilder(256);
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String replaceOnce(String text, char repl2, char with) {
        return StringUtils.replace(text, repl2, with, 1);
    }

    public static String replace(String text, char repl2, char with) {
        return StringUtils.replace(text, repl2, with, -1);
    }

    public static String replace(String text, char repl2, char with, int max2) {
        return StringUtils.replace(text, String.valueOf(repl2), String.valueOf(with), max2);
    }

    public static String replaceOnce(String text, String repl2, String with) {
        return StringUtils.replace(text, repl2, with, 1);
    }

    public static String replace(String text, String repl2, String with) {
        return StringUtils.replace(text, repl2, with, -1);
    }

    public static String replace(String text, String repl2, String with, int max2) {
        int end;
        if (text == null || repl2 == null || with == null || repl2.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        while ((end = text.indexOf(repl2, start)) != -1) {
            buf.append(text, start, end).append(with);
            start = end + repl2.length();
            if (--max2 != 0) continue;
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String overlayString(String text, String overlay, int start, int end) {
        return new StringBuilder(start + overlay.length() + text.length() - end + 1).append(text, 0, start).append(overlay).append(text, end, text.length()).toString();
    }

    public static String center(String str2, int size2) {
        return StringUtils.center(str2, size2, " ");
    }

    public static String center(String str2, int size2, String delim) {
        int sz = str2.length();
        int p = size2 - sz;
        if (p < 1) {
            return str2;
        }
        str2 = StringUtils.leftPad(str2, sz + p / 2, delim);
        str2 = StringUtils.rightPad(str2, size2, delim);
        return str2;
    }

    public static String chomp(String str2) {
        return StringUtils.chomp(str2, "\n");
    }

    public static String chomp(String str2, String sep) {
        int idx = str2.lastIndexOf(sep);
        if (idx != -1) {
            return str2.substring(0, idx);
        }
        return str2;
    }

    public static String chompLast(String str2) {
        return StringUtils.chompLast(str2, "\n");
    }

    public static String chompLast(String str2, String sep) {
        if (str2.length() == 0) {
            return str2;
        }
        String sub = str2.substring(str2.length() - sep.length());
        if (sep.equals(sub)) {
            return str2.substring(0, str2.length() - sep.length());
        }
        return str2;
    }

    public static String getChomp(String str2, String sep) {
        int idx = str2.lastIndexOf(sep);
        if (idx == str2.length() - sep.length()) {
            return sep;
        }
        if (idx != -1) {
            return str2.substring(idx);
        }
        return "";
    }

    public static String prechomp(String str2, String sep) {
        int idx = str2.indexOf(sep);
        if (idx != -1) {
            return str2.substring(idx + sep.length());
        }
        return str2;
    }

    public static String getPrechomp(String str2, String sep) {
        int idx = str2.indexOf(sep);
        if (idx != -1) {
            return str2.substring(0, idx + sep.length());
        }
        return "";
    }

    public static String chop(String str2) {
        if ("".equals(str2)) {
            return "";
        }
        if (str2.length() == 1) {
            return "";
        }
        int lastIdx = str2.length() - 1;
        String ret = str2.substring(0, lastIdx);
        char last = str2.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String chopNewline(String str2) {
        int lastIdx = str2.length() - 1;
        char last = str2.charAt(lastIdx);
        if (last == '\n') {
            if (str2.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else {
            ++lastIdx;
        }
        return str2.substring(0, lastIdx);
    }

    public static String escape(String str2) {
        int sz = str2.length();
        StringBuilder buffer = new StringBuilder(2 * sz);
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str2.charAt(i);
            if (ch > '\u0fff') {
                buffer.append("\\u" + Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u00ff') {
                buffer.append("\\u0" + Integer.toHexString(ch));
                continue;
            }
            if (ch > '\u007f') {
                buffer.append("\\u00" + Integer.toHexString(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00" + Integer.toHexString(ch));
                            break;
                        }
                        buffer.append("\\u000" + Integer.toHexString(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block12;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block12;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block12;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String repeat(String str2, int repeat2) {
        StringBuilder buffer = new StringBuilder(repeat2 * str2.length());
        for (int i = 0; i < repeat2; ++i) {
            buffer.append(str2);
        }
        return buffer.toString();
    }

    public static String rightPad(String str2, int size2) {
        return StringUtils.rightPad(str2, size2, " ");
    }

    public static String rightPad(String str2, int size2, String delim) {
        if ((size2 = (size2 - str2.length()) / delim.length()) > 0) {
            str2 = str2 + StringUtils.repeat(delim, size2);
        }
        return str2;
    }

    public static String leftPad(String str2, int size2) {
        return StringUtils.leftPad(str2, size2, " ");
    }

    public static String leftPad(String str2, int size2, String delim) {
        if ((size2 = (size2 - str2.length()) / delim.length()) > 0) {
            str2 = StringUtils.repeat(delim, size2) + str2;
        }
        return str2;
    }

    public static String strip(String str2) {
        return StringUtils.strip(str2, null);
    }

    public static String strip(String str2, String delim) {
        str2 = StringUtils.stripStart(str2, delim);
        return StringUtils.stripEnd(str2, delim);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String delimiter) {
        if (strs == null || strs.length == 0) {
            return strs;
        }
        int sz = strs.length;
        String[] newArr = new String[sz];
        for (int i = 0; i < sz; ++i) {
            newArr[i] = StringUtils.strip(strs[i], delimiter);
        }
        return newArr;
    }

    public static String stripEnd(String str2, String strip) {
        int end;
        if (str2 == null) {
            return null;
        }
        if (strip == null) {
            for (end = str2.length(); end != 0 && Character.isWhitespace(str2.charAt(end - 1)); --end) {
            }
        } else {
            while (end != 0 && strip.indexOf(str2.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str2.substring(0, end);
    }

    public static String stripStart(String str2, String strip) {
        int start;
        if (str2 == null) {
            return null;
        }
        int sz = str2.length();
        if (strip == null) {
            for (start = 0; start != sz && Character.isWhitespace(str2.charAt(start)); ++start) {
            }
        } else {
            while (start != sz && strip.indexOf(str2.charAt(start)) != -1) {
                ++start;
            }
        }
        return str2.substring(start);
    }

    public static String upperCase(String str2) {
        if (str2 == null) {
            return null;
        }
        return str2.toUpperCase();
    }

    public static String lowerCase(String str2) {
        if (str2 == null) {
            return null;
        }
        return str2.toLowerCase();
    }

    public static String uncapitalise(String str2) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() == 0) {
            return "";
        }
        return new StringBuilder(str2.length()).append(Character.toLowerCase(str2.charAt(0))).append(str2, 1, str2.length()).toString();
    }

    public static String capitalise(String str2) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() == 0) {
            return "";
        }
        return new StringBuilder(str2.length()).append(Character.toTitleCase(str2.charAt(0))).append(str2, 1, str2.length()).toString();
    }

    public static String swapCase(String str2) {
        if (str2 == null) {
            return null;
        }
        int sz = str2.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean whitespace = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str2.charAt(i);
            char tmp = Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isTitleCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? (whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch)) : ch));
            buffer.append(tmp);
            whitespace = Character.isWhitespace(ch);
        }
        return buffer.toString();
    }

    public static String capitaliseAllWords(String str2) {
        if (str2 == null) {
            return null;
        }
        int sz = str2.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str2.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String uncapitaliseAllWords(String str2) {
        if (str2 == null) {
            return null;
        }
        int sz = str2.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str2.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toLowerCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String getNestedString(String str2, String tag) {
        return StringUtils.getNestedString(str2, tag, tag);
    }

    public static String getNestedString(String str2, String open, String close) {
        int end;
        if (str2 == null) {
            return null;
        }
        int start = str2.indexOf(open);
        if (start != -1 && (end = str2.indexOf(close, start + open.length())) != -1) {
            return str2.substring(start + open.length(), end);
        }
        return null;
    }

    public static int countMatches(String str2, String sub) {
        if (sub.equals("")) {
            return 0;
        }
        if (str2 == null) {
            return 0;
        }
        int count2 = 0;
        int idx = 0;
        while ((idx = str2.indexOf(sub, idx)) != -1) {
            ++count2;
            idx += sub.length();
        }
        return count2;
    }

    public static boolean isAlpha(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(str2.charAt(i)) || str2.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str2.charAt(i)) || str2.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String str2) {
        if (str2 == null) {
            return false;
        }
        int sz = str2.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str2.charAt(i)) || str2.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String defaultString(Object obj) {
        return StringUtils.defaultString(obj, "");
    }

    @Deprecated
    public static String defaultString(Object obj, String defaultString) {
        return Objects.toString(obj, defaultString);
    }

    public static String reverse(String str2) {
        if (str2 == null) {
            return null;
        }
        return new StringBuilder(str2).reverse().toString();
    }

    public static String reverseDelimitedString(String str2, String delimiter) {
        Object[] strs = StringUtils.split(str2, delimiter);
        StringUtils.reverseArray(strs);
        return StringUtils.join(strs, delimiter);
    }

    private static void reverseArray(Object[] array2) {
        int i = 0;
        for (int j = array2.length - 1; j > i; --j, ++i) {
            Object tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static String abbreviate(String s2, int maxWidth) {
        return StringUtils.abbreviate(s2, 0, maxWidth);
    }

    public static String abbreviate(String s2, int offset, int maxWidth) {
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (s2.length() <= maxWidth) {
            return s2;
        }
        if (offset > s2.length()) {
            offset = s2.length();
        }
        if (s2.length() - offset < maxWidth - 3) {
            offset = s2.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return s2.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < s2.length()) {
            return "..." + StringUtils.abbreviate(s2.substring(offset), maxWidth - 3);
        }
        return "..." + s2.substring(s2.length() - (maxWidth - 3));
    }

    public static String difference(String s1, String s2) {
        int at = StringUtils.differenceAt(s1, s2);
        if (at == -1) {
            return "";
        }
        return s2.substring(at);
    }

    public static int differenceAt(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        if (i < s2.length() || i < s1.length()) {
            return i;
        }
        return -1;
    }

    public static String interpolate(String text, Map<?, ?> namespace2) {
        Iterator<?> keys2 = namespace2.keySet().iterator();
        while (keys2.hasNext()) {
            String key2 = keys2.next().toString();
            Object obj = namespace2.get(key2);
            if (obj == null) {
                throw new NullPointerException("The value of the key '" + key2 + "' is null.");
            }
            String value = obj.toString();
            text = StringUtils.replace(text, "${" + key2 + "}", value);
            if (key2.contains(" ")) continue;
            text = StringUtils.replace(text, "$" + key2, value);
        }
        return text;
    }

    public static String removeAndHump(String data2, String replaceThis) {
        StringBuilder out = new StringBuilder();
        String temp = data2;
        StringTokenizer st = new StringTokenizer(temp, replaceThis);
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(StringUtils.capitalizeFirstLetter(element));
        }
        return out.toString();
    }

    public static String capitalizeFirstLetter(String data2) {
        char firstLetter = Character.toTitleCase(data2.substring(0, 1).charAt(0));
        String restLetters = data2.substring(1);
        return firstLetter + restLetters;
    }

    public static String lowercaseFirstLetter(String data2) {
        char firstLetter = Character.toLowerCase(data2.substring(0, 1).charAt(0));
        String restLetters = data2.substring(1);
        return firstLetter + restLetters;
    }

    public static String addAndDeHump(String view) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < view.length(); ++i) {
            if (i != 0 && Character.isUpperCase(view.charAt(i))) {
                sb.append('-');
            }
            sb.append(view.charAt(i));
        }
        return sb.toString().trim().toLowerCase(Locale.ENGLISH);
    }

    public static String quoteAndEscape(String source2, char quoteChar) {
        return StringUtils.quoteAndEscape(source2, quoteChar, new char[]{quoteChar}, new char[]{' '}, '\\', false);
    }

    public static String quoteAndEscape(String source2, char quoteChar, char[] quotingTriggers) {
        return StringUtils.quoteAndEscape(source2, quoteChar, new char[]{quoteChar}, quotingTriggers, '\\', false);
    }

    public static String quoteAndEscape(String source2, char quoteChar, char[] escapedChars, char escapeChar, boolean force2) {
        return StringUtils.quoteAndEscape(source2, quoteChar, escapedChars, new char[]{' '}, escapeChar, force2);
    }

    public static String quoteAndEscape(String source2, char quoteChar, char[] escapedChars, char[] quotingTriggers, char escapeChar, boolean force2) {
        return StringUtils.quoteAndEscape(source2, quoteChar, escapedChars, quotingTriggers, escapeChar + "%s", force2);
    }

    public static String quoteAndEscape(String source2, char quoteChar, char[] escapedChars, char[] quotingTriggers, String escapePattern, boolean force2) {
        if (source2 == null) {
            return null;
        }
        if (!force2 && source2.startsWith(Character.toString(quoteChar)) && source2.endsWith(Character.toString(quoteChar))) {
            return source2;
        }
        String escaped = StringUtils.escape(source2, escapedChars, escapePattern);
        boolean quote = false;
        if (force2) {
            quote = true;
        } else if (!escaped.equals(source2)) {
            quote = true;
        } else {
            for (char quotingTrigger : quotingTriggers) {
                if (escaped.indexOf(quotingTrigger) <= -1) continue;
                quote = true;
                break;
            }
        }
        if (quote) {
            return quoteChar + escaped + quoteChar;
        }
        return escaped;
    }

    public static String escape(String source2, char[] escapedChars, char escapeChar) {
        return StringUtils.escape(source2, escapedChars, escapeChar + "%s");
    }

    public static String escape(String source2, char[] escapedChars, String escapePattern) {
        if (source2 == null) {
            return null;
        }
        char[] eqc = new char[escapedChars.length];
        System.arraycopy(escapedChars, 0, eqc, 0, escapedChars.length);
        Arrays.sort(eqc);
        StringBuilder buffer = new StringBuilder(source2.length());
        for (int i = 0; i < source2.length(); ++i) {
            char c = source2.charAt(i);
            int result = Arrays.binarySearch(eqc, c);
            if (result > -1) {
                buffer.append(String.format(escapePattern, Character.valueOf(c)));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String removeDuplicateWhitespace(String s2) {
        StringBuilder result = new StringBuilder();
        int length = s2.length();
        boolean isPreviousWhiteSpace = false;
        for (int i = 0; i < length; ++i) {
            char c = s2.charAt(i);
            boolean thisCharWhiteSpace = Character.isWhitespace(c);
            if (!isPreviousWhiteSpace || !thisCharWhiteSpace) {
                result.append(c);
            }
            isPreviousWhiteSpace = thisCharWhiteSpace;
        }
        return result.toString();
    }

    public static String unifyLineSeparators(String s2) {
        return StringUtils.unifyLineSeparators(s2, System.getProperty("line.separator"));
    }

    public static String unifyLineSeparators(String s2, String ls) {
        if (s2 == null) {
            return null;
        }
        if (ls == null) {
            ls = System.getProperty("line.separator");
        }
        if (!(ls.equals("\n") || ls.equals("\r") || ls.equals("\r\n"))) {
            throw new IllegalArgumentException("Requested line separator is invalid.");
        }
        int length = s2.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            if (s2.charAt(i) == '\r') {
                if (i + 1 < length && s2.charAt(i + 1) == '\n') {
                    ++i;
                }
                buffer.append(ls);
                continue;
            }
            if (s2.charAt(i) == '\n') {
                buffer.append(ls);
                continue;
            }
            buffer.append(s2.charAt(i));
        }
        return buffer.toString();
    }

    public static boolean contains(String str2, char searchChar) {
        if (StringUtils.isEmpty(str2)) {
            return false;
        }
        return str2.indexOf(searchChar) >= 0;
    }

    public static boolean contains(String str2, String searchStr) {
        if (str2 == null || searchStr == null) {
            return false;
        }
        return str2.contains(searchStr);
    }
}

