/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.StringTokenizer;
import org.codehaus.plexus.util.StringUtils;

public class PathTool {
    public static final String getRelativePath(String basedir, String filename) {
        basedir = PathTool.uppercaseDrive(basedir);
        filename = PathTool.uppercaseDrive(filename);
        if (basedir == null || basedir.length() == 0 || filename == null || filename.length() == 0 || !filename.startsWith(basedir)) {
            return "";
        }
        String separator = PathTool.determineSeparator(filename);
        basedir = StringUtils.chompLast(basedir, separator);
        filename = StringUtils.chompLast(filename, separator);
        String relativeFilename = filename.substring(basedir.length());
        return PathTool.determineRelativePath(relativeFilename, separator);
    }

    public static final String getRelativePath(String filename) {
        if ((filename = PathTool.uppercaseDrive(filename)) == null || filename.length() == 0) {
            return "";
        }
        String separator = PathTool.determineSeparator(filename);
        if (!(filename = StringUtils.chompLast(filename, separator)).startsWith(separator)) {
            filename = separator + filename;
        }
        return PathTool.determineRelativePath(filename, separator);
    }

    public static final String getDirectoryComponent(String filename) {
        if (filename == null || filename.length() == 0) {
            return "";
        }
        String separator = PathTool.determineSeparator(filename);
        String directory = StringUtils.chomp(filename, separator);
        if (filename.equals(directory)) {
            return ".";
        }
        return directory;
    }

    public static final String calculateLink(String link2, String relativePath) {
        if (link2 == null) {
            link2 = "";
        }
        if (relativePath == null) {
            relativePath = "";
        }
        if (link2.startsWith("/site/")) {
            return link2.substring(5);
        }
        if (link2.startsWith("/absolute/")) {
            return link2.substring(10);
        }
        if (link2.contains(":")) {
            return link2;
        }
        if (StringUtils.equals(relativePath, ".")) {
            if (link2.startsWith("/")) {
                return link2.substring(1);
            }
            return link2;
        }
        if (relativePath.endsWith("/") && link2.startsWith("/")) {
            return relativePath + "." + link2.substring(1);
        }
        if (relativePath.endsWith("/") || link2.startsWith("/")) {
            return relativePath + link2;
        }
        return relativePath + "/" + link2;
    }

    public static final String getRelativeWebPath(String oldPath, String newPath) {
        if (StringUtils.isEmpty(oldPath) || StringUtils.isEmpty(newPath)) {
            return "";
        }
        String resultPath = PathTool.buildRelativePath(newPath, oldPath, '/');
        if (newPath.endsWith("/") && !resultPath.endsWith("/")) {
            return resultPath + "/";
        }
        return resultPath;
    }

    public static final String getRelativeFilePath(String oldPath, String newPath) {
        if (StringUtils.isEmpty(oldPath) || StringUtils.isEmpty(newPath)) {
            return "";
        }
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String resultPath = PathTool.buildRelativePath(toPath, fromPath, File.separatorChar);
        if (newPath.endsWith(File.separator) && !resultPath.endsWith(File.separator)) {
            return resultPath + File.separator;
        }
        return resultPath;
    }

    private static final String determineRelativePath(String filename, String separator) {
        if (filename.length() == 0) {
            return "";
        }
        int slashCount = StringUtils.countMatches(filename, separator) - 1;
        if (slashCount <= 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slashCount; ++i) {
            sb.append("../");
        }
        return StringUtils.chop(sb.toString());
    }

    private static final String determineSeparator(String filename) {
        int backwardCount;
        int forwardCount = StringUtils.countMatches(filename, "/");
        return forwardCount >= (backwardCount = StringUtils.countMatches(filename, "\\")) ? "/" : "\\";
    }

    static final String uppercaseDrive(String path2) {
        if (path2 == null) {
            return null;
        }
        if (path2.length() >= 2 && path2.charAt(1) == ':') {
            path2 = Character.toUpperCase(path2.charAt(0)) + path2.substring(1);
        }
        return path2;
    }

    private static final String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count2 = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count2;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count2-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        String relativePath = "";
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath = relativePath + "..";
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + separatorChar;
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + toTokeniser.nextToken();
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        return relativePath;
    }
}

