/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.util.Collection;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public abstract class AbstractCollectionConverter
extends AbstractConfigurationConverter {
    protected abstract Collection<Object> instantiateCollection(PlexusConfiguration var1, Class<?> var2, ClassLoader var3) throws ComponentConfigurationException;

    protected final Collection<Object> fromChildren(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener, Class<?> elementType) throws ComponentConfigurationException {
        Collection<Object> elements = this.instantiateCollection(configuration, type2, loader);
        int i = 0;
        int size2 = configuration.getChildCount();
        while (i < size2) {
            PlexusConfiguration xml2 = configuration.getChild(i);
            Class<?> childType = this.getChildType(xml2, enclosingType, loader, elementType);
            ConfigurationConverter converter = lookup.lookupConverterForType(childType);
            elements.add(converter.fromConfiguration(lookup, xml2, childType, enclosingType, loader, evaluator, listener));
            ++i;
        }
        return elements;
    }

    protected final Class<?> getChildType(PlexusConfiguration childConfiguration, Class<?> enclosingType, ClassLoader loader, Class<?> elementType) throws ComponentConfigurationException {
        String childName = this.fromXML(childConfiguration.getName());
        Class<Object> childType = this.getClassForImplementationHint(null, childConfiguration, loader);
        Throwable cause = null;
        if (childType == null && childName.indexOf(46) > 0) {
            try {
                childType = loader.loadClass(childName);
            }
            catch (Exception e2) {
                cause = e2;
            }
            catch (LinkageError e3) {
                cause = e3;
            }
        }
        if (childType == null) {
            try {
                childType = loader.loadClass(AbstractCollectionConverter.alignPackageName(enclosingType.getName(), childName));
            }
            catch (Exception e4) {
                cause = e4;
            }
            catch (LinkageError e5) {
                cause = e5;
            }
        }
        if (childType == null) {
            if (elementType != null && Object.class != elementType) {
                childType = elementType;
            } else if (childConfiguration.getChildCount() == 0) {
                childType = String.class;
            } else {
                throw new ComponentConfigurationException("Cannot determine child type", cause);
            }
        }
        return childType;
    }

    protected static final PlexusConfiguration csvToXml(PlexusConfiguration configuration, String csv) {
        XmlPlexusConfiguration xml2 = new XmlPlexusConfiguration(configuration.getName());
        if (csv.length() > 0) {
            String[] stringArray = csv.split(",", -1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                xml2.addChild("#", token);
                ++n2;
            }
        }
        return xml2;
    }

    private static String alignPackageName(String enclosingName, String childName) {
        String pkgPrefix = enclosingName.substring(0, enclosingName.lastIndexOf(46) + 1);
        String clzSuffix = String.valueOf(Character.toTitleCase(childName.charAt(0))) + childName.substring(1);
        return String.valueOf(pkgPrefix) + clzSuffix;
    }
}

