/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import junit.framework.TestCase;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;

public abstract class PlexusTestCase
extends TestCase {
    private static final String PLEXUS_HOME = "plexus.home";
    private volatile PlexusContainer container;

    public static String getBasedir() {
        return Lazy.BASEDIR;
    }

    public static File getTestFile(String path2) {
        return PlexusTestCase.getTestFile(PlexusTestCase.getBasedir(), path2);
    }

    public static File getTestFile(String basedir, String path2) {
        File root2 = new File(basedir);
        if (!root2.isAbsolute()) {
            root2 = new File(PlexusTestCase.getBasedir(), basedir);
        }
        return new File(root2, path2);
    }

    public static String getTestPath(String path2) {
        return PlexusTestCase.getTestFile(path2).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path2) {
        return PlexusTestCase.getTestFile(basedir, path2).getAbsolutePath();
    }

    public static String getTestConfiguration(Class<?> clazz) {
        String name2 = clazz.getName();
        int i = name2.indexOf(36);
        return String.valueOf((i < 0 ? name2 : name2.substring(0, i)).replace('.', '/')) + ".xml";
    }

    public final String getTestConfiguration() {
        return PlexusTestCase.getTestConfiguration(((Object)((Object)this)).getClass());
    }

    protected void customizeContext(Context context) {
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected void customizeContainerConfiguration(ContainerConfiguration configuration) {
    }

    protected void setUp() throws Exception {
    }

    protected PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected synchronized void setupContainer() {
        if (this.container == null) {
            try {
                this.container = new DefaultPlexusContainer(this.config());
            }
            catch (PlexusContainerException e2) {
                throw new IllegalArgumentException(e2);
            }
        }
    }

    protected synchronized void teardownContainer() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    protected void tearDown() throws Exception {
        if (this.container != null) {
            this.teardownContainer();
        }
    }

    protected final String getConfigurationName(String name2) {
        return this.getTestConfiguration();
    }

    protected final ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected final InputStream getResourceAsStream(String name2) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(name2);
    }

    protected final Object lookup(String role) throws ComponentLookupException {
        return this.getContainer().lookup(role);
    }

    protected final Object lookup(String role, String hint) throws ComponentLookupException {
        return this.getContainer().lookup(role, hint);
    }

    protected final <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.getContainer().lookup(role);
    }

    protected final <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.getContainer().lookup(role, hint);
    }

    protected final void release(Object component2) throws ComponentLifecycleException {
        this.getContainer().release(component2);
    }

    private final ContainerConfiguration config() {
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setName("test").setContext(this.context());
        String path2 = this.getCustomConfigurationName();
        if (path2 == null) {
            path2 = this.getConfigurationName(null);
        }
        config.setContainerConfiguration(path2);
        this.customizeContainerConfiguration(config);
        return config;
    }

    private final Map<Object, Object> context() {
        DefaultContext context = new DefaultContext();
        context.put("basedir", PlexusTestCase.getBasedir());
        this.customizeContext(context);
        if (!context.contains(PLEXUS_HOME)) {
            context.put(PLEXUS_HOME, PlexusTestCase.plexusHome());
        }
        return context.getContextData();
    }

    private static String plexusHome() {
        File home = PlexusTestCase.getTestFile("target/plexus-home");
        if (!home.isDirectory()) {
            home.mkdirs();
        }
        return home.getAbsolutePath();
    }

    private static final class Lazy {
        static final String BASEDIR;

        static {
            String path2 = System.getProperty("basedir");
            BASEDIR = path2 != null ? path2 : new File("").getAbsolutePath();
        }

        private Lazy() {
        }
    }
}

