/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.codehaus.plexus.util.dag.Vertex;

public class ProjectSorter {
    private DAG dag = new DAG();
    private List<MavenProject> sortedProjects;
    private Map<String, MavenProject> projectMap;
    private MavenProject topLevelProject;

    public ProjectSorter(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        String projectId;
        this.projectMap = new HashMap<String, MavenProject>(projects.size() * 2);
        HashMap<String, Map<String, Vertex>> vertexMap = new HashMap<String, Map<String, Vertex>>(projects.size() * 2);
        for (MavenProject project2 : projects) {
            projectId = ProjectSorter.getId(project2);
            MavenProject conflictingProject = this.projectMap.put(projectId, project2);
            if (conflictingProject != null) {
                throw new DuplicateProjectException(projectId, conflictingProject.getFile(), project2.getFile(), "Project '" + projectId + "' is duplicated in the reactor");
            }
            String projectKey = ArtifactUtils.versionlessKey(project2.getGroupId(), project2.getArtifactId());
            HashMap<String, Vertex> vertices = (HashMap<String, Vertex>)vertexMap.get(projectKey);
            if (vertices == null) {
                vertices = new HashMap<String, Vertex>(2, 1.0f);
                vertexMap.put(projectKey, vertices);
            }
            vertices.put(project2.getVersion(), this.dag.addVertex(projectId));
        }
        for (Vertex projectVertex : this.dag.getVertices()) {
            List<Extension> buildExtensions;
            List<Plugin> buildPlugins;
            projectId = projectVertex.getLabel();
            MavenProject project3 = this.projectMap.get(projectId);
            for (Dependency dependency : project3.getDependencies()) {
                this.addEdge(this.projectMap, vertexMap, project3, projectVertex, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false, false);
            }
            Parent parent2 = project3.getModel().getParent();
            if (parent2 != null) {
                this.addEdge(this.projectMap, vertexMap, null, projectVertex, parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion(), true, false);
            }
            if ((buildPlugins = project3.getBuildPlugins()) != null) {
                for (Plugin plugin : buildPlugins) {
                    this.addEdge(this.projectMap, vertexMap, project3, projectVertex, plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), false, true);
                    for (Dependency dependency : plugin.getDependencies()) {
                        this.addEdge(this.projectMap, vertexMap, project3, projectVertex, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false, true);
                    }
                }
            }
            if ((buildExtensions = project3.getBuildExtensions()) == null) continue;
            for (Extension extension2 : buildExtensions) {
                this.addEdge(this.projectMap, vertexMap, project3, projectVertex, extension2.getGroupId(), extension2.getArtifactId(), extension2.getVersion(), false, true);
            }
        }
        ArrayList<MavenProject> sortedProjects = new ArrayList<MavenProject>(projects.size());
        List<String> sortedProjectLabels = TopologicalSorter.sort(this.dag);
        for (String id : sortedProjectLabels) {
            sortedProjects.add(this.projectMap.get(id));
        }
        this.sortedProjects = Collections.unmodifiableList(sortedProjects);
    }

    private void addEdge(Map<String, MavenProject> projectMap, Map<String, Map<String, Vertex>> vertexMap, MavenProject project2, Vertex projectVertex, String groupId, String artifactId, String version, boolean force2, boolean safe) throws CycleDetectedException {
        String projectKey = ArtifactUtils.versionlessKey(groupId, artifactId);
        Map<String, Vertex> vertices = vertexMap.get(projectKey);
        if (vertices != null) {
            if (this.isSpecificVersion(version)) {
                Vertex vertex = vertices.get(version);
                if (vertex != null) {
                    this.addEdge(projectVertex, vertex, project2, projectMap, force2, safe);
                }
            } else {
                for (Vertex vertex : vertices.values()) {
                    this.addEdge(projectVertex, vertex, project2, projectMap, force2, safe);
                }
            }
        }
    }

    private void addEdge(Vertex fromVertex, Vertex toVertex, MavenProject fromProject, Map<String, MavenProject> projectMap, boolean force2, boolean safe) throws CycleDetectedException {
        block5: {
            if (fromVertex.equals(toVertex)) {
                return;
            }
            if (fromProject != null) {
                MavenProject toProject = projectMap.get(toVertex.getLabel());
                fromProject.addProjectReference(toProject);
            }
            if (force2 && toVertex.getChildren().contains(fromVertex)) {
                this.dag.removeEdge(toVertex, fromVertex);
            }
            try {
                this.dag.addEdge(fromVertex, toVertex);
            }
            catch (CycleDetectedException e2) {
                if (safe) break block5;
                throw e2;
            }
        }
    }

    private boolean isSpecificVersion(String version) {
        return !StringUtils.isEmpty(version) && !version.startsWith("[") && !version.startsWith("(");
    }

    public MavenProject getTopLevelProject() {
        if (this.topLevelProject == null) {
            Iterator<MavenProject> i = this.sortedProjects.iterator();
            while (i.hasNext() && this.topLevelProject == null) {
                MavenProject project2 = i.next();
                if (!project2.isExecutionRoot()) continue;
                this.topLevelProject = project2;
            }
        }
        return this.topLevelProject;
    }

    public List<MavenProject> getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List<String> getDependents(String id) {
        return this.dag.getParentLabels(id);
    }

    public List<String> getDependencies(String id) {
        return this.dag.getChildLabels(id);
    }

    public static String getId(MavenProject project2) {
        return ArtifactUtils.key(project2.getGroupId(), project2.getArtifactId(), project2.getVersion());
    }

    public DAG getDAG() {
        return this.dag;
    }

    public Map<String, MavenProject> getProjectMap() {
        return this.projectMap;
    }
}

