/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.util.Os;

@Named(value="os")
@Singleton
public class OperatingSystemProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile2, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile2.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationOS os = activation.getOs();
        if (os == null) {
            return false;
        }
        boolean active = this.ensureAtLeastOneNonNull(os);
        if (active && os.getFamily() != null) {
            active = this.determineFamilyMatch(os.getFamily());
        }
        if (active && os.getName() != null) {
            active = this.determineNameMatch(os.getName());
        }
        if (active && os.getArch() != null) {
            active = this.determineArchMatch(os.getArch());
        }
        if (active && os.getVersion() != null) {
            active = this.determineVersionMatch(os.getVersion());
        }
        return active;
    }

    @Override
    public boolean presentInConfig(Profile profile2, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile2.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationOS os = activation.getOs();
        return os != null;
    }

    private boolean ensureAtLeastOneNonNull(ActivationOS os) {
        return os.getArch() != null || os.getFamily() != null || os.getName() != null || os.getVersion() != null;
    }

    private boolean determineVersionMatch(String version) {
        String test2 = version;
        boolean reverse2 = false;
        if (test2.startsWith("!")) {
            reverse2 = true;
            test2 = test2.substring(1);
        }
        boolean result = Os.isVersion(test2);
        return reverse2 ? !result : result;
    }

    private boolean determineArchMatch(String arch) {
        String test2 = arch;
        boolean reverse2 = false;
        if (test2.startsWith("!")) {
            reverse2 = true;
            test2 = test2.substring(1);
        }
        boolean result = Os.isArch(test2);
        return reverse2 ? !result : result;
    }

    private boolean determineNameMatch(String name2) {
        String test2 = name2;
        boolean reverse2 = false;
        if (test2.startsWith("!")) {
            reverse2 = true;
            test2 = test2.substring(1);
        }
        boolean result = Os.isName(test2);
        return reverse2 ? !result : result;
    }

    private boolean determineFamilyMatch(String family) {
        String test2 = family;
        boolean reverse2 = false;
        if (test2.startsWith("!")) {
            reverse2 = true;
            test2 = test2.substring(1);
        }
        boolean result = Os.isFamily(test2);
        return reverse2 ? !result : result;
    }
}

