/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.StringUtils;

@Named(value="file")
@Singleton
public class FileProfileActivator
implements ProfileActivator {
    @Inject
    private PathTranslator pathTranslator;

    public FileProfileActivator setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }

    @Override
    public boolean isActive(Profile profile2, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path2;
        Activation activation = profile2.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file2 = activation.getFile();
        if (file2 == null) {
            return false;
        }
        if (StringUtils.isNotEmpty(file2.getExists())) {
            path2 = file2.getExists();
            missing = false;
        } else if (StringUtils.isNotEmpty(file2.getMissing())) {
            path2 = file2.getMissing();
            missing = true;
        } else {
            return false;
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        final File basedir = context.getProjectDirectory();
        if (basedir != null) {
            interpolator.addValueSource(new AbstractValueSource(false){

                @Override
                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return basedir.getAbsolutePath();
                    }
                    return null;
                }
            });
        } else if (path2.contains("${basedir}")) {
            return false;
        }
        interpolator.addValueSource(new MapBasedValueSource(context.getProjectProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getUserProperties()));
        interpolator.addValueSource(new MapBasedValueSource(context.getSystemProperties()));
        try {
            path2 = interpolator.interpolate(path2, "");
        }
        catch (Exception e2) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate file location " + path2 + " for profile " + profile2.getId() + ": " + e2.getMessage()).setLocation(file2.getLocation(missing ? "missing" : "exists")).setException(e2));
            return false;
        }
        path2 = this.pathTranslator.alignToBaseDirectory(path2, basedir);
        if (missing) {
            file2.setMissing(path2);
        } else {
            file2.setExists(path2);
        }
        File f = new File(path2);
        if (!f.isAbsolute()) {
            return false;
        }
        boolean fileExists = f.exists();
        return missing ? !fileExists : fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile2, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile2.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file2 = activation.getFile();
        return file2 != null;
    }
}

