/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Scm;

public class Model
extends ModelBase
implements Serializable,
Cloneable {
    private String modelVersion;
    private Parent parent;
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging = "jar";
    private String name;
    private String description;
    private String url;
    private String childProjectUrlInheritAppendPath;
    private String inceptionYear;
    private Organization organization;
    private List<License> licenses;
    private List<Developer> developers;
    private List<Contributor> contributors;
    private List<MailingList> mailingLists;
    private Prerequisites prerequisites;
    private Scm scm;
    private IssueManagement issueManagement;
    private CiManagement ciManagement;
    private Build build;
    private List<Profile> profiles;
    private String modelEncoding = "UTF-8";
    private File pomFile;

    public void addContributor(Contributor contributor) {
        this.getContributors().add(contributor);
    }

    public void addDeveloper(Developer developer) {
        this.getDevelopers().add(developer);
    }

    public void addLicense(License license) {
        this.getLicenses().add(license);
    }

    public void addMailingList(MailingList mailingList) {
        this.getMailingLists().add(mailingList);
    }

    public void addProfile(Profile profile2) {
        this.getProfiles().add(profile2);
    }

    @Override
    public Model clone() {
        try {
            Model copy2 = (Model)super.clone();
            if (this.parent != null) {
                copy2.parent = this.parent.clone();
            }
            if (this.organization != null) {
                copy2.organization = this.organization.clone();
            }
            if (this.licenses != null) {
                copy2.licenses = new ArrayList<License>();
                for (License license : this.licenses) {
                    copy2.licenses.add(license.clone());
                }
            }
            if (this.developers != null) {
                copy2.developers = new ArrayList<Developer>();
                for (Developer developer : this.developers) {
                    copy2.developers.add(developer.clone());
                }
            }
            if (this.contributors != null) {
                copy2.contributors = new ArrayList<Contributor>();
                for (Contributor contributor : this.contributors) {
                    copy2.contributors.add(contributor.clone());
                }
            }
            if (this.mailingLists != null) {
                copy2.mailingLists = new ArrayList<MailingList>();
                for (MailingList mailingList : this.mailingLists) {
                    copy2.mailingLists.add(mailingList.clone());
                }
            }
            if (this.prerequisites != null) {
                copy2.prerequisites = this.prerequisites.clone();
            }
            if (this.scm != null) {
                copy2.scm = this.scm.clone();
            }
            if (this.issueManagement != null) {
                copy2.issueManagement = this.issueManagement.clone();
            }
            if (this.ciManagement != null) {
                copy2.ciManagement = this.ciManagement.clone();
            }
            if (this.build != null) {
                copy2.build = this.build.clone();
            }
            if (this.profiles != null) {
                copy2.profiles = new ArrayList<Profile>();
                for (Profile profile2 : this.profiles) {
                    copy2.profiles.add(profile2.clone());
                }
            }
            this.cloneHook(copy2);
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getChildProjectUrlInheritAppendPath() {
        return this.childProjectUrlInheritAppendPath;
    }

    public CiManagement getCiManagement() {
        return this.ciManagement;
    }

    public List<Contributor> getContributors() {
        if (this.contributors == null) {
            this.contributors = new ArrayList<Contributor>();
        }
        return this.contributors;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Developer> getDevelopers() {
        if (this.developers == null) {
            this.developers = new ArrayList<Developer>();
        }
        return this.developers;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public IssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    public List<License> getLicenses() {
        if (this.licenses == null) {
            this.licenses = new ArrayList<License>();
        }
        return this.licenses;
    }

    public List<MailingList> getMailingLists() {
        if (this.mailingLists == null) {
            this.mailingLists = new ArrayList<MailingList>();
        }
        return this.mailingLists;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public Parent getParent() {
        return this.parent;
    }

    public Prerequisites getPrerequisites() {
        return this.prerequisites;
    }

    public List<Profile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        return this.profiles;
    }

    public Scm getScm() {
        return this.scm;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeContributor(Contributor contributor) {
        this.getContributors().remove(contributor);
    }

    public void removeDeveloper(Developer developer) {
        this.getDevelopers().remove(developer);
    }

    public void removeLicense(License license) {
        this.getLicenses().remove(license);
    }

    public void removeMailingList(MailingList mailingList) {
        this.getMailingLists().remove(mailingList);
    }

    public void removeProfile(Profile profile2) {
        this.getProfiles().remove(profile2);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public void setChildProjectUrlInheritAppendPath(String childProjectUrlInheritAppendPath) {
        this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.ciManagement = ciManagement;
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDevelopers(List<Developer> developers) {
        this.developers = developers;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setInceptionYear(String inceptionYear) {
        this.inceptionYear = inceptionYear;
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.issueManagement = issueManagement;
    }

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public void setMailingLists(List<MailingList> mailingLists) {
        this.mailingLists = mailingLists;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void setParent(Parent parent2) {
        this.parent = parent2;
    }

    public void setPrerequisites(Prerequisites prerequisites) {
        this.prerequisites = prerequisites;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public void setScm(Scm scm) {
        this.scm = scm;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private void cloneHook(Model copy2) {
        copy2.pomFile = this.pomFile;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File pomFile) {
        this.pomFile = pomFile != null ? pomFile.getAbsoluteFile() : null;
    }

    public File getProjectDirectory() {
        return this.pomFile != null ? this.pomFile.getParentFile() : null;
    }

    public String getId() {
        StringBuilder id = new StringBuilder(64);
        id.append(this.getGroupId() == null ? "[inherited]" : this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId());
        id.append(":");
        id.append(this.getPackaging());
        id.append(":");
        id.append(this.getVersion() == null ? "[inherited]" : this.getVersion());
        return id.toString();
    }

    public String toString() {
        return this.getId();
    }

    public boolean isChildProjectUrlInheritAppendPath() {
        return this.childProjectUrlInheritAppendPath != null ? Boolean.parseBoolean(this.childProjectUrlInheritAppendPath) : true;
    }

    public void setChildProjectUrlInheritAppendPath(boolean childProjectUrlInheritAppendPath) {
        this.childProjectUrlInheritAppendPath = String.valueOf(childProjectUrlInheritAppendPath);
    }
}

