/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.DefaultMaven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.graph.FilteredProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;

@Component(role=GraphBuilder.class, hint="graphBuilder")
public class DefaultGraphBuilder
implements GraphBuilder {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;

    public Result<ProjectDependencyGraph> build(MavenSession session) {
        try {
            Result<ProjectDependencyGraph> result = this.sessionDependencyGraph(session);
            if (result == null) {
                List<MavenProject> projects = this.getProjectsForMavenReactor(session);
                this.validateProjects(projects);
                result = this.reactorDependencyGraph(session, projects);
            }
            return result;
        }
        catch (MavenExecutionException | DuplicateProjectException | ProjectBuildingException e2) {
            return Result.error(Collections.singletonList(new DefaultModelProblem(null, null, null, null, 0, 0, e2)));
        }
        catch (CycleDetectedException e3) {
            String message = "The projects in the reactor contain a cyclic reference: " + e3.getMessage();
            ProjectCycleException error2 = new ProjectCycleException(message, e3);
            return Result.error(Collections.singletonList(new DefaultModelProblem(null, null, null, null, 0, 0, error2)));
        }
    }

    private Result<ProjectDependencyGraph> sessionDependencyGraph(MavenSession session) throws CycleDetectedException, DuplicateProjectException {
        Result<DefaultProjectDependencyGraph> result = null;
        if (session.getProjectDependencyGraph() != null || session.getProjects() != null) {
            DefaultProjectDependencyGraph graph = new DefaultProjectDependencyGraph(session.getAllProjects(), session.getProjects());
            result = Result.success(graph);
        }
        return result;
    }

    private Result<ProjectDependencyGraph> reactorDependencyGraph(MavenSession session, List<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException, MavenExecutionException {
        ProjectDependencyGraph projectDependencyGraph = new DefaultProjectDependencyGraph(projects);
        List<MavenProject> activeProjects = projectDependencyGraph.getSortedProjects();
        activeProjects = this.trimSelectedProjects(activeProjects, projectDependencyGraph, session.getRequest());
        activeProjects = this.trimExcludedProjects(activeProjects, session.getRequest());
        if ((activeProjects = this.trimResumedProjects(activeProjects, session.getRequest())).size() != projectDependencyGraph.getSortedProjects().size()) {
            projectDependencyGraph = new FilteredProjectDependencyGraph(projectDependencyGraph, activeProjects);
        }
        return Result.success(projectDependencyGraph);
    }

    private List<MavenProject> trimSelectedProjects(List<MavenProject> projects, ProjectDependencyGraph graph, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getSelectedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> selectedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getSelectedProjects()) {
                MavenProject selectedProject = null;
                for (MavenProject project2 : projects) {
                    if (!this.isMatchingProject(project2, selector, reactorDirectory)) continue;
                    selectedProject = project2;
                    break;
                }
                if (selectedProject != null) {
                    selectedProjects.add(selectedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            boolean makeUpstream = false;
            boolean makeDownstream = false;
            if ("make-upstream".equals(request.getMakeBehavior())) {
                makeUpstream = true;
            } else if ("make-downstream".equals(request.getMakeBehavior())) {
                makeDownstream = true;
            } else if ("make-both".equals(request.getMakeBehavior())) {
                makeUpstream = true;
                makeDownstream = true;
            } else if (StringUtils.isNotEmpty(request.getMakeBehavior())) {
                throw new MavenExecutionException("Invalid reactor make behavior: " + request.getMakeBehavior(), request.getPom());
            }
            if (makeUpstream || makeDownstream) {
                for (MavenProject selectedProject : new ArrayList(selectedProjects)) {
                    if (makeUpstream) {
                        selectedProjects.addAll(graph.getUpstreamProjects(selectedProject, true));
                    }
                    if (!makeDownstream) continue;
                    selectedProjects.addAll(graph.getDownstreamProjects(selectedProject, true));
                }
            }
            result = new ArrayList<MavenProject>(selectedProjects.size());
            for (MavenProject project3 : projects) {
                if (!selectedProjects.contains(project3)) continue;
                result.add(project3);
            }
        }
        return result;
    }

    private List<MavenProject> trimExcludedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (!request.getExcludedProjects().isEmpty()) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            LinkedHashSet<MavenProject> excludedProjects = new LinkedHashSet<MavenProject>(projects.size());
            for (String selector : request.getExcludedProjects()) {
                MavenProject excludedProject = null;
                for (MavenProject project2 : projects) {
                    if (!this.isMatchingProject(project2, selector, reactorDirectory)) continue;
                    excludedProject = project2;
                    break;
                }
                if (excludedProject != null) {
                    excludedProjects.add(excludedProject);
                    continue;
                }
                throw new MavenExecutionException("Could not find the selected project in the reactor: " + selector, request.getPom());
            }
            result = new ArrayList<MavenProject>(projects.size());
            for (MavenProject project3 : projects) {
                if (excludedProjects.contains(project3)) continue;
                result.add(project3);
            }
        }
        return result;
    }

    private List<MavenProject> trimResumedProjects(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        List<MavenProject> result = projects;
        if (StringUtils.isNotEmpty(request.getResumeFrom())) {
            File reactorDirectory = null;
            if (request.getBaseDirectory() != null) {
                reactorDirectory = new File(request.getBaseDirectory());
            }
            String selector = request.getResumeFrom();
            result = new ArrayList<MavenProject>(projects.size());
            boolean resumed = false;
            for (MavenProject project2 : projects) {
                if (!resumed && this.isMatchingProject(project2, selector, reactorDirectory)) {
                    resumed = true;
                }
                if (!resumed) continue;
                result.add(project2);
            }
            if (!resumed) {
                throw new MavenExecutionException("Could not find project to resume reactor build from: " + selector + " vs " + this.formatProjects(projects), request.getPom());
            }
        }
        return result;
    }

    private String formatProjects(List<MavenProject> projects) {
        StringBuilder projectNames = new StringBuilder();
        Iterator<MavenProject> iterator = projects.iterator();
        while (iterator.hasNext()) {
            MavenProject project2 = iterator.next();
            projectNames.append(project2.getGroupId()).append(":").append(project2.getArtifactId());
            if (!iterator.hasNext()) continue;
            projectNames.append(", ");
        }
        return projectNames.toString();
    }

    private boolean isMatchingProject(MavenProject project2, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ':' + project2.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project2.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project2.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project2.getBasedir());
            }
        }
        return false;
    }

    private List<MavenProject> getProjectsForMavenReactor(MavenSession session) throws ProjectBuildingException {
        MavenExecutionRequest request = session.getRequest();
        request.getProjectBuildingRequest().setRepositorySession(session.getRepositorySession());
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        if (request.getPom() == null) {
            UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
            MavenProject project2 = this.projectBuilder.build(modelSource, request.getProjectBuildingRequest()).getProject();
            project2.setExecutionRoot(true);
            projects.add(project2);
            request.setProjectPresent(false);
            return projects;
        }
        List<File> files2 = Arrays.asList(request.getPom().getAbsoluteFile());
        this.collectProjects(projects, files2, request);
        return projects;
    }

    private void collectProjects(List<MavenProject> projects, List<File> files2, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files2, request.isRecursive(), projectBuildingRequest);
        boolean problems = false;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            if (result.getProblems().isEmpty() || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective model for " + result.getProject().getId());
            for (ModelProblem problem : result.getProblems()) {
                String loc = ModelProblemUtils.formatLocation(problem, result.getProjectId());
                this.logger.warn(problem.getMessage() + (StringUtils.isNotEmpty(loc) ? " @ " + loc : ""));
            }
            problems = true;
        }
        if (problems) {
            this.logger.warn("");
            this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            this.logger.warn("");
            this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            this.logger.warn("");
        }
    }

    private void validateProjects(List<MavenProject> projects) {
        HashMap<String, MavenProject> projectsMap = new HashMap<String, MavenProject>();
        for (MavenProject p : projects) {
            String projectKey = ArtifactUtils.key(p.getGroupId(), p.getArtifactId(), p.getVersion());
            projectsMap.put(projectKey, p);
        }
        for (MavenProject project2 : projects) {
            for (Plugin plugin : project2.getBuildPlugins()) {
                String pluginKey;
                if (!plugin.isExtensions() || !projectsMap.containsKey(pluginKey = ArtifactUtils.key(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion()))) continue;
                this.logger.warn(project2.getName() + " uses " + plugin.getKey() + " as extensions, which is not possible within the same reactor build. This plugin was pulled from the local repository!");
            }
        }
    }
}

