/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;

class RequestEntityProxy
implements HttpEntity {
    private final HttpEntity original;
    private boolean consumed = false;

    static void enhance(HttpEntityEnclosingRequest request) {
        HttpEntity entity2 = request.getEntity();
        if (entity2 != null && !entity2.isRepeatable() && !RequestEntityProxy.isEnhanced(entity2)) {
            request.setEntity(new RequestEntityProxy(entity2));
        }
    }

    static boolean isEnhanced(HttpEntity entity2) {
        return entity2 instanceof RequestEntityProxy;
    }

    static boolean isRepeatable(HttpRequest request) {
        HttpEntity entity2;
        if (request instanceof HttpEntityEnclosingRequest && (entity2 = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            RequestEntityProxy proxy2;
            if (RequestEntityProxy.isEnhanced(entity2) && !(proxy2 = (RequestEntityProxy)entity2).isConsumed()) {
                return true;
            }
            return entity2.isRepeatable();
        }
        return true;
    }

    RequestEntityProxy(HttpEntity original) {
        this.original = original;
    }

    public HttpEntity getOriginal() {
        return this.original;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public boolean isRepeatable() {
        return this.original.isRepeatable();
    }

    @Override
    public boolean isChunked() {
        return this.original.isChunked();
    }

    @Override
    public long getContentLength() {
        return this.original.getContentLength();
    }

    @Override
    public Header getContentType() {
        return this.original.getContentType();
    }

    @Override
    public Header getContentEncoding() {
        return this.original.getContentEncoding();
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.original.getContent();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.consumed = true;
        this.original.writeTo(outstream);
    }

    @Override
    public boolean isStreaming() {
        return this.original.isStreaming();
    }

    @Override
    @Deprecated
    public void consumeContent() throws IOException {
        this.consumed = true;
        this.original.consumeContent();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RequestEntityProxy{");
        sb.append(this.original);
        sb.append('}');
        return sb.toString();
    }
}

